/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec4(165l, 133l, 193l, 76l) - 0l) => i64vec4(165l, 133l, 193l, 76l)
 * (i64vec4(165l, 133l, 193l, 76l) - 3l) => i64vec4(162l, 130l, 190l, 73l)
 * (i64vec4(165l, 133l, 193l, 76l) - -1192l) => i64vec4(1357l, 1325l, 1385l, 1268l)
 * (i64vec4(165l, 133l, 193l, 76l) - 1048576l) => i64vec4(-1048411l, -1048443l, -1048383l, -1048500l)
 * (i64vec4(165l, 133l, 193l, 76l) - 4251475l) => i64vec4(-4251310l, -4251342l, -4251282l, -4251399l)
 * (i64vec4(165l, 133l, 193l, 76l) - 29852643761l) => i64vec4(-29852643596l, -29852643628l, -29852643568l, -29852643685l)
 * (i64vec4(165l, 133l, 193l, 76l) - -4398046511104l) => i64vec4(4398046511269l, 4398046511237l, 4398046511297l, 4398046511180l)
 * (i64vec4(165l, 133l, 193l, 76l) - -3948976685146l) => i64vec4(3948976685311l, 3948976685279l, 3948976685339l, 3948976685222l)
 * (i64vec4(165l, 133l, 193l, 76l) - -135763469567146206l) => i64vec4(135763469567146371l, 135763469567146339l, 135763469567146399l, 135763469567146282l)
 * (i64vec4(80l, -15l, -51l, 0l) - 0l) => i64vec4(80l, -15l, -51l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) - 3l) => i64vec4(77l, -18l, -54l, -3l)
 * (i64vec4(80l, -15l, -51l, 0l) - -1192l) => i64vec4(1272l, 1177l, 1141l, 1192l)
 * (i64vec4(80l, -15l, -51l, 0l) - 1048576l) => i64vec4(-1048496l, -1048591l, -1048627l, -1048576l)
 * (i64vec4(80l, -15l, -51l, 0l) - 4251475l) => i64vec4(-4251395l, -4251490l, -4251526l, -4251475l)
 * (i64vec4(80l, -15l, -51l, 0l) - 29852643761l) => i64vec4(-29852643681l, -29852643776l, -29852643812l, -29852643761l)
 * (i64vec4(80l, -15l, -51l, 0l) - -4398046511104l) => i64vec4(4398046511184l, 4398046511089l, 4398046511053l, 4398046511104l)
 * (i64vec4(80l, -15l, -51l, 0l) - -3948976685146l) => i64vec4(3948976685226l, 3948976685131l, 3948976685095l, 3948976685146l)
 * (i64vec4(80l, -15l, -51l, 0l) - -135763469567146206l) => i64vec4(135763469567146286l, 135763469567146191l, 135763469567146155l, 135763469567146206l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) - 0l), i64vec4(165l, 133l, 193l, 76l))) ? 1 : -1] array0;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) - 3l), i64vec4(162l, 130l, 190l, 73l))) ? 1 : -1] array1;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) - -1192l), i64vec4(1357l, 1325l, 1385l, 1268l))) ? 1 : -1] array2;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) - 1048576l), i64vec4(-1048411l, -1048443l, -1048383l, -1048500l))) ? 1 : -1] array3;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) - 4251475l), i64vec4(-4251310l, -4251342l, -4251282l, -4251399l))) ? 1 : -1] array4;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) - 29852643761l), i64vec4(-29852643596l, -29852643628l, -29852643568l, -29852643685l))) ? 1 : -1] array5;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) - -4398046511104l), i64vec4(4398046511269l, 4398046511237l, 4398046511297l, 4398046511180l))) ? 1 : -1] array6;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) - -3948976685146l), i64vec4(3948976685311l, 3948976685279l, 3948976685339l, 3948976685222l))) ? 1 : -1] array7;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) - -135763469567146206l), i64vec4(135763469567146371l, 135763469567146339l, 135763469567146399l, 135763469567146282l))) ? 1 : -1] array8;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) - 0l), i64vec4(80l, -15l, -51l, 0l))) ? 1 : -1] array9;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) - 3l), i64vec4(77l, -18l, -54l, -3l))) ? 1 : -1] array10;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) - -1192l), i64vec4(1272l, 1177l, 1141l, 1192l))) ? 1 : -1] array11;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) - 1048576l), i64vec4(-1048496l, -1048591l, -1048627l, -1048576l))) ? 1 : -1] array12;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) - 4251475l), i64vec4(-4251395l, -4251490l, -4251526l, -4251475l))) ? 1 : -1] array13;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) - 29852643761l), i64vec4(-29852643681l, -29852643776l, -29852643812l, -29852643761l))) ? 1 : -1] array14;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) - -4398046511104l), i64vec4(4398046511184l, 4398046511089l, 4398046511053l, 4398046511104l))) ? 1 : -1] array15;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) - -3948976685146l), i64vec4(3948976685226l, 3948976685131l, 3948976685095l, 3948976685146l))) ? 1 : -1] array16;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) - -135763469567146206l), i64vec4(135763469567146286l, 135763469567146191l, 135763469567146155l, 135763469567146206l))) ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
