"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupNotificationsRoutes = setupNotificationsRoutes;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupNotificationsRoutes(services, router) {
  const {
    notificationsService
  } = services;
  router.get({
    path: `${_constants.API.CHANNELS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, notificationsService.getChannel);
  router.get({
    path: _constants.API.CHANNELS,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, notificationsService.getChannels);
  router.get({
    path: _constants.API.NOTIFICATION_FEATURES,
    validate: {
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, notificationsService.getNotificationsFeatures);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9jb25zdGFudHMiLCJfaGVscGVycyIsInNldHVwTm90aWZpY2F0aW9uc1JvdXRlcyIsInNlcnZpY2VzIiwicm91dGVyIiwibm90aWZpY2F0aW9uc1NlcnZpY2UiLCJnZXQiLCJwYXRoIiwiQVBJIiwiQ0hBTk5FTFMiLCJ2YWxpZGF0ZSIsInBhcmFtcyIsInNjaGVtYSIsIm9iamVjdCIsImlkIiwic3RyaW5nIiwicXVlcnkiLCJjcmVhdGVRdWVyeVZhbGlkYXRpb25TY2hlbWEiLCJnZXRDaGFubmVsIiwiZ2V0Q2hhbm5lbHMiLCJOT1RJRklDQVRJT05fRkVBVFVSRVMiLCJnZXROb3RpZmljYXRpb25zRmVhdHVyZXMiXSwic291cmNlcyI6WyJOb3RpZmljYXRpb25zUm91dGVzLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHsgSVJvdXRlciB9IGZyb20gJ29wZW5zZWFyY2gtZGFzaGJvYXJkcy9zZXJ2ZXInO1xuaW1wb3J0IHsgc2NoZW1hIH0gZnJvbSAnQG9zZC9jb25maWctc2NoZW1hJztcbmltcG9ydCB7IE5vZGVTZXJ2aWNlcyB9IGZyb20gJy4uL21vZGVscy9pbnRlcmZhY2VzJztcbmltcG9ydCB7IEFQSSB9IGZyb20gJy4uL3V0aWxzL2NvbnN0YW50cyc7XG5pbXBvcnQgeyBjcmVhdGVRdWVyeVZhbGlkYXRpb25TY2hlbWEgfSBmcm9tICcuLi91dGlscy9oZWxwZXJzJztcblxuZXhwb3J0IGZ1bmN0aW9uIHNldHVwTm90aWZpY2F0aW9uc1JvdXRlcyhzZXJ2aWNlczogTm9kZVNlcnZpY2VzLCByb3V0ZXI6IElSb3V0ZXIpIHtcbiAgY29uc3QgeyBub3RpZmljYXRpb25zU2VydmljZSB9ID0gc2VydmljZXM7XG5cbiAgcm91dGVyLmdldChcbiAgICB7XG4gICAgICBwYXRoOiBgJHtBUEkuQ0hBTk5FTFN9L3tpZH1gLFxuICAgICAgdmFsaWRhdGU6IHtcbiAgICAgICAgcGFyYW1zOiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBpZDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICB9KSxcbiAgICAgICAgcXVlcnk6IGNyZWF0ZVF1ZXJ5VmFsaWRhdGlvblNjaGVtYSgpLFxuICAgICAgfSxcbiAgICB9LFxuICAgIG5vdGlmaWNhdGlvbnNTZXJ2aWNlLmdldENoYW5uZWxcbiAgKTtcblxuICByb3V0ZXIuZ2V0KFxuICAgIHtcbiAgICAgIHBhdGg6IEFQSS5DSEFOTkVMUyxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIHF1ZXJ5OiBjcmVhdGVRdWVyeVZhbGlkYXRpb25TY2hlbWEoKSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBub3RpZmljYXRpb25zU2VydmljZS5nZXRDaGFubmVsc1xuICApO1xuXG4gIHJvdXRlci5nZXQoXG4gICAge1xuICAgICAgcGF0aDogQVBJLk5PVElGSUNBVElPTl9GRUFUVVJFUyxcbiAgICAgIHZhbGlkYXRlOiB7XG4gICAgICAgIHF1ZXJ5OiBjcmVhdGVRdWVyeVZhbGlkYXRpb25TY2hlbWEoKSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBub3RpZmljYXRpb25zU2VydmljZS5nZXROb3RpZmljYXRpb25zRmVhdHVyZXNcbiAgKTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBTUEsSUFBQUEsYUFBQSxHQUFBQyxPQUFBO0FBRUEsSUFBQUMsVUFBQSxHQUFBRCxPQUFBO0FBQ0EsSUFBQUUsUUFBQSxHQUFBRixPQUFBO0FBVEE7QUFDQTtBQUNBO0FBQ0E7O0FBUU8sU0FBU0csd0JBQXdCQSxDQUFDQyxRQUFzQixFQUFFQyxNQUFlLEVBQUU7RUFDaEYsTUFBTTtJQUFFQztFQUFxQixDQUFDLEdBQUdGLFFBQVE7RUFFekNDLE1BQU0sQ0FBQ0UsR0FBRyxDQUNSO0lBQ0VDLElBQUksRUFBRyxHQUFFQyxjQUFHLENBQUNDLFFBQVMsT0FBTTtJQUM1QkMsUUFBUSxFQUFFO01BQ1JDLE1BQU0sRUFBRUMsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO1FBQ3BCQyxFQUFFLEVBQUVGLG9CQUFNLENBQUNHLE1BQU0sQ0FBQztNQUNwQixDQUFDLENBQUM7TUFDRkMsS0FBSyxFQUFFLElBQUFDLG9DQUEyQixFQUFDO0lBQ3JDO0VBQ0YsQ0FBQyxFQUNEWixvQkFBb0IsQ0FBQ2EsVUFDdkIsQ0FBQztFQUVEZCxNQUFNLENBQUNFLEdBQUcsQ0FDUjtJQUNFQyxJQUFJLEVBQUVDLGNBQUcsQ0FBQ0MsUUFBUTtJQUNsQkMsUUFBUSxFQUFFO01BQ1JNLEtBQUssRUFBRSxJQUFBQyxvQ0FBMkIsRUFBQztJQUNyQztFQUNGLENBQUMsRUFDRFosb0JBQW9CLENBQUNjLFdBQ3ZCLENBQUM7RUFFRGYsTUFBTSxDQUFDRSxHQUFHLENBQ1I7SUFDRUMsSUFBSSxFQUFFQyxjQUFHLENBQUNZLHFCQUFxQjtJQUMvQlYsUUFBUSxFQUFFO01BQ1JNLEtBQUssRUFBRSxJQUFBQyxvQ0FBMkIsRUFBQztJQUNyQztFQUNGLENBQUMsRUFDRFosb0JBQW9CLENBQUNnQix3QkFDdkIsQ0FBQztBQUNIIn0=