/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.events;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openhab.core.events.EventFactory;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.internal.events.ThreadedEventHandler;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(immediate=true, property={"event.topics:String=openhab"})
public class OSGiEventManager
implements EventHandler {
    private final Map<String, Set<EventSubscriber>> typedEventSubscribers = new ConcurrentHashMap<String, Set<EventSubscriber>>();
    private final Map<String, EventFactory> typedEventFactories = new ConcurrentHashMap<String, EventFactory>();
    private ThreadedEventHandler eventHandler;

    @Activate
    protected void activate(ComponentContext componentContext) {
        this.eventHandler = new ThreadedEventHandler(this.typedEventSubscribers, this.typedEventFactories);
        this.eventHandler.open();
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (this.eventHandler != null) {
            this.eventHandler.close();
            this.eventHandler = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addEventSubscriber(EventSubscriber eventSubscriber) {
        Set<String> subscribedEventTypes = eventSubscriber.getSubscribedEventTypes();
        for (String subscribedEventType : subscribedEventTypes) {
            Set<EventSubscriber> entries = this.typedEventSubscribers.get(subscribedEventType);
            if (entries == null) {
                this.typedEventSubscribers.put(subscribedEventType, new CopyOnWriteArraySet<EventSubscriber>(Set.of(eventSubscriber)));
                continue;
            }
            entries.add(eventSubscriber);
        }
    }

    protected void removeEventSubscriber(EventSubscriber eventSubscriber) {
        Set<String> subscribedEventTypes = eventSubscriber.getSubscribedEventTypes();
        for (String subscribedEventType : subscribedEventTypes) {
            Set<EventSubscriber> entries = this.typedEventSubscribers.get(subscribedEventType);
            if (entries == null) continue;
            entries.remove(eventSubscriber);
            if (!entries.isEmpty()) continue;
            this.typedEventSubscribers.remove(subscribedEventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addEventFactory(EventFactory eventFactory) {
        Set<String> supportedEventTypes = eventFactory.getSupportedEventTypes();
        for (String supportedEventType : supportedEventTypes) {
            OSGiEventManager oSGiEventManager = this;
            synchronized (oSGiEventManager) {
                if (!this.typedEventFactories.containsKey(supportedEventType)) {
                    this.typedEventFactories.put(supportedEventType, eventFactory);
                }
            }
        }
    }

    protected void removeEventFactory(EventFactory eventFactory) {
        Set<String> supportedEventTypes = eventFactory.getSupportedEventTypes();
        for (String supportedEventType : supportedEventTypes) {
            this.typedEventFactories.remove(supportedEventType);
        }
    }

    public void handleEvent(Event osgiEvent) {
        this.eventHandler.handleEvent(osgiEvent);
    }
}

