/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.organization;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.infinispan.organization.CachedOrganization;
import org.keycloak.models.cache.infinispan.organization.InfinispanOrganizationProvider;
import org.keycloak.organization.OrganizationProvider;

public class OrganizationAdapter
implements OrganizationModel {
    private volatile boolean invalidated;
    private volatile OrganizationModel updated;
    private final Supplier<OrganizationModel> modelSupplier;
    private final CachedOrganization cached;
    private final Supplier<OrganizationProvider> delegate;
    private final InfinispanOrganizationProvider organizationCache;

    public OrganizationAdapter(CachedOrganization cached, Supplier<OrganizationProvider> delegate, InfinispanOrganizationProvider organizationCache) {
        this.cached = cached;
        this.delegate = delegate;
        this.organizationCache = organizationCache;
        this.modelSupplier = this::getOrganizationModel;
    }

    void invalidate() {
        this.invalidated = true;
    }

    private OrganizationModel getOrganizationModel() {
        return this.delegate.get().getById(this.cached.getId());
    }

    private boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.getOrganizationModel();
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    private void getDelegateForUpdate() {
        if (this.updated == null) {
            this.updated = this.modelSupplier.get();
            this.organizationCache.registerOrganizationInvalidation(this.updated);
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public String getAlias() {
        if (this.isUpdated()) {
            return this.updated.getAlias();
        }
        return this.cached.getAlias();
    }

    public void setAlias(String alias) {
        this.getDelegateForUpdate();
        this.updated.setAlias(alias);
    }

    public boolean isEnabled() {
        if (this.isUpdated()) {
            return this.updated.isEnabled();
        }
        return this.cached.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setEnabled(enabled);
    }

    public String getDescription() {
        if (this.isUpdated()) {
            return this.updated.getDescription();
        }
        return this.cached.getDescription();
    }

    public void setDescription(String description) {
        this.getDelegateForUpdate();
        this.updated.setDescription(description);
    }

    public String getRedirectUrl() {
        if (this.isUpdated()) {
            return this.updated.getRedirectUrl();
        }
        return this.cached.getRedirectUrl();
    }

    public void setRedirectUrl(String redirectUrl) {
        this.getDelegateForUpdate();
        this.updated.setRedirectUrl(redirectUrl);
    }

    public Map<String, List<String>> getAttributes() {
        if (this.isUpdated()) {
            return this.updated.getAttributes();
        }
        return this.cached.getAttributes(this.modelSupplier);
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.getDelegateForUpdate();
        this.updated.setAttributes(attributes);
    }

    public Stream<OrganizationDomainModel> getDomains() {
        if (this.isUpdated()) {
            return this.updated.getDomains();
        }
        return this.cached.getDomains();
    }

    public void setDomains(Set<OrganizationDomainModel> domains) {
        this.getDelegateForUpdate();
        this.updated.setDomains(domains);
    }

    public Stream<IdentityProviderModel> getIdentityProviders() {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviders();
        }
        return this.cached.getIdentityProviders();
    }

    public boolean isManaged(UserModel user) {
        if (this.isUpdated()) {
            this.delegate.get().isManagedMember((OrganizationModel)this, user);
        }
        return this.organizationCache.isManagedMember(this, user);
    }

    public boolean isMember(UserModel user) {
        if (this.isUpdated()) {
            this.delegate.get().isMember((OrganizationModel)this, user);
        }
        return this.organizationCache.isMember(this, user);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrganizationModel)) {
            return false;
        }
        OrganizationModel that = (OrganizationModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

