/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.util;

import java.util.Map;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.provider.ProviderConfigurationBuilder;

public final class InfinispanUtils {
    public static final int PROVIDER_ORDER = 1;
    public static final String EMBEDDED_PROVIDER_ID = "infinispan";
    public static final String REMOTE_PROVIDER_ID = "remote";
    public static final int DEFAULT_MAX_RETRIES = 10;
    private static final String CONFIG_MAX_RETRIES = "maxRetries";
    public static final int DEFAULT_RETRIES_BASE_TIME_MILLIS = 10;
    private static final String CONFIG_RETRIES_BASE_TIME_MILLIS = "retryBaseTime";

    private InfinispanUtils() {
    }

    public static boolean isRemoteInfinispan() {
        return MultiSiteUtils.isMultiSiteEnabled() || Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLUSTERLESS);
    }

    public static boolean isEmbeddedInfinispan() {
        return !InfinispanUtils.isRemoteInfinispan();
    }

    public static void configureMaxRetries(ProviderConfigurationBuilder builder) {
        builder.property().name(CONFIG_MAX_RETRIES).type("int").helpText("The maximum number of retries if an error occurs. A value of zero or less disable any retries.").defaultValue((Object)10).add();
    }

    public static void configureRetryBaseTime(ProviderConfigurationBuilder builder) {
        builder.property().name(CONFIG_RETRIES_BASE_TIME_MILLIS).type("int").helpText("The base back-off time in milliseconds.").defaultValue((Object)10).add();
    }

    public static int getMaxRetries(Config.Scope config) {
        return Math.max(0, config.getInt(CONFIG_MAX_RETRIES, Integer.valueOf(10)));
    }

    public static int getRetryBaseTimeMillis(Config.Scope config) {
        return Math.max(1, config.getInt(CONFIG_RETRIES_BASE_TIME_MILLIS, Integer.valueOf(10)));
    }

    public static void maxRetriesToOperationalInfo(Map<String, String> map, int value) {
        map.put(CONFIG_MAX_RETRIES, Integer.toString(value));
    }

    public static void retryBaseTimeMillisToOperationalInfo(Map<String, String> map, int value) {
        map.put(CONFIG_RETRIES_BASE_TIME_MILLIS, Integer.toString(value));
    }
}

