/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;

public class DependenciesProcessor {
    private static final String NAMESPACE = "devui-dependencies";

    @BuildStep(onlyIf={IsDevelopment.class})
    void createAppDeps(BuildProducer<InternalPageBuildItem> menuProducer, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (this.isEnabled()) {
            InternalPageBuildItem page = new InternalPageBuildItem("Dependencies", 70);
            page.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace(NAMESPACE)).icon("font-awesome-solid:diagram-project")).title("Application Dependencies")).componentLink("qwc-dependencies.js"));
            Root root = new Root();
            root.rootId = curateOutcomeBuildItem.getApplicationModel().getAppArtifact().toCompactCoords();
            TreeSet allGavs = new TreeSet();
            this.buildTree(curateOutcomeBuildItem.getApplicationModel(), root, Optional.of(allGavs), Optional.empty());
            page.addBuildTimeData("root", root);
            page.addBuildTimeData("allGavs", allGavs);
            menuProducer.produce((BuildItem)page);
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void createBuildTimeActions(BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (this.isEnabled()) {
            BuildTimeActionBuildItem pathToTargetAction = new BuildTimeActionBuildItem(NAMESPACE);
            pathToTargetAction.addAction("pathToTarget", p -> {
                String target = (String)p.get("target");
                Root root = new Root();
                root.rootId = curateOutcomeBuildItem.getApplicationModel().getAppArtifact().toCompactCoords();
                if (target == null || target.isBlank()) {
                    this.buildTree(curateOutcomeBuildItem.getApplicationModel(), root, Optional.empty(), Optional.empty());
                } else {
                    this.buildTree(curateOutcomeBuildItem.getApplicationModel(), root, Optional.empty(), Optional.of(target));
                }
                return root;
            });
            buildTimeActionProducer.produce((BuildItem)pathToTargetAction);
        }
    }

    private boolean isEnabled() {
        ConfigValue value = ConfigProvider.getConfig().getConfigValue("quarkus.bootstrap.incubating-model-resolver");
        return value == null || !"false".equals(value.getValue()) || "default values".equals(value.getSourceName());
    }

    private void buildTree(ApplicationModel model, Root root, Optional<Set<String>> allGavs, Optional<String> toTarget) {
        Collection resolvedDeps = model.getDependencies();
        ArrayList<Node> nodes = new ArrayList<Node>(resolvedDeps.size());
        ArrayList<Link> links = new ArrayList<Link>();
        if (toTarget.isEmpty()) {
            DependenciesProcessor.addDependency(model.getAppArtifact(), root, nodes, links, allGavs);
            for (ResolvedDependency rd : resolvedDeps) {
                DependenciesProcessor.addDependency(rd, root, nodes, links, allGavs);
            }
        } else {
            DepNode targetDep = DependenciesProcessor.getTargetDepNode(model, ArtifactCoords.fromString((String)toTarget.get()));
            DependenciesProcessor.addDependency(targetDep, root, nodes, links, allGavs, new HashSet<String>());
        }
        root.nodes = nodes;
        root.links = links;
    }

    private static void addDependency(ResolvedDependency rd, Root root, List<Node> nodes, List<Link> links, Optional<Set<String>> allGavs) {
        Node node = new Node();
        if (allGavs.isPresent()) {
            allGavs.get().add(rd.toCompactCoords());
        }
        node.id = rd.toCompactCoords();
        node.name = rd.getArtifactId();
        node.description = rd.toCompactCoords();
        nodes.add(node);
        String type = rd.isRuntimeCp() ? "runtime" : "deployment";
        for (ArtifactCoords dep : rd.getDependencies()) {
            if ("quarkus-ide-launcher".equals(dep.getArtifactId()) || "javax.annotation-api".equals(dep.getArtifactId())) continue;
            Link link = new Link();
            link.source = node.id;
            link.target = dep.toCompactCoords();
            link.type = type;
            link.direct = link.source == root.rootId;
            links.add(link);
        }
    }

    private static void addDependency(DepNode dep, Root root, List<Node> nodes, List<Link> links, Optional<Set<String>> allGavs, Set<String> visited) {
        String id = dep.resolvedDep.toCompactCoords();
        if (!visited.add(id)) {
            return;
        }
        ResolvedDependency rd = dep.resolvedDep;
        if (allGavs.isPresent()) {
            allGavs.get().add(rd.toCompactCoords());
        }
        Node node = new Node();
        node.id = id;
        node.name = rd.getArtifactId();
        node.description = id;
        nodes.add(node);
        for (DepNode dependent : dep.dependents) {
            DependenciesProcessor.addDependency(dependent, root, nodes, links, allGavs, visited);
            Link link = new Link();
            link.source = dependent.resolvedDep.toCompactCoords();
            link.target = node.id;
            link.type = dependent.resolvedDep.isRuntimeCp() ? "runtime" : "deployment";
            link.direct = link.source == root.rootId;
            links.add(link);
        }
    }

    private static DepNode getTargetDepNode(ApplicationModel model, ArtifactCoords targetCoords) {
        DepNode targetDep = DependenciesProcessor.getTargetWithAllDependents(targetCoords, DependenciesProcessor.getCompleteMap(model));
        boolean showShortestCommonPaths = false;
        return targetDep;
    }

    private static DepNode getGraph(List<DepPath> paths) {
        DepNode newTarget = new DepNode(paths.get((int)0).path.get((int)0).id, paths.get((int)0).path.get((int)0).resolvedDep);
        HashMap<ArtifactKey, DepNode> nodes = new HashMap<ArtifactKey, DepNode>();
        for (DepPath path : paths) {
            DepNode currentNode = newTarget;
            for (int i = 1; i < path.path.size(); ++i) {
                DepNode originalNode = path.path.get(i);
                DepNode newNode = nodes.computeIfAbsent(originalNode.resolvedDep.getKey(), k -> new DepNode(originalNode.id, originalNode.resolvedDep));
                currentNode.addDependent(newNode);
                currentNode = newNode;
            }
        }
        return newTarget;
    }

    private static void filterShortestCommonPaths(List<DepPath> paths) {
        int i = 0;
        while (i < paths.size()) {
            DepPath currentPath = paths.get(i++);
            int j = i;
            while (j < paths.size()) {
                if (paths.get((int)j).ids.containsAll(currentPath.ids)) {
                    paths.remove(j);
                    continue;
                }
                ++j;
            }
        }
        DependenciesProcessor.logPaths(paths, "Shortest common paths");
    }

    private static List<DepPath> collectAllPaths(DepNode targetDep) {
        ArrayList<DepPath> allPaths = new ArrayList<DepPath>();
        DependenciesProcessor.collectAllPaths(targetDep, new DepPath(), allPaths);
        Collections.sort(allPaths);
        DependenciesProcessor.logPaths(allPaths, "Paths");
        return allPaths;
    }

    private static void logPaths(List<DepPath> paths, String title) {
        System.out.println(title + " total: " + paths.size());
        int j = 1;
        for (DepPath dp : paths) {
            System.out.println(j++ + ") " + String.valueOf(dp));
        }
    }

    private static void collectAllPaths(DepNode node, DepPath currentPath, List<DepPath> allPaths) {
        if (!currentPath.addNode(node)) {
            return;
        }
        if (node.id == 0) {
            allPaths.add(currentPath);
            return;
        }
        if (node.dependents.isEmpty()) {
            System.out.println(node.resolvedDep.getArtifactId() + " has no dependents");
            return;
        }
        for (int i = 1; i < node.dependents.size(); ++i) {
            DependenciesProcessor.collectAllPaths(node.dependents.get(i), currentPath.clone(), allPaths);
        }
        DependenciesProcessor.collectAllPaths(node.dependents.get(0), currentPath, allPaths);
    }

    private static DepNode getTargetWithAllDependents(ArtifactCoords targetCoords, Map<ArtifactKey, DepNode> all) {
        DepNode targetDep = null;
        for (DepNode d : all.values()) {
            d.initDependents(all);
            if (targetDep != null || !d.resolvedDep.getArtifactId().equals(targetCoords.getArtifactId()) || !d.resolvedDep.getGroupId().equals(targetCoords.getGroupId()) || !d.resolvedDep.getClassifier().equals(targetCoords.getClassifier()) || !d.resolvedDep.getType().equals(targetCoords.getType()) || !d.resolvedDep.getVersion().equals(targetCoords.getVersion())) continue;
            targetDep = d;
        }
        if (targetDep == null) {
            throw new IllegalArgumentException("Failed to locate " + targetCoords.toCompactCoords() + " among the dependencies");
        }
        return targetDep;
    }

    private static Map<ArtifactKey, DepNode> getCompleteMap(ApplicationModel model) {
        HashMap<ArtifactKey, DepNode> all = new HashMap<ArtifactKey, DepNode>();
        DepNode root = new DepNode(0, model.getAppArtifact());
        all.put(model.getAppArtifact().getKey(), root);
        int i = 1;
        for (ResolvedDependency d : model.getDependencies()) {
            all.put(d.getKey(), new DepNode(i++, d));
        }
        return all;
    }

    static class Root {
        public String rootId;
        public List<Node> nodes;
        public List<Link> links;

        Root() {
        }
    }

    private static class DepNode {
        final int id;
        final ResolvedDependency resolvedDep;
        List<DepNode> dependents = List.of();

        private DepNode(int id, ResolvedDependency resolvedDep) {
            this.id = id;
            this.resolvedDep = resolvedDep;
        }

        void initDependents(Map<ArtifactKey, DepNode> allDeps) {
            for (ArtifactCoords depCoords : this.resolvedDep.getDependencies()) {
                DepNode dep = allDeps.get(depCoords.getKey());
                if (dep == null) continue;
                dep.addDependent(this);
            }
        }

        private void addDependent(DepNode dependent) {
            if (this.dependents.isEmpty()) {
                this.dependents = new ArrayList<DepNode>();
            }
            this.dependents.add(dependent);
        }
    }

    static class Node {
        public String id;
        public String name;
        public int value = 1;
        public String description;

        Node() {
        }

        public int hashCode() {
            int hash = 3;
            hash = 23 * hash + Objects.hashCode(this.id);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return Objects.equals(this.id, other.id);
        }
    }

    static class Link {
        public String source;
        public String target;
        public String type;
        public boolean direct = false;

        Link() {
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.source);
            hash = 97 * hash + Objects.hashCode(this.target);
            hash = 97 * hash + Objects.hashCode(this.type);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Link other = (Link)obj;
            if (!Objects.equals(this.source, other.source)) {
                return false;
            }
            if (!Objects.equals(this.target, other.target)) {
                return false;
            }
            return Objects.equals(this.type, other.type);
        }
    }

    private static class DepPath
    implements Comparable<DepPath> {
        final Set<Integer> ids;
        final List<DepNode> path;

        DepPath() {
            this.ids = new HashSet<Integer>();
            this.path = new ArrayList<DepNode>();
        }

        DepPath(DepPath original) {
            this.ids = new HashSet<Integer>(original.ids);
            this.path = new ArrayList<DepNode>(original.path);
        }

        boolean addNode(DepNode node) {
            if (!this.ids.add(node.id)) {
                return false;
            }
            this.path.add(node);
            return true;
        }

        public DepPath clone() {
            return new DepPath(this);
        }

        @Override
        public int compareTo(DepPath o) {
            return this.path.size() - o.path.size();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<DepNode> i = this.path.iterator();
            sb.append(i.next().resolvedDep.getArtifactId());
            while (i.hasNext()) {
                sb.append(" -> ").append(i.next().resolvedDep.getArtifactId());
            }
            return sb.toString();
        }
    }
}

