/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.function.Supplier;
import org.keycloak.device.DeviceRepresentationProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.account.DeviceRepresentation;

public class SecureContextResolver {
    public static boolean isSecureContext(KeycloakSession session) {
        URI uri = session.getContext().getUri().getRequestUri();
        Supplier<DeviceRepresentation> deviceRepresentationSupplier = () -> {
            DeviceRepresentationProvider deviceRepresentationProvider = (DeviceRepresentationProvider)session.getProvider(DeviceRepresentationProvider.class);
            return deviceRepresentationProvider.deviceRepresentation();
        };
        return SecureContextResolver.isSecureContext(uri, deviceRepresentationSupplier);
    }

    static boolean isSecureContext(URI uri, Supplier<DeviceRepresentation> deviceRepresentationSupplier) {
        String browser;
        if (uri.getScheme().equals("https")) {
            return true;
        }
        DeviceRepresentation deviceRepresentation = deviceRepresentationSupplier.get();
        String string = browser = deviceRepresentation != null ? deviceRepresentation.getBrowser() : null;
        if (browser != null && browser.toLowerCase().contains("safari")) {
            return false;
        }
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        if (SecureContextResolver.isLocalAddress(host)) {
            return true;
        }
        if (host.equals("localhost") || host.equals("localhost.")) {
            return true;
        }
        return host.endsWith(".localhost") || host.endsWith(".localhost.");
    }

    public static boolean isLocalAddress(String address) {
        if (address == null) {
            return false;
        }
        if (NetUtil.isValidIpV4Address((String)address) || NetUtil.isValidIpV6Address((String)address)) {
            try {
                return InetAddress.getByName(address).isLoopbackAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return false;
    }
}

