/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.info;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.component.ComponentFactory;
import org.keycloak.crypto.ClientSignatureVerifierProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PasswordPolicyProviderFactory;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.provider.Spi;
import org.keycloak.representations.idm.ComponentTypeRepresentation;
import org.keycloak.representations.idm.PasswordPolicyTypeRepresentation;
import org.keycloak.representations.idm.ProtocolMapperTypeRepresentation;
import org.keycloak.representations.info.ClientInstallationRepresentation;
import org.keycloak.representations.info.CryptoInfoRepresentation;
import org.keycloak.representations.info.FeatureRepresentation;
import org.keycloak.representations.info.FeatureType;
import org.keycloak.representations.info.MemoryInfoRepresentation;
import org.keycloak.representations.info.ProfileInfoRepresentation;
import org.keycloak.representations.info.ProviderRepresentation;
import org.keycloak.representations.info.ServerInfoRepresentation;
import org.keycloak.representations.info.SpiInfoRepresentation;
import org.keycloak.representations.info.SystemInfoRepresentation;
import org.keycloak.representations.info.ThemeInfoRepresentation;
import org.keycloak.theme.Theme;

@Extension(name="x-smallrye-profile-admin", value="")
public class ServerInfoAdminResource {
    private static final Map<String, List<String>> ENUMS = ServerInfoAdminResource.createEnumsMap(EventType.class, OperationType.class, ResourceType.class);
    private final KeycloakSession session;

    public ServerInfoAdminResource(KeycloakSession session) {
        this.session = session;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Root")
    @Operation(summary="Get themes, social providers, auth providers, and event listeners available on this server")
    public ServerInfoRepresentation getInfo() {
        ServerInfoRepresentation info = new ServerInfoRepresentation();
        info.setSystemInfo(SystemInfoRepresentation.create((long)this.session.getKeycloakSessionFactory().getServerStartupTimestamp(), (String)Version.VERSION));
        info.setMemoryInfo(MemoryInfoRepresentation.create());
        info.setProfileInfo(this.createProfileInfo());
        info.setFeatures(ServerInfoAdminResource.createFeatureRepresentations());
        Map algorithms = this.session.getAllProviders(ClientSignatureVerifierProvider.class).stream().collect(Collectors.toMap(ClientSignatureVerifierProvider::isAsymmetricAlgorithm, clientSignatureVerifier -> Collections.singletonList(clientSignatureVerifier.getAlgorithm()), (l1, l2) -> {
            List result = ServerInfoAdminResource.listCombiner(l1, l2);
            return result.stream().sorted().collect(Collectors.toList());
        }, HashMap::new));
        info.setCryptoInfo(ServerInfoAdminResource.createCryptoInfo((List)algorithms.get(false), (List)algorithms.get(true)));
        this.setSocialProviders(info);
        this.setIdentityProviders(info);
        this.setThemes(info);
        this.setProviders(info);
        this.setProtocolMapperTypes(info);
        this.setBuiltinProtocolMappers(info);
        this.setClientInstallations(info);
        this.setPasswordPolicies(info);
        info.setEnums(ENUMS);
        return info;
    }

    private void setProviders(ServerInfoRepresentation info) {
        info.setComponentTypes(new HashMap());
        LinkedHashMap<String, SpiInfoRepresentation> spiReps = new LinkedHashMap<String, SpiInfoRepresentation>();
        LinkedList spis = new LinkedList(this.session.getKeycloakSessionFactory().getSpis());
        Collections.sort(spis, new Comparator<Spi>(){

            @Override
            public int compare(Spi s1, Spi s2) {
                return s1.getName().compareTo(s2.getName());
            }
        });
        for (Spi spi : spis) {
            SpiInfoRepresentation spiRep = new SpiInfoRepresentation();
            spiRep.setInternal(spi.isInternal());
            LinkedList providerIds = new LinkedList(this.session.listProviderIds(spi.getProviderClass()));
            Collections.sort(providerIds);
            HashMap<String, ProviderRepresentation> providers = new HashMap<String, ProviderRepresentation>();
            if (providerIds != null) {
                for (String name : providerIds) {
                    ProviderRepresentation provider = new ProviderRepresentation();
                    ProviderFactory pi = this.session.getKeycloakSessionFactory().getProviderFactory(spi.getProviderClass(), name);
                    provider.setOrder(pi.order());
                    if (ServerInfoAwareProviderFactory.class.isAssignableFrom(pi.getClass())) {
                        provider.setOperationalInfo(((ServerInfoAwareProviderFactory)pi).getOperationalInfo());
                    }
                    if (pi instanceof ConfiguredProvider) {
                        LinkedList<ComponentTypeRepresentation> reps;
                        ComponentTypeRepresentation rep = new ComponentTypeRepresentation();
                        rep.setId(pi.getId());
                        ConfiguredProvider configured = (ConfiguredProvider)pi;
                        rep.setHelpText(configured.getHelpText());
                        List configProperties = configured.getConfigProperties();
                        if (configProperties == null) {
                            configProperties = Collections.EMPTY_LIST;
                        }
                        rep.setProperties(ModelToRepresentation.toRepresentation((List)configProperties));
                        if (pi instanceof ComponentFactory) {
                            rep.setMetadata(((ComponentFactory)pi).getTypeMetadata());
                        }
                        if ((reps = (LinkedList<ComponentTypeRepresentation>)info.getComponentTypes().get(spi.getProviderClass().getName())) == null) {
                            reps = new LinkedList<ComponentTypeRepresentation>();
                            info.getComponentTypes().put(spi.getProviderClass().getName(), reps);
                        }
                        reps.add(rep);
                    }
                    providers.put(name, provider);
                }
            }
            spiRep.setProviders(providers);
            spiReps.put(spi.getName(), spiRep);
        }
        info.setProviders(spiReps);
    }

    private void setThemes(ServerInfoRepresentation info) {
        info.setThemes(new HashMap());
        for (Theme.Type type : Theme.Type.values()) {
            LinkedList<String> themeNames = this.filterThemes(type, new LinkedList<String>(this.session.theme().nameSet(type)));
            Collections.sort(themeNames);
            LinkedList<ThemeInfoRepresentation> themes = new LinkedList<ThemeInfoRepresentation>();
            info.getThemes().put(type.toString().toLowerCase(), themes);
            for (String name : themeNames) {
                try {
                    Theme theme = this.session.theme().getTheme(name, type);
                    if (theme == null || !name.equals(theme.getName())) continue;
                    ThemeInfoRepresentation ti = new ThemeInfoRepresentation();
                    ti.setName(name);
                    String locales = theme.getProperties().getProperty("locales");
                    if (locales != null) {
                        ti.setLocales(locales.replaceAll(" ", "").split(","));
                    }
                    themes.add(ti);
                }
                catch (IOException e) {
                    throw new WebApplicationException("Failed to load themes", (Throwable)e);
                }
            }
        }
    }

    private LinkedList<String> filterThemes(Theme.Type type, LinkedList<String> themeNames) {
        boolean filterAccountV3;
        boolean filterLoginV2;
        LinkedList<String> filteredNames = new LinkedList<String>(themeNames);
        boolean filterAdminV2 = type == Theme.Type.ADMIN && !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_V2);
        boolean bl = filterLoginV2 = type == Theme.Type.LOGIN && !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.LOGIN_V2);
        if (filterAdminV2 || filterLoginV2) {
            filteredNames.remove("keycloak.v2");
            filteredNames.remove("rh-sso.v2");
        }
        boolean bl2 = filterAccountV3 = type == Theme.Type.ACCOUNT && !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ACCOUNT_V3);
        if (filterAccountV3) {
            filteredNames.remove("keycloak.v3");
        }
        return filteredNames;
    }

    private void setSocialProviders(ServerInfoRepresentation info) {
        info.setSocialProviders(new LinkedList());
        Stream providerFactories = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(SocialIdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getSocialProviders(), "Social");
    }

    private void setIdentityProviders(ServerInfoRepresentation info) {
        info.setIdentityProviders(new LinkedList());
        Stream providerFactories = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(IdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getIdentityProviders(), "User-defined");
        providerFactories = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(SocialIdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.getIdentityProviders(), "Social");
    }

    public void setIdentityProviders(Stream<ProviderFactory> factories, List<Map<String, String>> providers, String groupName) {
        List providerMaps = factories.map(IdentityProviderFactory.class::cast).map(factory -> {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("groupName", groupName);
            data.put("name", factory.getName());
            data.put("id", factory.getId());
            return data;
        }).collect(Collectors.toList());
        providers.addAll(providerMaps);
    }

    private void setClientInstallations(ServerInfoRepresentation info) {
        HashMap clientInstallations = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ClientInstallationProvider.class).map(ClientInstallationProvider.class::cast).collect(Collectors.toMap(ClientInstallationProvider::getProtocol, this::toClientInstallationRepresentation, (l1, l2) -> ServerInfoAdminResource.listCombiner(l1, l2), HashMap::new));
        info.setClientInstallations((Map)clientInstallations);
    }

    private void setProtocolMapperTypes(ServerInfoRepresentation info) {
        HashMap protocolMappers = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ProtocolMapper.class).map(ProtocolMapper.class::cast).collect(Collectors.toMap(ProtocolMapper::getProtocol, this::toProtocolMapperTypeRepresentation, (l1, l2) -> ServerInfoAdminResource.listCombiner(l1, l2), HashMap::new));
        info.setProtocolMapperTypes((Map)protocolMappers);
    }

    private void setBuiltinProtocolMappers(ServerInfoRepresentation info) {
        Map<String, List> protocolMappers = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(LoginProtocol.class).collect(Collectors.toMap(p -> p.getId(), p -> {
            LoginProtocolFactory factory = (LoginProtocolFactory)p;
            return factory.getBuiltinMappers().values().stream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
        }));
        info.setBuiltinProtocolMappers(protocolMappers);
    }

    private void setPasswordPolicies(ServerInfoRepresentation info) {
        List passwordPolicyTypes = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(PasswordPolicyProvider.class).map(PasswordPolicyProviderFactory.class::cast).map(factory -> {
            PasswordPolicyTypeRepresentation rep = new PasswordPolicyTypeRepresentation();
            rep.setId(factory.getId());
            rep.setDisplayName(factory.getDisplayName());
            rep.setConfigType(factory.getConfigType());
            rep.setDefaultValue(factory.getDefaultConfigValue());
            rep.setMultipleSupported(factory.isMultiplSupported());
            return rep;
        }).collect(Collectors.toList());
        info.setPasswordPolicies(passwordPolicyTypes);
    }

    private List<ClientInstallationRepresentation> toClientInstallationRepresentation(ClientInstallationProvider provider) {
        ClientInstallationRepresentation rep = new ClientInstallationRepresentation();
        rep.setId(provider.getId());
        rep.setHelpText(provider.getHelpText());
        rep.setDisplayType(provider.getDisplayType());
        rep.setProtocol(provider.getProtocol());
        rep.setDownloadOnly(provider.isDownloadOnly());
        rep.setFilename(provider.getFilename());
        rep.setMediaType(provider.getMediaType());
        return Arrays.asList(rep);
    }

    private List<ProtocolMapperTypeRepresentation> toProtocolMapperTypeRepresentation(ProtocolMapper mapper) {
        ProtocolMapperTypeRepresentation rep = new ProtocolMapperTypeRepresentation();
        rep.setId(mapper.getId());
        rep.setName(mapper.getDisplayType());
        rep.setHelpText(mapper.getHelpText());
        rep.setCategory(mapper.getDisplayCategory());
        rep.setPriority(mapper.getPriority());
        List configProperties = mapper.getConfigProperties();
        rep.setProperties(ModelToRepresentation.toRepresentation((List)configProperties));
        return Arrays.asList(rep);
    }

    private static <T> List<T> listCombiner(List<T> list1, List<T> list2) {
        return Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
    }

    private static Map<String, List<String>> createEnumsMap(Class ... enums) {
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        for (Class e : enums) {
            Object n = e.getSimpleName();
            n = Character.toLowerCase(((String)n).charAt(0)) + ((String)n).substring(1);
            LinkedList<String> l = new LinkedList<String>();
            for (Object c : e.getEnumConstants()) {
                l.add(c.toString());
            }
            Collections.sort(l);
            m.put((String)n, l);
        }
        return m;
    }

    private ProfileInfoRepresentation createProfileInfo() {
        ProfileInfoRepresentation info = new ProfileInfoRepresentation();
        Profile profile = Profile.getInstance();
        info.setName(profile.getName().name().toLowerCase());
        info.setDisabledFeatures(ServerInfoAdminResource.names(profile.getDisabledFeatures()));
        info.setPreviewFeatures(ServerInfoAdminResource.names(profile.getPreviewFeatures()));
        info.setExperimentalFeatures(ServerInfoAdminResource.names(profile.getExperimentalFeatures()));
        return info;
    }

    private static List<String> names(Set<Profile.Feature> featureSet) {
        LinkedList<String> l = new LinkedList<String>();
        for (Profile.Feature f : featureSet) {
            l.add(f.name());
        }
        return l;
    }

    private static FeatureRepresentation getFeatureRep(Profile.Feature feature, boolean isEnabled) {
        FeatureRepresentation featureRep = new FeatureRepresentation();
        featureRep.setName(feature.name());
        featureRep.setLabel(feature.getLabel());
        featureRep.setType(FeatureType.valueOf((String)feature.getType().name()));
        featureRep.setEnabled(isEnabled);
        featureRep.setDependencies(feature.getDependencies() != null ? feature.getDependencies().stream().map(Enum::name).collect(Collectors.toSet()) : Collections.emptySet());
        return featureRep;
    }

    private static List<FeatureRepresentation> createFeatureRepresentations() {
        ArrayList<FeatureRepresentation> featureRepresentationList = new ArrayList<FeatureRepresentation>();
        Profile profile = Profile.getInstance();
        Map features = profile.getFeatures();
        features.forEach((f, enabled) -> featureRepresentationList.add(ServerInfoAdminResource.getFeatureRep(f, enabled)));
        return featureRepresentationList;
    }

    private static CryptoInfoRepresentation createCryptoInfo(List<String> clientSignatureSymmetricAlgorithms, List<String> clientSignatureAsymmetricAlgorithms) {
        CryptoInfoRepresentation info = new CryptoInfoRepresentation();
        CryptoProvider cryptoProvider = CryptoIntegration.getProvider();
        info.setCryptoProvider(cryptoProvider.getClass().getSimpleName());
        info.setSupportedKeystoreTypes(CryptoIntegration.getProvider().getSupportedKeyStoreTypes().map(Enum::toString).collect(Collectors.toList()));
        info.setClientSignatureSymmetricAlgorithms(clientSignatureSymmetricAlgorithms);
        info.setClientSignatureAsymmetricAlgorithms(clientSignatureAsymmetricAlgorithms);
        return info;
    }
}

