/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.NamingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.keycloak.email.EmailException;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.services.ServicesLogger;

public class ServicesLogger_$logger
extends DelegatingBasicLogger
implements ServicesLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ServicesLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final AtomicBoolean oidcScopeMissing_$Once = new AtomicBoolean(false);
    private static final AtomicBoolean scriptEngineCreated_$Once = new AtomicBoolean(false);

    public ServicesLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void loadingFrom(Object from) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.loadingFrom$str(), from);
    }

    protected String loadingFrom$str() {
        return "KC-SERVICES0001: Loading config from %s";
    }

    @Override
    public final void migrationFailure(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.migrationFailure$str(), new Object[0]);
    }

    protected String migrationFailure$str() {
        return "KC-SERVICES0002: Failed to migrate datamodel";
    }

    @Override
    public final void realmExists(String realmName, String from) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.realmExists$str(), (Object)realmName, (Object)from);
    }

    protected String realmExists$str() {
        return "KC-SERVICES0003: Not importing realm %s from %s.  It already exists.";
    }

    @Override
    public final void importedRealm(String realmName, String from) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.importedRealm$str(), (Object)realmName, (Object)from);
    }

    protected String importedRealm$str() {
        return "KC-SERVICES0004: Imported realm %s from %s.";
    }

    @Override
    public final void unableToImportRealm(Throwable t, String realmName, String from) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.unableToImportRealm$str(), (Object)realmName, (Object)from);
    }

    protected String unableToImportRealm$str() {
        return "KC-SERVICES0005: Unable to import realm %s from %s.";
    }

    @Override
    public final void imprtingUsersFrom(Object from) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.imprtingUsersFrom$str(), from);
    }

    protected String imprtingUsersFrom$str() {
        return "KC-SERVICES0006: Importing users from '%s'";
    }

    @Override
    public final void failedToLoadUsers(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToLoadUsers$str(), new Object[0]);
    }

    protected String failedToLoadUsers$str() {
        return "KC-SERVICES0007: Failed to load 'keycloak-add-user.json'";
    }

    @Override
    public final void addUserFailedRealmNotFound(String user, String realm) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.addUserFailedRealmNotFound$str(), (Object)user, (Object)realm);
    }

    protected String addUserFailedRealmNotFound$str() {
        return "KC-SERVICES0008: Failed to add user %s to realm %s: realm not found";
    }

    @Override
    public final void addUserSuccess(String user, String realm) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.addUserSuccess$str(), (Object)user, (Object)realm);
    }

    protected String addUserSuccess$str() {
        return "KC-SERVICES0009: Added user '%s' to realm '%s'";
    }

    @Override
    public final void addUserFailedUserExists(String user, String realm) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.addUserFailedUserExists$str(), (Object)user, (Object)realm);
    }

    protected String addUserFailedUserExists$str() {
        return "KC-SERVICES0010: Failed to add user '%s' to realm '%s': user with username exists";
    }

    @Override
    public final void addUserFailed(Throwable t, String user, String realm) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.addUserFailed$str(), (Object)user, (Object)realm);
    }

    protected String addUserFailed$str() {
        return "KC-SERVICES0011: Failed to add user '%s' to realm '%s'";
    }

    @Override
    public final void failedToDeleteFile(String fileName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.failedToDeleteFile$str(), (Object)fileName);
    }

    protected String failedToDeleteFile$str() {
        return "KC-SERVICES0012: Failed to delete '%s'";
    }

    @Override
    public final void failedAuthentication(Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.failedAuthentication$str(), new Object[0]);
    }

    protected String failedAuthentication$str() {
        return "KC-SERVICES0013: Failed authentication";
    }

    @Override
    public final void failedClientAuthentication(Throwable t) {
        this.log.logf(FQCN, Logger.Level.DEBUG, t, this.failedClientAuthentication$str(), new Object[0]);
    }

    protected String failedClientAuthentication$str() {
        return "KC-SERVICES0014: Failed client authentication";
    }

    @Override
    public final void errorAuthenticatingClient(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorAuthenticatingClient$str(), new Object[0]);
    }

    protected String errorAuthenticatingClient$str() {
        return "KC-SERVICES0015: Unexpected error when authenticating client";
    }

    @Override
    public final void unknownFlow() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unknownFlow$str(), new Object[0]);
    }

    protected String unknownFlow$str() {
        return "KC-SERVICES0016: Unknown flow to execute with";
    }

    @Override
    public final void unknownResultStatus() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unknownResultStatus$str(), new Object[0]);
    }

    protected String unknownResultStatus$str() {
        return "KC-SERVICES0017: Unknown result status";
    }

    @Override
    public final void authMethodFallback(String clientId, String expectedClientAuthType) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.authMethodFallback$str(), (Object)clientId, (Object)expectedClientAuthType);
    }

    protected String authMethodFallback$str() {
        return "KC-SERVICES0018: Client %s doesn't have have authentication method configured. Fallback to %s";
    }

    @Override
    public final void noDuplicationDetected() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noDuplicationDetected$str(), new Object[0]);
    }

    protected String noDuplicationDetected$str() {
        return "KC-SERVICES0019: No duplication detected.";
    }

    @Override
    public final void resetFlow(String emailOrUserName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.resetFlow$str(), (Object)emailOrUserName);
    }

    protected String resetFlow$str() {
        return "KC-SERVICES0020: %s is null. Reset flow and enforce showing reviewProfile page";
    }

    @Override
    public final void confirmBrokerEmailFailed(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.confirmBrokerEmailFailed$str(), new Object[0]);
    }

    protected String confirmBrokerEmailFailed$str() {
        return "KC-SERVICES0021: Failed to send email to confirm identity broker linking";
    }

    @Override
    public final void keyParamDoesNotMatch() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.keyParamDoesNotMatch$str(), new Object[0]);
    }

    protected String keyParamDoesNotMatch$str() {
        return "KC-SERVICES0022: Key parameter don't match with the expected value from client session";
    }

    @Override
    public final void smtpNotConfigured() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.smtpNotConfigured$str(), new Object[0]);
    }

    protected String smtpNotConfigured$str() {
        return "KC-SERVICES0023: Smtp is not configured for the realm. Ignoring email verification authenticator";
    }

    @Override
    public final void modelDuplicateException(ModelDuplicateException mde) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)mde, this.modelDuplicateException$str(), new Object[0]);
    }

    protected String modelDuplicateException$str() {
        return "KC-SERVICES0024: ";
    }

    @Override
    public final void errorValidatingAssertion(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorValidatingAssertion$str(), new Object[0]);
    }

    protected String errorValidatingAssertion$str() {
        return "KC-SERVICES0025: Error when validating client assertion";
    }

    @Override
    public final void failedToSendPwdResetEmail(EmailException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToSendPwdResetEmail$str(), new Object[0]);
    }

    protected String failedToSendPwdResetEmail$str() {
        return "KC-SERVICES0026: Failed to send password reset email";
    }

    @Override
    public final void recaptchaFailed(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.recaptchaFailed$str(), new Object[0]);
    }

    protected String recaptchaFailed$str() {
        return "KC-SERVICES0028: Recaptcha failed";
    }

    @Override
    public final void failedToSendEmail(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToSendEmail$str(), new Object[0]);
    }

    protected String failedToSendEmail$str() {
        return "KC-SERVICES0029: Failed to send email";
    }

    @Override
    public final void fullModelImport(String strategy) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.fullModelImport$str(), (Object)strategy);
    }

    protected String fullModelImport$str() {
        return "KC-SERVICES0030: Full model import requested. Strategy: %s";
    }

    @Override
    public final void realmImportRequested(String realmName, String strategy) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.realmImportRequested$str(), (Object)realmName, (Object)strategy);
    }

    protected String realmImportRequested$str() {
        return "KC-SERVICES0031: Import of realm '%s' requested. Strategy: %s";
    }

    @Override
    public final void importSuccess() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.importSuccess$str(), new Object[0]);
    }

    protected String importSuccess$str() {
        return "KC-SERVICES0032: Import finished successfully";
    }

    @Override
    public final void fullModelExportRequested() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.fullModelExportRequested$str(), new Object[0]);
    }

    protected String fullModelExportRequested$str() {
        return "KC-SERVICES0033: Full model export requested";
    }

    @Override
    public final void realmExportRequested(String realmName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.realmExportRequested$str(), (Object)realmName);
    }

    protected String realmExportRequested$str() {
        return "KC-SERVICES0034: Export of realm '%s' requested.";
    }

    @Override
    public final void exportSuccess() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.exportSuccess$str(), new Object[0]);
    }

    protected String exportSuccess$str() {
        return "KC-SERVICES0035: Export finished successfully";
    }

    @Override
    public final void overwriteError(Exception e, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.overwriteError$str(), (Object)name);
    }

    protected String overwriteError$str() {
        return "KC-SERVICES0036: Error overwriting %s";
    }

    @Override
    public final void creationError(Exception e, String name) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.creationError$str(), (Object)name);
    }

    protected String creationError$str() {
        return "KC-SERVICES0037: Error creating %s";
    }

    @Override
    public final void roleImportError(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.roleImportError$str(), new Object[0]);
    }

    protected String roleImportError$str() {
        return "KC-SERVICES0038: Error importing roles";
    }

    @Override
    public final void untranslatedProtocol(String errorName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.untranslatedProtocol$str(), (Object)errorName);
    }

    protected String untranslatedProtocol$str() {
        return "KC-SERVICES0039: Untranslated protocol Error: %s so we return default SAML error";
    }

    @Override
    public final void usingDeprecatedDirectGrantsOnly() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingDeprecatedDirectGrantsOnly$str(), new Object[0]);
    }

    protected String usingDeprecatedDirectGrantsOnly$str() {
        return "KC-SERVICES0040: Using deprecated 'directGrantsOnly' configuration in JSON representation. It will be removed in future versions";
    }

    @Override
    public final void invokingDeprecatedEndpoint(URI requestUri) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invokingDeprecatedEndpoint$str(), (Object)requestUri);
    }

    protected String invokingDeprecatedEndpoint$str() {
        return "KC-SERVICES0041: Invoking deprecated endpoint %s";
    }

    @Override
    public final void responseModeQueryNotAllowed() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.responseModeQueryNotAllowed$str(), new Object[0]);
    }

    protected String responseModeQueryNotAllowed$str() {
        return "KC-SERVICES0042: Response_mode 'query' not allowed for implicit or hybrid flow";
    }

    @Override
    public final void clientSessionNull() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.clientSessionNull$str(), new Object[0]);
    }

    protected String clientSessionNull$str() {
        return "KC-SERVICES0043: Client session is null";
    }

    @Override
    public final void clientModelNull() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.clientModelNull$str(), new Object[0]);
    }

    protected String clientModelNull$str() {
        return "KC-SERVICES0044: Client model in client session is null";
    }

    @Override
    public final void invalidToken() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidToken$str(), new Object[0]);
    }

    protected String invalidToken$str() {
        return "KC-SERVICES0045: Invalid token. Token verification failed.";
    }

    @Override
    public final void multipleValuesForMapper(String attrValue, String mapper) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.multipleValuesForMapper$str(), (Object)attrValue, (Object)mapper);
    }

    protected String multipleValuesForMapper$str() {
        return "KC-SERVICES0046: Multiple values found '%s' for protocol mapper '%s' but expected just single value";
    }

    @Override
    public final void spiMayChange(String factoryId, String factoryClass, String spiName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.spiMayChange$str(), (Object)factoryId, (Object)factoryClass, (Object)spiName);
    }

    protected String spiMayChange$str() {
        return "KC-SERVICES0047: %s (%s) is implementing the internal SPI %s. This SPI is internal and may change without notice";
    }

    @Override
    public final void exceptionDuringRollback(RuntimeException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.exceptionDuringRollback$str(), new Object[0]);
    }

    protected String exceptionDuringRollback$str() {
        return "KC-SERVICES0048: Exception during rollback";
    }

    @Override
    public final void clientRegistrationException(String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.clientRegistrationException$str(), (Object)message);
    }

    protected String clientRegistrationException$str() {
        return "KC-SERVICES0049: %s";
    }

    @Override
    public final void initializingAdminRealm(String adminRealmName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.initializingAdminRealm$str(), (Object)adminRealmName);
    }

    protected String initializingAdminRealm$str() {
        return "KC-SERVICES0050: Initializing %s realm";
    }

    @Override
    public final void failedToLogoutClient(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToLogoutClient$str(), new Object[0]);
    }

    protected String failedToLogoutClient$str() {
        return "KC-SERVICES0051: Failed to logout client, continuing";
    }

    @Override
    public final void failedProcessingType(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedProcessingType$str(), new Object[0]);
    }

    protected String failedProcessingType$str() {
        return "KC-SERVICES0052: Failed processing type";
    }

    @Override
    public final void unknownAction(String action) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unknownAction$str(), (Object)action);
    }

    protected String unknownAction$str() {
        return "KC-SERVICES0054: Unknown action: %s";
    }

    @Override
    public final void errorAuthenticating(Exception e, String message) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorAuthenticating$str(), (Object)message);
    }

    protected String errorAuthenticating$str() {
        return "KC-SERVICES0055: %s";
    }

    @Override
    public final void errorClosingLDAP(NamingException ne) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)ne, this.errorClosingLDAP$str(), new Object[0]);
    }

    protected String errorClosingLDAP$str() {
        return "KC-SERVICES0056: Error when closing LDAP connection";
    }

    @Override
    public final void logoutFailed(IOException ioe, String clientId) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)ioe, this.logoutFailed$str(), (Object)clientId);
    }

    protected String logoutFailed$str() {
        return "KC-SERVICES0057: Logout for client '%s' failed";
    }

    @Override
    public final void failedToSendRevocation(IOException ioe) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)ioe, this.failedToSendRevocation$str(), new Object[0]);
    }

    protected String failedToSendRevocation$str() {
        return "KC-SERVICES0058: Failed to send revocation request";
    }

    @Override
    public final void availabilityTestFailed(String managementUrl) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.availabilityTestFailed$str(), (Object)managementUrl);
    }

    protected String availabilityTestFailed$str() {
        return "KC-SERVICES0059: Availability test failed for uri '%s'";
    }

    @Override
    public final void roleNotInRealm(String offlineAccessRole) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.roleNotInRealm$str(), (Object)offlineAccessRole);
    }

    protected String roleNotInRealm$str() {
        return "KC-SERVICES0060: Role '%s' not available in realm";
    }

    @Override
    public final void errorDuringFullUserSync(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorDuringFullUserSync$str(), new Object[0]);
    }

    protected String errorDuringFullUserSync$str() {
        return "KC-SERVICES0061: Error occurred during full sync of users";
    }

    @Override
    public final void errorDuringChangedUserSync(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorDuringChangedUserSync$str(), new Object[0]);
    }

    protected String errorDuringChangedUserSync$str() {
        return "KC-SERVICES0062: Error occurred during sync of changed users";
    }

    @Override
    public final void failedToFormatMessage(String cause) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToFormatMessage$str(), (Object)cause);
    }

    protected String failedToFormatMessage$str() {
        return "KC-SERVICES0063: Failed to format message due to: %s";
    }

    @Override
    public final void failedToloadMessages(IOException ioe) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)ioe, this.failedToloadMessages$str(), new Object[0]);
    }

    protected String failedToloadMessages$str() {
        return "KC-SERVICES0064: Failed to load messages";
    }

    @Override
    public final void failedToUpdatePassword(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToUpdatePassword$str(), new Object[0]);
    }

    protected String failedToUpdatePassword$str() {
        return "KC-SERVICES0065: Failed to update Password";
    }

    @Override
    public final void couldNotFireEvent(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.couldNotFireEvent$str(), new Object[0]);
    }

    protected String couldNotFireEvent$str() {
        return "KC-SERVICES0066: Could not fire event.";
    }

    @Override
    public final void failedToParseRestartLoginCookie(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToParseRestartLoginCookie$str(), new Object[0]);
    }

    protected String failedToParseRestartLoginCookie$str() {
        return "KC-SERVICES0067: failed to parse RestartLoginCookie";
    }

    @Override
    public final void notFoundSerializedCtxInClientSession(String noteKey) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.notFoundSerializedCtxInClientSession$str(), (Object)noteKey);
    }

    protected String notFoundSerializedCtxInClientSession$str() {
        return "KC-SERVICES0068: Not found serialized context in clientSession under note '%s'";
    }

    @Override
    public final void flowNotConfigForIDP(String identityProviderAlias) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.flowNotConfigForIDP$str(), (Object)identityProviderAlias);
    }

    protected String flowNotConfigForIDP$str() {
        return "KC-SERVICES0069: Flow not configured for identity provider '%s'";
    }

    @Override
    public final void flowNotFoundForIDP(String flowId, String identityProviderAlias) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.flowNotFoundForIDP$str(), (Object)flowId, (Object)identityProviderAlias);
    }

    protected String flowNotFoundForIDP$str() {
        return "KC-SERVICES0070: Not found configured flow with ID '%s' for identity provider '%s'";
    }

    @Override
    public final void reqdActionDoesNotMatch() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.reqdActionDoesNotMatch$str(), new Object[0]);
    }

    protected String reqdActionDoesNotMatch$str() {
        return "KC-SERVICES0071: required action doesn't match current required action";
    }

    @Override
    public final void invalidKeyForEmailVerification() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidKeyForEmailVerification$str(), new Object[0]);
    }

    protected String invalidKeyForEmailVerification$str() {
        return "KC-SERVICES0072: Invalid key for email verification";
    }

    @Override
    public final void userSessionNull() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.userSessionNull$str(), new Object[0]);
    }

    protected String userSessionNull$str() {
        return "KC-SERVICES0073: User session was null";
    }

    @Override
    public final void actionProviderNull() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.actionProviderNull$str(), new Object[0]);
    }

    protected String actionProviderNull$str() {
        return "KC-SERVICES0074: Required action provider was null";
    }

    @Override
    public final void failedToGetThemeRequest(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.failedToGetThemeRequest$str(), new Object[0]);
    }

    protected String failedToGetThemeRequest$str() {
        return "KC-SERVICES0075: Failed to get theme request";
    }

    @Override
    public final void rejectedNonLocalAttemptToCreateInitialUser(String remoteAddr) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.rejectedNonLocalAttemptToCreateInitialUser$str(), (Object)remoteAddr);
    }

    protected String rejectedNonLocalAttemptToCreateInitialUser$str() {
        return "KC-SERVICES0076: Rejected non-local attempt to create initial user from %s";
    }

    @Override
    public final void createdTemporaryAdminUser(String userName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.createdTemporaryAdminUser$str(), (Object)userName);
    }

    protected String createdTemporaryAdminUser$str() {
        return "KC-SERVICES0077: Created temporary admin user with username %s";
    }

    @Override
    public final void createdTemporaryAdminService(String clientId) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.createdTemporaryAdminService$str(), (Object)clientId);
    }

    protected String createdTemporaryAdminService$str() {
        return "KC-SERVICES0078: Created temporary admin service account with client id %s";
    }

    @Override
    public final void localeNotSpecified() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.localeNotSpecified$str(), new Object[0]);
    }

    protected String localeNotSpecified$str() {
        return "KC-SERVICES0079: Locale not specified for messages.json";
    }

    @Override
    public final void msgBundleNotFound(String lang) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.msgBundleNotFound$str(), (Object)lang);
    }

    protected String msgBundleNotFound$str() {
        return "KC-SERVICES0080: Message bundle not found for language code '%s'";
    }

    @Override
    public final void msgBundleNotFoundForEn() {
        this.log.logf(FQCN, Logger.Level.FATAL, null, this.msgBundleNotFoundForEn$str(), new Object[0]);
    }

    protected String msgBundleNotFoundForEn$str() {
        return "KC-SERVICES0081: Message bundle not found for language code 'en'";
    }

    @Override
    public final void noEventStoreProvider() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.noEventStoreProvider$str(), new Object[0]);
    }

    protected String noEventStoreProvider$str() {
        return "KC-SERVICES0082: Admin Events enabled, but no event store provider configured";
    }

    @Override
    public final void providerNotFound(String id) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.providerNotFound$str(), (Object)id);
    }

    protected String providerNotFound$str() {
        return "KC-SERVICES0083: Event listener '%s' registered, but provider not found";
    }

    @Override
    public final void failedToSaveEvent(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToSaveEvent$str(), new Object[0]);
    }

    protected String failedToSaveEvent$str() {
        return "KC-SERVICES0084: Failed to save event";
    }

    @Override
    public final void failedToSendType(Throwable t, EventListenerProvider listener) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToSendType$str(), (Object)listener);
    }

    protected String failedToSendType$str() {
        return "KC-SERVICES0085: Failed to send type to %s";
    }

    @Override
    public final void addedKerberosToRealmCredentials() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.addedKerberosToRealmCredentials$str(), new Object[0]);
    }

    protected String addedKerberosToRealmCredentials$str() {
        return "KC-SERVICES0086: Added 'kerberos' to required realm credentials";
    }

    @Override
    public final void syncingDataForMapper(String modelName, String mapperType, String direction) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.syncingDataForMapper$str(), (Object)modelName, (Object)mapperType, (Object)direction);
    }

    protected String syncingDataForMapper$str() {
        return "KC-SERVICES0087: Syncing data for mapper '%s' of type '%s'. Direction: %s";
    }

    @Override
    public final void failedToSendActionsEmail(EmailException e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToSendActionsEmail$str(), new Object[0]);
    }

    protected String failedToSendActionsEmail$str() {
        return "KC-SERVICES0088: Failed to send execute actions email";
    }

    @Override
    public final void failedToRunScheduledTask(Throwable t, String taskClass) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToRunScheduledTask$str(), (Object)taskClass);
    }

    protected String failedToRunScheduledTask$str() {
        return "KC-SERVICES0089: Failed to run scheduled task %s";
    }

    @Override
    public final void failedToCloseProviderSession(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToCloseProviderSession$str(), new Object[0]);
    }

    protected String failedToCloseProviderSession$str() {
        return "KC-SERVICES0090: Failed to close ProviderSession";
    }

    @Override
    public final void oidcScopeMissing() {
        if (this.log.isEnabled(Logger.Level.DEBUG) && oidcScopeMissing_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.DEBUG, null, this.oidcScopeMissing$str(), new Object[0]);
        }
    }

    protected String oidcScopeMissing$str() {
        return "KC-SERVICES0091: Request is missing scope 'openid' so it's not treated as OIDC, but just pure OAuth2 request.";
    }

    @Override
    public final void missingParameter(String paramName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.missingParameter$str(), (Object)paramName);
    }

    protected String missingParameter$str() {
        return "KC-SERVICES0092: Missing parameter: %s";
    }

    @Override
    public final void invalidParameter(String paramName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.invalidParameter$str(), (Object)paramName);
    }

    protected String invalidParameter$str() {
        return "KC-SERVICES0093: Invalid parameter value for: %s";
    }

    @Override
    public final void unsupportedParameter(String paramName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.unsupportedParameter$str(), (Object)paramName);
    }

    protected String unsupportedParameter$str() {
        return "KC-SERVICES0094: Unsupported parameter: %s";
    }

    @Override
    public final void flowNotAllowed(String flowName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.flowNotAllowed$str(), (Object)flowName);
    }

    protected String flowNotAllowed$str() {
        return "KC-SERVICES0095: Client is not allowed to initiate browser login with given response_type. %s flow is disabled for the client.";
    }

    @Override
    public final void supportedJwkNotFound(String usage) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.supportedJwkNotFound$str(), (Object)usage);
    }

    protected String supportedJwkNotFound$str() {
        return "KC-SERVICES0096: Not found JWK of supported keyType under jwks_uri for usage: %s";
    }

    @Override
    public final void invalidRequest(Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.invalidRequest$str(), new Object[0]);
    }

    protected String invalidRequest$str() {
        return "KC-SERVICES0097: Invalid request";
    }

    @Override
    public final void clientRegistrationRequestRejected(String opDescription, String detailedMessage) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.clientRegistrationRequestRejected$str(), (Object)opDescription, (Object)detailedMessage);
    }

    protected String clientRegistrationRequestRejected$str() {
        return "KC-SERVICES0099: Operation '%s' rejected. %s";
    }

    @Override
    public final void clientRegistrationMapperNotAllowed(String mapperName, String mapperType) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.clientRegistrationMapperNotAllowed$str(), (Object)mapperName, (Object)mapperType);
    }

    protected String clientRegistrationMapperNotAllowed$str() {
        return "KC-SERVICES0100: ProtocolMapper '%s' of type '%s' not allowed";
    }

    @Override
    public final void failedToVerifyRemoteHost(String hostname) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.failedToVerifyRemoteHost$str(), (Object)hostname);
    }

    protected String failedToVerifyRemoteHost$str() {
        return "KC-SERVICES0101: Failed to verify remote host : %s";
    }

    @Override
    public final void urlDoesntMatch(String url) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.urlDoesntMatch$str(), (Object)url);
    }

    protected String urlDoesntMatch$str() {
        return "KC-SERVICES0102: URL '%s' doesn't match any trustedHost or trustedDomain";
    }

    @Override
    public final void passwordResetFailed(Throwable t) {
        this.log.logf(FQCN, Logger.Level.DEBUG, t, this.passwordResetFailed$str(), new Object[0]);
    }

    protected String passwordResetFailed$str() {
        return "KC-SERVICES0103: Failed to reset password. User is temporarily disabled";
    }

    @Override
    public final void notCreatingExistingUser(String userName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.notCreatingExistingUser$str(), (Object)userName);
    }

    protected String notCreatingExistingUser$str() {
        return "KC-SERVICES0104: Not creating user %s. It already exists.";
    }

    @Override
    public final void responseModeQueryJwtNotAllowed() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.responseModeQueryJwtNotAllowed$str(), new Object[0]);
    }

    protected String responseModeQueryJwtNotAllowed$str() {
        return "KC-SERVICES0105: Response_mode 'query.jwt' is allowed only when the authorization response token is encrypted";
    }

    @Override
    public final void scriptEngineCreated(String engineName, String engineVersion, String mimeType) {
        if (this.log.isEnabled(Logger.Level.INFO) && scriptEngineCreated_$Once.compareAndSet(false, true)) {
            this.log.logf(FQCN, Logger.Level.INFO, null, this.scriptEngineCreated$str(), (Object)engineName, (Object)engineVersion, (Object)mimeType);
        }
    }

    protected String scriptEngineCreated$str() {
        return "KC-SERVICES0106: Created script engine '%s', version '%s' for the mime type '%s'";
    }

    @Override
    public final void addAdminUserFailedUsersExist(String realm) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.addAdminUserFailedUsersExist$str(), (Object)realm);
    }

    protected String addAdminUserFailedUsersExist$str() {
        return "KC-SERVICES0107: Skipping create admin user. User(s) already exist in realm '%s'.";
    }

    @Override
    public final void uriDoesntMatch(String uri) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.uriDoesntMatch$str(), (Object)uri);
    }

    protected String uriDoesntMatch$str() {
        return "KC-SERVICES0108: URI '%s' doesn't match any trustedHost or trustedDomain";
    }

    @Override
    public final void addClientFailedClientExists(String clientId, String realm) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.addClientFailedClientExists$str(), (Object)clientId, (Object)realm);
    }

    protected String addClientFailedClientExists$str() {
        return "KC-SERVICES0109: Failed to add client '%s' to realm '%s': client with client ID exists";
    }

    @Override
    public final void usingDeprecatedEnvironmentVariable(String deprecated, String supported) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.usingDeprecatedEnvironmentVariable$str(), (Object)deprecated, (Object)supported);
    }

    protected String usingDeprecatedEnvironmentVariable$str() {
        return "KC-SERVICES0110: Environment variable '%s' is deprecated, use '%s' instead";
    }
}

