/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.JacksonConstants;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.PropertyNamingStrategyFactory;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;

public class EnumProcessor {
    private static final int ENUM = 16384;

    private EnumProcessor() {
    }

    public static List<Object> enumConstants(AnnotationScannerContext context, Type enumType) {
        ClassInfo enumKlazz = context.getIndex().getClassByName(TypeUtil.getName(enumType));
        Function<FieldInfo, String> nameTranslator = EnumProcessor.nameTranslator(context, enumKlazz);
        return enumKlazz.annotationsMap().getOrDefault(JacksonConstants.JSON_VALUE, Collections.emptyList()).stream().filter(atJsonValue -> context.annotations().value((AnnotationInstance)atJsonValue, "value", true)).map(AnnotationInstance::target).filter(JandexUtil::isSupplier).map(valueTarget -> EnumProcessor.jacksonJsonValues(context, enumKlazz, valueTarget)).filter(Objects::nonNull).findFirst().orElseGet(() -> JandexUtil.fields(context, enumKlazz).stream().filter(field -> (field.flags() & 0x4000) != 0).map(nameTranslator::apply).collect(Collectors.toList()));
    }

    private static List<Object> jacksonJsonValues(AnnotationScannerContext context, ClassInfo enumKlazz, AnnotationTarget valueTarget) {
        String className = enumKlazz.name().toString();
        String methodName = valueTarget.asMethod().name();
        try {
            Class<?> loadedEnum = Class.forName(className, false, context.getClassLoader());
            Method valueMethod = loadedEnum.getDeclaredMethod(methodName, new Class[0]);
            ?[] constants = loadedEnum.getEnumConstants();
            ArrayList<Object> reflectedEnumeration = new ArrayList<Object>(constants.length);
            for (Object constant : constants) {
                reflectedEnumeration.add(valueMethod.invoke(constant, new Object[0]));
            }
            return reflectedEnumeration;
        }
        catch (Exception e) {
            DataObjectLogging.logger.exceptionReadingEnumJsonValue(className, methodName, e);
            return null;
        }
    }

    private static Function<FieldInfo, String> nameTranslator(AnnotationScannerContext context, ClassInfo enumKlazz) {
        return Optional.ofNullable((Type)context.annotations().getAnnotationValue((AnnotationTarget)enumKlazz, JacksonConstants.ENUM_NAMING, "value")).map(namingClass -> namingClass.name().toString()).map(namingClass -> PropertyNamingStrategyFactory.getStrategy(namingClass, context.getClassLoader())).map(nameStrategy -> fieldInfo -> (String)nameStrategy.apply(fieldInfo.name())).orElse(fieldInfo -> Optional.ofNullable((String)context.annotations().getAnnotationValue((AnnotationTarget)fieldInfo, JacksonConstants.JSON_PROPERTY, "value")).orElseGet(() -> ((FieldInfo)fieldInfo).name()));
    }
}

