/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.dataconversion.JavaStringCodec;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=12)
@SerializeWith(value=MediaTypeExternalizer.class)
public final class MediaType {
    private static final Pattern TREE_PATTERN;
    private static final Pattern LIST_SEPARATOR_PATTERN;
    public static final String APPLICATION_OPENMETRICS_TYPE = "application/openmetrics-text";
    public static final String APPLICATION_JAVASCRIPT_TYPE = "application/javascript";
    public static final String APPLICATION_JSON_TYPE = "application/json";
    public static final String APPLICATION_OCTET_STREAM_TYPE = "application/octet-stream";
    public static final String APPLICATION_OBJECT_TYPE = "application/x-java-object";
    public static final String APPLICATION_PDF_TYPE = "application/pdf";
    public static final String APPLICATION_RTF_TYPE = "application/rtf";
    public static final String APPLICATION_SERIALIZED_OBJECT_TYPE = "application/x-java-serialized-object";
    public static final String APPLICATION_XML_TYPE = "application/xml";
    public static final String APPLICATION_YAML_TYPE = "application/yaml";
    public static final String APPLICATION_ZIP_TYPE = "application/zip";
    public static final String APPLICATION_JBOSS_MARSHALLING_TYPE = "application/x-jboss-marshalling";
    public static final String APPLICATION_PROTOSTREAM_TYPE = "application/x-protostream";
    @Deprecated(forRemoval=true, since="11.0")
    public static final String APPLICATION_UNKNOWN_TYPE = "application/unknown";
    public static final String WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";
    public static final String IMAGE_GIF_TYPE = "image/gif";
    public static final String IMAGE_JPEG_TYPE = "image/jpeg";
    public static final String IMAGE_PNG_TYPE = "image/png";
    public static final String MULTIPART_FORM_DATA_TYPE = "multipart/form-data";
    public static final String TEXT_CSS_TYPE = "text/css";
    public static final String TEXT_CSV_TYPE = "text/csv";
    public static final String TEXT_PLAIN_TYPE = "text/plain";
    public static final String TEXT_HTML_TYPE = "text/html";
    public static final String TEXT_EVENT_STREAM_TYPE = "text/event-stream";
    @Deprecated(forRemoval=true, since="11.0")
    public static final String APPLICATION_INFINISPAN_MARSHALLING_TYPE = "application/x-infinispan-marshalling";
    @Deprecated(forRemoval=true, since="11.0")
    public static final String APPLICATION_INFINISPAN_BINARY_TYPE = "application/x-infinispan-binary";
    public static final String MATCH_ALL_TYPE = "*/*";
    public static final MediaType APPLICATION_OPENMETRICS;
    public static final MediaType APPLICATION_JAVASCRIPT;
    public static final MediaType APPLICATION_JSON;
    public static final MediaType APPLICATION_OCTET_STREAM;
    public static final MediaType APPLICATION_OBJECT;
    public static final MediaType APPLICATION_SERIALIZED_OBJECT;
    public static final MediaType APPLICATION_XML;
    public static final MediaType APPLICATION_YAML;
    public static final MediaType APPLICATION_PROTOSTREAM;
    public static final MediaType APPLICATION_JBOSS_MARSHALLING;
    @Deprecated(forRemoval=true, since="11.0")
    public static final MediaType APPLICATION_INFINISPAN_MARSHALLED;
    public static final MediaType APPLICATION_WWW_FORM_URLENCODED;
    public static final MediaType IMAGE_PNG;
    public static final MediaType MULTIPART_FORM_DATA;
    public static final MediaType TEXT_PLAIN;
    public static final MediaType TEXT_CSS;
    public static final MediaType TEXT_CSV;
    public static final MediaType TEXT_HTML;
    public static final MediaType IMAGE_GIF;
    public static final MediaType IMAGE_JPEG;
    public static final MediaType TEXT_EVENT_STREAM;
    @Deprecated(forRemoval=true, since="11.0")
    public static final MediaType APPLICATION_INFINISPAN_BINARY;
    public static final MediaType APPLICATION_PDF;
    public static final MediaType APPLICATION_RTF;
    public static final MediaType APPLICATION_ZIP;
    @Deprecated(forRemoval=true, since="11.0")
    public static final MediaType APPLICATION_INFINISPAN_MARSHALLING;
    @Deprecated(forRemoval=true, since="11.0")
    public static final MediaType APPLICATION_UNKNOWN;
    public static final MediaType MATCH_ALL;
    @Deprecated(forRemoval=true, since="11.0")
    public static final String BYTE_ARRAY_TYPE;
    private static final String WEIGHT_PARAM_NAME = "q";
    private static final String CHARSET_PARAM_NAME = "charset";
    private static final String CLASS_TYPE_PARAM_NAME = "type";
    private static final String ENCODING_PARAM_NAME = "encoding";
    private static final double DEFAULT_WEIGHT = 1.0;
    private static final Charset DEFAULT_CHARSET;
    public static final String HEX = "hex";
    public static final String BASE_64 = "base64";
    private final Map<String, String> params;
    private final String typeSubtype;
    private final int typeLength;
    private final boolean matchesAll;
    private final transient double weight;

    public MediaType(String type, String subtype) {
        this(type, subtype, Collections.emptyMap());
    }

    public MediaType(String type, String subtype, Map<String, String> params) {
        this(type + "/" + subtype, type.length(), params);
    }

    public MediaType(String typeSubtype) {
        this(typeSubtype, Collections.emptyMap());
    }

    public MediaType(String typeSubType, Map<String, String> params) {
        this(typeSubType, MediaType.validate(typeSubType), params);
    }

    private MediaType(String typeSubType, int typeLength, Map<String, String> params) {
        this.typeSubtype = typeSubType;
        this.typeLength = typeLength;
        this.matchesAll = this.typeSubtype.equals(MATCH_ALL_TYPE);
        if (params != null) {
            this.params = Map.copyOf(params);
            String weight = params.get(WEIGHT_PARAM_NAME);
            this.weight = weight != null ? MediaType.parseWeight(weight) : 1.0;
        } else {
            this.params = Collections.emptyMap();
            this.weight = 1.0;
        }
    }

    @ProtoField(value=1)
    String getTree() {
        return this.toString();
    }

    @Deprecated(forRemoval=true, since="11.0")
    public static MediaType parse(String str) {
        return MediaType.fromString(str);
    }

    @ProtoFactory
    public static MediaType fromString(String tree) {
        if (tree == null || tree.isEmpty()) {
            throw Log.CONTAINER.missingMediaType();
        }
        Matcher matcher = TREE_PATTERN.matcher(tree);
        return MediaType.parseSingleMediaType(tree, matcher, false);
    }

    private static MediaType parseSingleMediaType(String input, Matcher matcher, boolean isList) {
        int typeLength;
        String typeSubtype;
        if (!matcher.lookingAt() || matcher.start(1) < 0) {
            throw Log.CONTAINER.invalidMediaTypeSubtype(input);
        }
        if (matcher.start(2) >= 0) {
            typeSubtype = matcher.group(1);
            typeLength = matcher.end(2) - matcher.start(2);
        } else {
            typeSubtype = MATCH_ALL_TYPE;
            typeLength = 1;
        }
        Map<Object, Object> paramMap = null;
        String firstParamName = null;
        String firstParamValue = null;
        while (matcher.end() < input.length()) {
            if (!matcher.find()) {
                throw Log.CONTAINER.invalidMediaTypeParam(input, input.substring(matcher.regionStart()));
            }
            String paramName = matcher.group(3);
            String paramValue = matcher.group(4);
            if (paramName == null) {
                if (!isList) {
                    throw Log.CONTAINER.invalidMediaTypeSubtype(input);
                }
                if (matcher.end() < input.length()) break;
                throw Log.CONTAINER.invalidMediaTypeListCommaAtEnd(input);
            }
            if (firstParamName == null) {
                firstParamName = paramName;
                firstParamValue = paramValue;
                continue;
            }
            if (paramMap == null) {
                paramMap = new HashMap<Object, Object>();
            }
            paramMap.put(firstParamName, firstParamValue);
            paramMap.put(paramName, paramValue);
        }
        if (paramMap == null && firstParamName != null) {
            paramMap = Collections.singletonMap(firstParamName, firstParamValue);
        }
        return new MediaType(typeSubtype, typeLength, paramMap);
    }

    public static Stream<MediaType> parseList(String mediaTypeList) {
        if (mediaTypeList == null || mediaTypeList.isEmpty()) {
            throw Log.CONTAINER.missingMediaType();
        }
        Matcher matcher = TREE_PATTERN.matcher(mediaTypeList);
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        while (true) {
            MediaType mediaType = MediaType.parseSingleMediaType(mediaTypeList, matcher, true);
            list.add(mediaType);
            if (matcher.end() == mediaTypeList.length()) break;
            matcher.region(matcher.end(), mediaTypeList.length());
        }
        list.sort(Comparator.comparingDouble(MediaType::getWeight).reversed());
        return list.stream();
    }

    private static double parseWeight(String weightValue) {
        try {
            return Double.parseDouble(weightValue);
        }
        catch (NumberFormatException nf) {
            throw Log.CONTAINER.invalidWeight(weightValue);
        }
    }

    public static MediaType fromExtension(String name) {
        String extension;
        int last = name.lastIndexOf(46);
        switch (extension = last < 0 ? name : name.substring(last + 1)) {
            case "xml": {
                return APPLICATION_XML;
            }
            case "yaml": 
            case "yml": {
                return APPLICATION_YAML;
            }
            case "json": {
                return APPLICATION_JSON;
            }
        }
        Log.CONFIG.tracef("Unknown extension: %s", name);
        return null;
    }

    public boolean match(MediaType other) {
        if (other == this) {
            return true;
        }
        return other != null && (other.matchesAll() || this.matchesAll() || other.typeSubtype.equals(this.typeSubtype));
    }

    public boolean matchesAll() {
        return this.matchesAll;
    }

    public String getTypeSubtype() {
        return this.typeSubtype;
    }

    public MediaType withoutParameters() {
        if (this.params.isEmpty()) {
            return this;
        }
        return new MediaType(this.typeSubtype);
    }

    public double getWeight() {
        return this.weight;
    }

    public Charset getCharset() {
        return this.getParameter(CHARSET_PARAM_NAME).map(Charset::forName).orElse(DEFAULT_CHARSET);
    }

    public String getClassType() {
        return this.getParameter(CLASS_TYPE_PARAM_NAME).orElse(null);
    }

    public MediaType withClassType(Class<?> clazz) {
        return this.withParameter(CLASS_TYPE_PARAM_NAME, clazz.getName());
    }

    public MediaType withEncoding(String enc) {
        return this.withParameter(ENCODING_PARAM_NAME, enc);
    }

    public String getEncoding() {
        return this.getParameter(ENCODING_PARAM_NAME).orElse(null);
    }

    public boolean hasStringType() {
        String classType = this.getClassType();
        return classType != null && classType.equals(String.class.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return this.params.equals(mediaType.params) && this.typeSubtype.equals(mediaType.typeSubtype);
    }

    public int hashCode() {
        int result = this.params.hashCode();
        result = 31 * result + this.typeSubtype.hashCode();
        return result;
    }

    public String getType() {
        return this.typeSubtype.substring(0, this.typeLength);
    }

    public String getSubType() {
        return this.typeSubtype.substring(this.typeLength + 1);
    }

    public boolean hasParameters() {
        return !this.params.isEmpty();
    }

    public Optional<String> getParameter(String name) {
        return Optional.ofNullable(this.params.get(name));
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.params);
    }

    public MediaType withParameters(Map<String, String> parameters) {
        return parameters.isEmpty() ? this : new MediaType(this.typeSubtype, parameters);
    }

    private static int validate(String typeSubtype) {
        if (typeSubtype == null) {
            throw new NullPointerException("type and subtype cannot be null");
        }
        Matcher matcher = TREE_PATTERN.matcher(typeSubtype);
        if (!matcher.matches()) {
            throw Log.CONTAINER.invalidMediaTypeSubtype(typeSubtype);
        }
        return matcher.end(2);
    }

    public MediaType withCharset(Charset charset) {
        return this.withParameter(CHARSET_PARAM_NAME, charset.toString());
    }

    public MediaType withParameter(String name, String value) {
        HashMap<String, String> newParams = new HashMap<String, String>(this.params);
        newParams.put(name, value);
        return new MediaType(this.typeSubtype, newParams);
    }

    @Deprecated(forRemoval=true)
    public String toStringExcludingParam(String ... params) {
        if (!this.hasParameters()) {
            return this.typeSubtype;
        }
        StringBuilder builder = new StringBuilder().append(this.typeSubtype);
        String strParams = this.params.entrySet().stream().filter(e -> Arrays.stream(params).noneMatch(p -> p.equals(e.getKey()))).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("; "));
        if (strParams.isEmpty()) {
            return builder.toString();
        }
        return builder.append("; ").append(strParams).toString();
    }

    public boolean isBinary() {
        String customType = this.getClassType();
        if (customType == null) {
            return !this.match(APPLICATION_OBJECT);
        }
        return JavaStringCodec.BYTE_ARRAY.getName().equals(customType);
    }

    public String toString() {
        if (!this.hasParameters()) {
            return this.typeSubtype;
        }
        StringBuilder builder = new StringBuilder().append(this.typeSubtype);
        String strParams = this.params.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("; "));
        return builder.append("; ").append(strParams).toString();
    }

    static {
        String ows = "[ \t]*";
        String token = "[!#$%&'*+.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz^_`|~-]+";
        String quotedString = "\"(?:[^\"\\\\]|\\\\.)*\"";
        String typeSubtype = ows + "((" + token + ")/" + token + "|\\*)" + ows;
        String parameter = ";" + ows + "(" + token + ")=(" + token + "|" + quotedString + ")" + ows;
        String listSeparator = "\\G," + ows;
        String tree = "^" + typeSubtype + "|\\G" + parameter + "|\\G" + listSeparator;
        TREE_PATTERN = Pattern.compile(tree, 32);
        LIST_SEPARATOR_PATTERN = Pattern.compile(listSeparator, 32);
        APPLICATION_OPENMETRICS = MediaType.fromString(APPLICATION_OPENMETRICS_TYPE);
        APPLICATION_JAVASCRIPT = MediaType.fromString(APPLICATION_JAVASCRIPT_TYPE);
        APPLICATION_JSON = MediaType.fromString(APPLICATION_JSON_TYPE);
        APPLICATION_OCTET_STREAM = MediaType.fromString(APPLICATION_OCTET_STREAM_TYPE);
        APPLICATION_OBJECT = MediaType.fromString(APPLICATION_OBJECT_TYPE);
        APPLICATION_SERIALIZED_OBJECT = MediaType.fromString(APPLICATION_SERIALIZED_OBJECT_TYPE);
        APPLICATION_XML = MediaType.fromString(APPLICATION_XML_TYPE);
        APPLICATION_YAML = MediaType.fromString(APPLICATION_YAML_TYPE);
        APPLICATION_PROTOSTREAM = MediaType.fromString(APPLICATION_PROTOSTREAM_TYPE);
        APPLICATION_JBOSS_MARSHALLING = MediaType.fromString(APPLICATION_JBOSS_MARSHALLING_TYPE);
        APPLICATION_INFINISPAN_MARSHALLED = MediaType.fromString(APPLICATION_INFINISPAN_MARSHALLING_TYPE);
        APPLICATION_WWW_FORM_URLENCODED = MediaType.fromString(WWW_FORM_URLENCODED_TYPE);
        IMAGE_PNG = MediaType.fromString(IMAGE_PNG_TYPE);
        MULTIPART_FORM_DATA = MediaType.fromString(MULTIPART_FORM_DATA_TYPE);
        TEXT_PLAIN = MediaType.fromString(TEXT_PLAIN_TYPE);
        TEXT_CSS = MediaType.fromString(TEXT_CSS_TYPE);
        TEXT_CSV = MediaType.fromString(TEXT_CSV_TYPE);
        TEXT_HTML = MediaType.fromString(TEXT_HTML_TYPE);
        IMAGE_GIF = MediaType.fromString(IMAGE_GIF_TYPE);
        IMAGE_JPEG = MediaType.fromString(IMAGE_JPEG_TYPE);
        TEXT_EVENT_STREAM = MediaType.fromString(TEXT_EVENT_STREAM_TYPE);
        APPLICATION_INFINISPAN_BINARY = MediaType.fromString(APPLICATION_INFINISPAN_BINARY_TYPE);
        APPLICATION_PDF = MediaType.fromString(APPLICATION_PDF_TYPE);
        APPLICATION_RTF = MediaType.fromString(APPLICATION_RTF_TYPE);
        APPLICATION_ZIP = MediaType.fromString(APPLICATION_ZIP_TYPE);
        APPLICATION_INFINISPAN_MARSHALLING = MediaType.fromString(APPLICATION_INFINISPAN_MARSHALLING_TYPE);
        APPLICATION_UNKNOWN = MediaType.fromString(APPLICATION_UNKNOWN_TYPE);
        MATCH_ALL = MediaType.fromString(MATCH_ALL_TYPE);
        BYTE_ARRAY_TYPE = JavaStringCodec.BYTE_ARRAY.getName();
        DEFAULT_CHARSET = StandardCharsets.UTF_8;
    }

    public static final class MediaTypeExternalizer
    implements Externalizer<MediaType> {
        @Override
        public void writeObject(ObjectOutput output, MediaType mediaType) throws IOException {
            Short id = MediaTypeIds.getId(mediaType);
            if (id == null) {
                output.writeBoolean(false);
                output.writeUTF(mediaType.typeSubtype);
                output.writeObject(mediaType.params);
            } else {
                output.writeBoolean(true);
                output.writeShort(id.shortValue());
                output.writeObject(mediaType.params);
            }
        }

        @Override
        public MediaType readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            boolean isInternal = input.readBoolean();
            if (isInternal) {
                short id = input.readShort();
                Map params = (Map)input.readObject();
                return MediaTypeIds.getMediaType(id).withParameters(params);
            }
            String typeSubType = input.readUTF();
            Map params = (Map)input.readObject();
            return new MediaType(typeSubType, params);
        }
    }
}

