/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.util.Log;

class SearchReplyJob
extends JobImpl {
    private final DatabaseSearchReplyMessage _msg;
    private final Log _log;
    private final Hash _peer;
    private int _seenPeers;
    private int _newPeers;
    private int _duplicatePeers;
    private final long _duration;
    private final SearchJob _searchJob;

    public SearchReplyJob(RouterContext enclosingContext, SearchJob job, DatabaseSearchReplyMessage message, Hash peer, long duration) {
        super(enclosingContext);
        this._log = enclosingContext.logManager().getLog(this.getClass());
        this._searchJob = job;
        this._msg = message;
        this._peer = peer;
        this._duration = duration > 0L ? duration : 0L;
    }

    @Override
    public String getName() {
        return "Process Reply for Kademlia Search";
    }

    @Override
    public void runJob() {
        int count = Math.min(this._msg.getNumReplies(), 16);
        for (int i = 0; i < count; ++i) {
            this.processPeer(i);
        }
        if (count == 0 && this._log.shouldDebug()) {
            this._log.debug(this.getJobId() + ": dbSearchReply received with no routers referenced");
        }
        this.getContext().profileManager().dbLookupReply(this._peer, this._newPeers, this._seenPeers, 0, this._duplicatePeers, this._duration);
        if (this._newPeers > 0) {
            this._searchJob.newPeersFound(this._newPeers);
        }
    }

    private void processPeer(int curIndex) {
        Hash peer = this._msg.getReply(curIndex);
        boolean shouldAdd = false;
        RouterInfo info = this.getContext().netDb().lookupRouterInfoLocally(peer);
        if (info == null) {
            boolean sendsBadInfo = this.getContext().profileOrganizer().peerSendsBadReplies(this._peer);
            if (!sendsBadInfo) {
                if (!this.getContext().banlist().isBanlisted(peer)) {
                    shouldAdd = true;
                }
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("Peer " + this._peer.toBase64() + " sends us bad replies, so not verifying " + peer.toBase64());
                }
                this.getContext().statManager().addRateData("netDb.searchReplyValidationSkipped", 1L);
            }
        }
        if (this._searchJob.wasAttempted(peer)) {
            ++this._duplicatePeers;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getJobId() + ": dbSearchReply received on search referencing router " + peer + " already known? " + (info != null));
        }
        if (shouldAdd) {
            if (this._searchJob.add(peer)) {
                ++this._newPeers;
            } else {
                ++this._seenPeers;
            }
        }
    }
}

