/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.profile.AbstractTableProfileCreator;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileSettings;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.MonitorableImpl;
import ca.sqlpower.util.reservoir.BasicReservoir;
import ca.sqlpower.util.reservoir.JDBCReserviorDataSource;
import ca.sqlpower.util.reservoir.ReservoirDataException;
import ca.sqlpower.util.reservoir.ReservoirDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LocalReservoirProfileCreator
extends AbstractTableProfileCreator {
    private static final Logger logger = Logger.getLogger(LocalReservoirProfileCreator.class);
    private final ProfileSettings settings;
    private int sampleSize = 50000;

    public LocalReservoirProfileCreator(ProfileSettings settings) {
        if (settings == null) {
            throw new NullPointerException("Null settings");
        }
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doProfileImpl(TableProfileResult tpr) throws ReservoirDataException, SQLException, SQLObjectException {
        Connection con = null;
        Object[][] sample = null;
        SQLTable table = (SQLTable)tpr.getProfiledObject();
        MonitorableImpl pm = (MonitorableImpl)tpr.getProgressMonitor();
        pm.setJobSize(Integer.valueOf(table.getColumns().size() + 1));
        pm.setProgress(1);
        try {
            con = table.getParentDatabase().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT ");
            boolean first = true;
            for (SQLColumn col : table.getColumns()) {
                if (!first) {
                    sql.append(", ");
                }
                sql.append(col.getName());
                first = false;
            }
            sql.append(" FROM ").append(DDLUtils.toQualifiedName(table));
            logger.debug((Object)("About to execute profiling query: " + sql));
            try {
                JDBCReserviorDataSource ds = new JDBCReserviorDataSource(con, sql.toString());
                BasicReservoir r = new BasicReservoir();
                sample = (Object[][])r.getSample((ReservoirDataSource)ds, this.sampleSize);
                tpr.setRowCount(ds.getRowCount());
            }
            catch (Throwable ex) {
                logger.error((Object)"something bad happened", ex);
                throw new RuntimeException(ex);
            }
            logger.debug((Object)("Finished sampling result set. Row count=" + tpr.getRowCount() + "; sample size = " + sample.length));
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Failed to close connection. Squishing this exception: ", (Throwable)ex);
            }
        }
        for (SQLColumn col : table.getColumns()) {
            tpr.addColumnProfileResult(new ColumnProfileResult(col));
        }
        this.profileColumnsFromSample(tpr, sample, pm);
        return true;
    }

    private void profileColumnsFromSample(TableProfileResult tpr, Object[][] sample, MonitorableImpl pm) {
        if (sample.length > 0) {
            for (int col = 0; col < sample[0].length; ++col) {
                pm.setProgress(col + 1);
                ColumnProfileResult cpr = tpr.getColumnProfileResults().get(col);
                cpr.setCreateStartTime(System.currentTimeMillis());
                HashMap<Object, Integer> valueCounts = new HashMap<Object, Integer>();
                double sum = 0.0;
                double lengthSum = 0.0;
                int minLength = 0;
                int maxLength = 0;
                Comparable minValue = null;
                Comparable maxValue = null;
                int nullCount = 0;
                for (int row = 0; row < sample.length; ++row) {
                    Object val = sample[row][col];
                    String sval = val == null ? null : String.valueOf(val);
                    Integer oldCount = (Integer)valueCounts.get(val);
                    if (oldCount == null) {
                        oldCount = new Integer(0);
                    }
                    valueCounts.put(val, oldCount + 1);
                    if (val == null) {
                        ++nullCount;
                    } else if (val instanceof Number) {
                        sum += ((Number)val).doubleValue();
                    }
                    if (sval != null) {
                        lengthSum += (double)sval.length();
                    }
                    if (!(val instanceof Comparable)) continue;
                    Comparable cval = (Comparable)val;
                    if (minValue == null || cval.compareTo(minValue) < 0) {
                        minValue = cval;
                    }
                    if (maxValue != null && cval.compareTo(maxValue) <= 0) continue;
                    maxValue = cval;
                }
                cpr.setAvgLength(lengthSum / (double)sample.length);
                cpr.setAvgValue(sum / (double)sample.length);
                cpr.setDistinctValueCount(valueCounts.size());
                cpr.setMaxLength(maxLength);
                cpr.setMaxValue(maxValue);
                cpr.setMinLength(minLength);
                cpr.setMinValue(minValue);
                cpr.setNullCount(nullCount);
                ArrayList topNList = new ArrayList(valueCounts.entrySet());
                Collections.sort(topNList, new TopNValuesComparator());
                int sumOfTopNCount = 0;
                for (int i = 0; i < this.settings.getTopNCount() && i < topNList.size(); ++i) {
                    Map.Entry entry = (Map.Entry)topNList.get(i);
                    cpr.addValueCount(entry.getKey(), (Integer)entry.getValue());
                    sumOfTopNCount += ((Integer)entry.getValue()).intValue();
                }
                cpr.addValueCount("Other Values", sample.length - sumOfTopNCount);
                cpr.setCreateEndTime(System.currentTimeMillis());
            }
        }
    }

    public String toString() {
        return "Local Reservoir";
    }

    class TopNValuesComparator
    implements Comparator<Map.Entry<Object, Integer>> {
        TopNValuesComparator() {
        }

        @Override
        public int compare(Map.Entry<Object, Integer> o1, Map.Entry<Object, Integer> o2) {
            return o2.getValue().compareTo(o1.getValue());
        }
    }
}

