/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.jdk;

import java.util.Locale;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public final class ThreadDetailsProvider
extends DetailsProvider.Basic {
    private static final String VIRTUAL_THREAD_MASK = "java.lang.VirtualThread";
    private static final int JVMTI_THREAD_STATE_ALIVE = 1;
    private static final int JVMTI_THREAD_STATE_TERMINATED = 2;
    private static final int JVMTI_THREAD_STATE_RUNNABLE = 4;
    private static final int JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static final int JVMTI_THREAD_STATE_WAITING_INDEFINITELY = 16;
    private static final int JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT = 32;
    private static final int NEW = 0;
    private static final int STARTED = 1;
    private static final int RUNNABLE = 2;
    private static final int RUNNING = 3;
    private static final int PARKING = 4;
    private static final int PARKED = 5;
    private static final int PINNED = 6;
    private static final int YIELDING = 7;
    private static final int TERMINATED = 99;
    private static final int SUSPENDED = 256;
    private static final int RUNNABLE_SUSPENDED = 258;
    private static final int PARKED_SUSPENDED = 261;

    public ThreadDetailsProvider() {
        super(Thread.class.getName() + "+", ThreadGroup.class.getName() + "+", VIRTUAL_THREAD_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        switch (className) {
            case "java.lang.VirtualThread": {
                StringBuilder sb = new StringBuilder("[#");
                sb.append(instance.getValueOfField("tid"));
                String name = DetailsUtils.getInstanceFieldString(instance, "name");
                if (!name.isEmpty()) {
                    sb.append(",");
                    sb.append(name);
                }
                sb.append("]/");
                Instance carrier = (Instance)instance.getValueOfField("carrierThread");
                if (carrier != null) {
                    Instance holder = (Instance)carrier.getValueOfField("holder");
                    Integer threadStatus = (Integer)holder.getValueOfField("threadStatus");
                    String stateAsString = ThreadDetailsProvider.toThreadState(threadStatus).toString();
                    sb.append(stateAsString.toLowerCase(Locale.ROOT));
                    sb.append('@');
                    sb.append(DetailsUtils.getInstanceString(carrier));
                }
                if (carrier == null) {
                    String stateAsString = this.getThreadState(instance);
                    sb.append(stateAsString.toLowerCase(Locale.ROOT));
                }
                return sb.toString();
            }
        }
        return DetailsUtils.getInstanceFieldString(instance, "name");
    }

    public static Thread.State toThreadState(int threadStatus) {
        if ((threadStatus & 4) != 0) {
            return Thread.State.RUNNABLE;
        }
        if ((threadStatus & 0x400) != 0) {
            return Thread.State.BLOCKED;
        }
        if ((threadStatus & 0x10) != 0) {
            return Thread.State.WAITING;
        }
        if ((threadStatus & 0x20) != 0) {
            return Thread.State.TIMED_WAITING;
        }
        if ((threadStatus & 2) != 0) {
            return Thread.State.TERMINATED;
        }
        if ((threadStatus & 1) == 0) {
            return Thread.State.NEW;
        }
        return Thread.State.RUNNABLE;
    }

    private String getThreadState(Instance virtualThread) {
        Integer state = (Integer)virtualThread.getValueOfField("state");
        switch (state) {
            case 0: {
                return "new";
            }
            case 1: {
                return "started";
            }
            case 2: {
                return "runnable";
            }
            case 3: {
                return "running";
            }
            case 4: {
                return "parking";
            }
            case 5: {
                return "parked";
            }
            case 6: {
                return "pinned";
            }
            case 7: {
                return "yelding";
            }
            case 99: {
                return "terminated";
            }
        }
        return "unknown";
    }
}

