# -*- coding: utf-8 -*-

"""
***************************************************************************
    __init__.py
    ---------------------
    Date                 : October 2014
    Copyright            : (C) 2014 by Alessandro Pasotti
    Email                : elpaso at itopen dot it
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Alessandro Pasotti'
__date__ = 'October 2014'
__copyright__ = '(C) 2014, Alessandro Pasotti'

from qgis.PyQt import QtCore     # NOQA

from qgis._server import *  # NOQA

"""
This folder is completed using sipify.py script
It is not aimed to be manually edited
"""
# The following has been generated automatically from src/server/qgsaccesscontrolfilter.h
try:
    QgsAccessControlFilter.LayerPermissions.__doc__ = """Describe the layer permission"""
except (NameError, AttributeError):
    pass
# The following has been generated automatically from src/server/qgsconfigcache.h
try:
    QgsConfigCache.__attribute_docs__ = {'projectRemovedFromCache': 'Emitted whenever a project is removed from the cache.\n\n.. versionadded:: 3.38\n'}
    QgsConfigCache.initialize = staticmethod(QgsConfigCache.initialize)
    QgsConfigCache.instance = staticmethod(QgsConfigCache.instance)
    QgsConfigCache.__signal_arguments__ = {'projectRemovedFromCache': ['path: str']}
except (NameError, AttributeError):
    pass
# The following has been generated automatically from src/server/qgsserverapiutils.h
try:
    QgsServerApiUtils.parseBbox = staticmethod(QgsServerApiUtils.parseBbox)
    QgsServerApiUtils.temporalDimensions = staticmethod(QgsServerApiUtils.temporalDimensions)
    QgsServerApiUtils.parseTemporalDateInterval = staticmethod(QgsServerApiUtils.parseTemporalDateInterval)
    QgsServerApiUtils.parseTemporalDateTimeInterval = staticmethod(QgsServerApiUtils.parseTemporalDateTimeInterval)
    QgsServerApiUtils.fieldName = staticmethod(QgsServerApiUtils.fieldName)
    QgsServerApiUtils.temporalFilterExpression = staticmethod(QgsServerApiUtils.temporalFilterExpression)
    QgsServerApiUtils.temporalExtent = staticmethod(QgsServerApiUtils.temporalExtent)
    QgsServerApiUtils.parseCrs = staticmethod(QgsServerApiUtils.parseCrs)
    QgsServerApiUtils.sanitizedFieldValue = staticmethod(QgsServerApiUtils.sanitizedFieldValue)
    QgsServerApiUtils.publishedCrsList = staticmethod(QgsServerApiUtils.publishedCrsList)
    QgsServerApiUtils.crsToOgcUri = staticmethod(QgsServerApiUtils.crsToOgcUri)
    QgsServerApiUtils.appendMapParameter = staticmethod(QgsServerApiUtils.appendMapParameter)
except (NameError, AttributeError):
    pass
# The following has been generated automatically from src/server/qgsserverlogger.h
try:
    QgsServerLogger.instance = staticmethod(QgsServerLogger.instance)
except (NameError, AttributeError):
    pass
# The following has been generated automatically from src/server/qgsserverogcapi.h
QgsServerOgcApi.alternate = QgsServerOgcApi.Rel.alternate
QgsServerOgcApi.describedBy = QgsServerOgcApi.Rel.describedBy
QgsServerOgcApi.collection = QgsServerOgcApi.Rel.collection
QgsServerOgcApi.item = QgsServerOgcApi.Rel.item
QgsServerOgcApi.self = QgsServerOgcApi.Rel.self
QgsServerOgcApi.service_desc = QgsServerOgcApi.Rel.service_desc
QgsServerOgcApi.service_doc = QgsServerOgcApi.Rel.service_doc
QgsServerOgcApi.prev = QgsServerOgcApi.Rel.prev
QgsServerOgcApi.next = QgsServerOgcApi.Rel.next
QgsServerOgcApi.license = QgsServerOgcApi.Rel.license
QgsServerOgcApi.items = QgsServerOgcApi.Rel.items
QgsServerOgcApi.conformance = QgsServerOgcApi.Rel.conformance
QgsServerOgcApi.data = QgsServerOgcApi.Rel.data
QgsServerOgcApi.Rel.baseClass = QgsServerOgcApi
QgsServerOgcApi.GEOJSON = QgsServerOgcApi.ContentType.GEOJSON
QgsServerOgcApi.OPENAPI3 = QgsServerOgcApi.ContentType.OPENAPI3
QgsServerOgcApi.JSON = QgsServerOgcApi.ContentType.JSON
QgsServerOgcApi.HTML = QgsServerOgcApi.ContentType.HTML
QgsServerOgcApi.XML = QgsServerOgcApi.ContentType.XML
QgsServerOgcApi.ContentType.baseClass = QgsServerOgcApi
try:
    QgsServerOgcApi.sanitizeUrl = staticmethod(QgsServerOgcApi.sanitizeUrl)
    QgsServerOgcApi.relToString = staticmethod(QgsServerOgcApi.relToString)
    QgsServerOgcApi.contentTypeToString = staticmethod(QgsServerOgcApi.contentTypeToString)
    QgsServerOgcApi.contentTypeToStdString = staticmethod(QgsServerOgcApi.contentTypeToStdString)
    QgsServerOgcApi.contentTypeToExtension = staticmethod(QgsServerOgcApi.contentTypeToExtension)
    QgsServerOgcApi.contenTypeFromExtension = staticmethod(QgsServerOgcApi.contenTypeFromExtension)
    QgsServerOgcApi.contentTypeFromExtension = staticmethod(QgsServerOgcApi.contentTypeFromExtension)
    QgsServerOgcApi.mimeType = staticmethod(QgsServerOgcApi.mimeType)
except (NameError, AttributeError):
    pass
# The following has been generated automatically from src/server/qgsserverogcapihandler.h
try:
    QgsServerOgcApiHandler.parentLink = staticmethod(QgsServerOgcApiHandler.parentLink)
    QgsServerOgcApiHandler.layerFromCollectionId = staticmethod(QgsServerOgcApiHandler.layerFromCollectionId)
except (NameError, AttributeError):
    pass
# The following has been generated automatically from src/server/qgsserverparameters.h
QgsServerParameter.UNKNOWN = QgsServerParameter.Name.UNKNOWN
QgsServerParameter.SERVICE = QgsServerParameter.Name.SERVICE
QgsServerParameter.VERSION_SERVICE = QgsServerParameter.Name.VERSION_SERVICE
QgsServerParameter.REQUEST = QgsServerParameter.Name.REQUEST
QgsServerParameter.MAP = QgsServerParameter.Name.MAP
QgsServerParameter.FILE_NAME = QgsServerParameter.Name.FILE_NAME
QgsServerParameter.Name.baseClass = QgsServerParameter
try:
    QgsServerParameterDefinition.raiseError = staticmethod(QgsServerParameterDefinition.raiseError)
except (NameError, AttributeError):
    pass
try:
    QgsServerParameter.name = staticmethod(QgsServerParameter.name)
except (NameError, AttributeError):
    pass
# The following has been generated automatically from src/server/qgsserverquerystringparameter.h
# monkey patching scoped based enum
QgsServerQueryStringParameter.Type.String.__doc__ = "Parameter is a string"
QgsServerQueryStringParameter.Type.Integer.__doc__ = "Parameter is an integer"
QgsServerQueryStringParameter.Type.Double.__doc__ = "Parameter is a double"
QgsServerQueryStringParameter.Type.Boolean.__doc__ = "Parameter is a boolean"
QgsServerQueryStringParameter.Type.List.__doc__ = "Parameter is a (comma separated) list of strings, the handler will perform any further required conversion of the list values"
QgsServerQueryStringParameter.Type.__doc__ = """The Type enum represents the parameter type

* ``String``: Parameter is a string
* ``Integer``: Parameter is an integer
* ``Double``: Parameter is a double
* ``Boolean``: Parameter is a boolean
* ``List``: Parameter is a (comma separated) list of strings, the handler will perform any further required conversion of the list values

"""
# --
QgsServerQueryStringParameter.Type.baseClass = QgsServerQueryStringParameter
try:
    QgsServerQueryStringParameter.typeName = staticmethod(QgsServerQueryStringParameter.typeName)
except (NameError, AttributeError):
    pass
# The following has been generated automatically from src/server/qgsserverrequest.h
QgsServerRequest.HeadMethod = QgsServerRequest.Method.HeadMethod
QgsServerRequest.PutMethod = QgsServerRequest.Method.PutMethod
QgsServerRequest.GetMethod = QgsServerRequest.Method.GetMethod
QgsServerRequest.PostMethod = QgsServerRequest.Method.PostMethod
QgsServerRequest.DeleteMethod = QgsServerRequest.Method.DeleteMethod
QgsServerRequest.PatchMethod = QgsServerRequest.Method.PatchMethod
QgsServerRequest.Method.baseClass = QgsServerRequest
QgsServerRequest.HOST = QgsServerRequest.RequestHeader.HOST
QgsServerRequest.FORWARDED = QgsServerRequest.RequestHeader.FORWARDED
QgsServerRequest.X_FORWARDED_FOR = QgsServerRequest.RequestHeader.X_FORWARDED_FOR
QgsServerRequest.X_FORWARDED_HOST = QgsServerRequest.RequestHeader.X_FORWARDED_HOST
QgsServerRequest.X_FORWARDED_PROTO = QgsServerRequest.RequestHeader.X_FORWARDED_PROTO
QgsServerRequest.X_QGIS_SERVICE_URL = QgsServerRequest.RequestHeader.X_QGIS_SERVICE_URL
QgsServerRequest.X_QGIS_WMS_SERVICE_URL = QgsServerRequest.RequestHeader.X_QGIS_WMS_SERVICE_URL
QgsServerRequest.X_QGIS_WFS_SERVICE_URL = QgsServerRequest.RequestHeader.X_QGIS_WFS_SERVICE_URL
QgsServerRequest.X_QGIS_WCS_SERVICE_URL = QgsServerRequest.RequestHeader.X_QGIS_WCS_SERVICE_URL
QgsServerRequest.X_QGIS_WMTS_SERVICE_URL = QgsServerRequest.RequestHeader.X_QGIS_WMTS_SERVICE_URL
QgsServerRequest.ACCEPT = QgsServerRequest.RequestHeader.ACCEPT
QgsServerRequest.USER_AGENT = QgsServerRequest.RequestHeader.USER_AGENT
QgsServerRequest.AUTHORIZATION = QgsServerRequest.RequestHeader.AUTHORIZATION
QgsServerRequest.RequestHeader.baseClass = QgsServerRequest
try:
    QgsServerRequest.methodToString = staticmethod(QgsServerRequest.methodToString)
except (NameError, AttributeError):
    pass
# The following has been generated automatically from src/server/qgsserversettings.h
QgsServerSettingsEnv.DEFAULT_VALUE = QgsServerSettingsEnv.Source.DEFAULT_VALUE
QgsServerSettingsEnv.ENVIRONMENT_VARIABLE = QgsServerSettingsEnv.Source.ENVIRONMENT_VARIABLE
QgsServerSettingsEnv.INI_FILE = QgsServerSettingsEnv.Source.INI_FILE
QgsServerSettingsEnv.Source.baseClass = QgsServerSettingsEnv
QgsServerSettingsEnv.QGIS_OPTIONS_PATH = QgsServerSettingsEnv.EnvVar.QGIS_OPTIONS_PATH
QgsServerSettingsEnv.QGIS_SERVER_PARALLEL_RENDERING = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_PARALLEL_RENDERING
QgsServerSettingsEnv.QGIS_SERVER_MAX_THREADS = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_MAX_THREADS
QgsServerSettingsEnv.QGIS_SERVER_LOG_LEVEL = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_LOG_LEVEL
QgsServerSettingsEnv.QGIS_SERVER_LOG_FILE = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_LOG_FILE
QgsServerSettingsEnv.QGIS_SERVER_LOG_STDERR = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_LOG_STDERR
QgsServerSettingsEnv.QGIS_PROJECT_FILE = QgsServerSettingsEnv.EnvVar.QGIS_PROJECT_FILE
QgsServerSettingsEnv.QGIS_SERVER_IGNORE_BAD_LAYERS = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_IGNORE_BAD_LAYERS
QgsServerSettingsEnv.QGIS_SERVER_CACHE_DIRECTORY = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_CACHE_DIRECTORY
QgsServerSettingsEnv.QGIS_SERVER_CACHE_SIZE = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_CACHE_SIZE
QgsServerSettingsEnv.QGIS_SERVER_SHOW_GROUP_SEPARATOR = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_SHOW_GROUP_SEPARATOR
QgsServerSettingsEnv.QGIS_SERVER_OVERRIDE_SYSTEM_LOCALE = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_OVERRIDE_SYSTEM_LOCALE
QgsServerSettingsEnv.QGIS_SERVER_WMS_MAX_HEIGHT = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_WMS_MAX_HEIGHT
QgsServerSettingsEnv.QGIS_SERVER_WMS_MAX_WIDTH = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_WMS_MAX_WIDTH
QgsServerSettingsEnv.QGIS_SERVER_API_RESOURCES_DIRECTORY = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_API_RESOURCES_DIRECTORY
QgsServerSettingsEnv.QGIS_SERVER_API_WFS3_MAX_LIMIT = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_API_WFS3_MAX_LIMIT
QgsServerSettingsEnv.QGIS_SERVER_TRUST_LAYER_METADATA = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_TRUST_LAYER_METADATA
QgsServerSettingsEnv.QGIS_SERVER_FORCE_READONLY_LAYERS = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_FORCE_READONLY_LAYERS
QgsServerSettingsEnv.QGIS_SERVER_DISABLE_GETPRINT = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_DISABLE_GETPRINT
QgsServerSettingsEnv.QGIS_SERVER_LANDING_PAGE_PROJECTS_DIRECTORIES = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_LANDING_PAGE_PROJECTS_DIRECTORIES
QgsServerSettingsEnv.QGIS_SERVER_LANDING_PAGE_PROJECTS_PG_CONNECTIONS = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_LANDING_PAGE_PROJECTS_PG_CONNECTIONS
QgsServerSettingsEnv.QGIS_SERVER_LOG_PROFILE = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_LOG_PROFILE
QgsServerSettingsEnv.QGIS_SERVER_SERVICE_URL = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_SERVICE_URL
QgsServerSettingsEnv.QGIS_SERVER_WMS_SERVICE_URL = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_WMS_SERVICE_URL
QgsServerSettingsEnv.QGIS_SERVER_WFS_SERVICE_URL = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_WFS_SERVICE_URL
QgsServerSettingsEnv.QGIS_SERVER_WCS_SERVICE_URL = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_WCS_SERVICE_URL
QgsServerSettingsEnv.QGIS_SERVER_WMTS_SERVICE_URL = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_WMTS_SERVICE_URL
QgsServerSettingsEnv.QGIS_SERVER_LANDING_PAGE_PREFIX = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_LANDING_PAGE_PREFIX
QgsServerSettingsEnv.QGIS_SERVER_PROJECT_CACHE_CHECK_INTERVAL = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_PROJECT_CACHE_CHECK_INTERVAL
QgsServerSettingsEnv.QGIS_SERVER_PROJECT_CACHE_STRATEGY = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_PROJECT_CACHE_STRATEGY
QgsServerSettingsEnv.QGIS_SERVER_ALLOWED_EXTRA_SQL_TOKENS = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_ALLOWED_EXTRA_SQL_TOKENS
QgsServerSettingsEnv.QGIS_SERVER_APPLICATION_NAME = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_APPLICATION_NAME
QgsServerSettingsEnv.QGIS_SERVER_CAPABILITIES_CACHE_SIZE = QgsServerSettingsEnv.EnvVar.QGIS_SERVER_CAPABILITIES_CACHE_SIZE
QgsServerSettingsEnv.EnvVar.baseClass = QgsServerSettingsEnv
try:
    QgsServerSettings.name = staticmethod(QgsServerSettings.name)
except (NameError, AttributeError):
    pass

