/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.headers.html;

import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.lang.Language;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.MarkdownIcons;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.model.psi.MarkdownSymbolInsideInjection;
import org.intellij.plugins.markdown.model.psi.MarkdownSymbolPresentationUtilsKt;
import org.intellij.plugins.markdown.model.psi.headers.MarkdownHeaderSymbol;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u00012B$\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010 \u001a\u00020\u0017H\u0016J\t\u0010'\u001a\u00020\u0006H\u00c6\u0003J\t\u0010(\u001a\u00020\bH\u00c6\u0003J\u000e\u0010)\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u00c6\u0003J,\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\r\b\u0002\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\nH\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0013R\u0014\u0010!\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00063"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/html/HtmlAnchorSymbol;", "Lorg/intellij/plugins/markdown/model/psi/headers/MarkdownHeaderSymbol;", "Lorg/intellij/plugins/markdown/model/psi/MarkdownSymbolInsideInjection;", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "Lcom/intellij/find/usages/api/SearchTarget;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "anchorText", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getAnchorText", "()Ljava/lang/String;", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "navigationRequest", "Lcom/intellij/platform/backend/navigation/NavigationRequest;", "maximalSearchScope", "Lcom/intellij/psi/search/SearchScope;", "getMaximalSearchScope", "()Lcom/intellij/psi/search/SearchScope;", "text", "getText", "presentation", "searchText", "getSearchText", "usageHandler", "Lcom/intellij/find/usages/api/UsageHandler;", "getUsageHandler", "()Lcom/intellij/find/usages/api/UsageHandler;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "intellij.markdown.model"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHtmlAnchorSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlAnchorSymbol.kt\norg/intellij/plugins/markdown/model/psi/headers/html/HtmlAnchorSymbol\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class HtmlAnchorSymbol
implements MarkdownHeaderSymbol,
MarkdownSymbolInsideInjection,
NavigationTarget,
SearchTarget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiFile file;
    @NotNull
    private final TextRange range;
    @NotNull
    private final String anchorText;

    public HtmlAnchorSymbol(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String anchorText) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)anchorText, (String)"anchorText");
        this.file = file;
        this.range = range;
        this.anchorText = anchorText;
        Language language = this.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (!MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) {
            boolean bl = false;
            String string = "Should be created only on host Markdown files. File was " + this.getFile() + ".";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public PsiFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public TextRange getRange() {
        return this.range;
    }

    @Override
    @NotNull
    public String getAnchorText() {
        return this.anchorText;
    }

    @NotNull
    public Pointer<? extends HtmlAnchorSymbol> createPointer() {
        return HtmlAnchorSymbol.Companion.createPointer(this.getFile(), this.getRange(), this.getAnchorText());
    }

    @NotNull
    public TargetPresentation computePresentation() {
        return this.presentation();
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        return NavigationRequest.Companion.sourceNavigationRequest(this.getFile(), this.getRange());
    }

    @NotNull
    public SearchScope getMaximalSearchScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getFile().getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return (SearchScope)globalSearchScope;
    }

    @Override
    @NotNull
    public String getText() {
        return this.getAnchorText();
    }

    @NotNull
    public TargetPresentation presentation() {
        TargetPresentationBuilder targetPresentationBuilder = TargetPresentation.Companion.builder("#" + this.getText()).icon(MarkdownIcons.EditorActions.Link);
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentationBuilder, (String)"icon(...)");
        TargetPresentationBuilder builder = targetPresentationBuilder;
        TargetPresentation targetPresentation = MarkdownSymbolPresentationUtilsKt.withLocationIn(builder, this.getFile()).containerText(MarkdownBundle.message("markdown.html.anchor.symbol.presentation.container.text", new Object[0])).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @Override
    @NotNull
    public String getSearchText() {
        return this.getAnchorText();
    }

    @NotNull
    public UsageHandler getUsageHandler() {
        UsageHandler usageHandler = UsageHandler.createEmptyUsageHandler((String)this.getAnchorText());
        Intrinsics.checkNotNullExpressionValue((Object)usageHandler, (String)"createEmptyUsageHandler(...)");
        return usageHandler;
    }

    @NotNull
    public final PsiFile component1() {
        return this.file;
    }

    @NotNull
    public final TextRange component2() {
        return this.range;
    }

    @NotNull
    public final String component3() {
        return this.anchorText;
    }

    @NotNull
    public final HtmlAnchorSymbol copy(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String anchorText) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)anchorText, (String)"anchorText");
        return new HtmlAnchorSymbol(file, range, anchorText);
    }

    public static /* synthetic */ HtmlAnchorSymbol copy$default(HtmlAnchorSymbol htmlAnchorSymbol, PsiFile psiFile, TextRange textRange, String string, int n, Object object) {
        if ((n & 1) != 0) {
            psiFile = htmlAnchorSymbol.file;
        }
        if ((n & 2) != 0) {
            textRange = htmlAnchorSymbol.range;
        }
        if ((n & 4) != 0) {
            string = htmlAnchorSymbol.anchorText;
        }
        return htmlAnchorSymbol.copy(psiFile, textRange, string);
    }

    @NotNull
    public String toString() {
        return "HtmlAnchorSymbol(file=" + this.file + ", range=" + this.range + ", anchorText=" + this.anchorText + ")";
    }

    public int hashCode() {
        int result = this.file.hashCode();
        result = result * 31 + this.range.hashCode();
        result = result * 31 + this.anchorText.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HtmlAnchorSymbol)) {
            return false;
        }
        HtmlAnchorSymbol htmlAnchorSymbol = (HtmlAnchorSymbol)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)htmlAnchorSymbol.file)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.range, (Object)htmlAnchorSymbol.range)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.anchorText, (Object)htmlAnchorSymbol.anchorText);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/html/HtmlAnchorSymbol$Companion;", "", "<init>", "()V", "createPointer", "Lcom/intellij/model/Pointer;", "Lorg/intellij/plugins/markdown/model/psi/headers/html/HtmlAnchorSymbol;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "anchorText", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.markdown.model"})
    public static final class Companion {
        private Companion() {
        }

        private final Pointer<HtmlAnchorSymbol> createPointer(PsiFile file, TextRange range, String anchorText) {
            Pointer pointer = Pointer.fileRangePointer((PsiFile)file, (TextRange)range, (arg_0, arg_1) -> Companion.createPointer$lambda$1((arg_0, arg_1) -> Companion.createPointer$lambda$0(anchorText, arg_0, arg_1), arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"fileRangePointer(...)");
            return pointer;
        }

        private static final HtmlAnchorSymbol createPointer$lambda$0(String $anchorText, PsiFile restoredFile, TextRange restoredRange) {
            Intrinsics.checkNotNullParameter((Object)restoredFile, (String)"restoredFile");
            Intrinsics.checkNotNullParameter((Object)restoredRange, (String)"restoredRange");
            return new HtmlAnchorSymbol(restoredFile, restoredRange, $anchorText);
        }

        private static final HtmlAnchorSymbol createPointer$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            return (HtmlAnchorSymbol)$tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

