/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.BaseInclusionModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerListener;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0001!B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0016J\u0016\u0010\u001e\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0016J\u0016\u0010\u001f\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lgit4idea/index/ui/GitStageRootInclusionModel;", "Lcom/intellij/openapi/vcs/changes/ui/BaseInclusionModel;", "project", "Lcom/intellij/openapi/project/Project;", "tracker", "Lgit4idea/index/GitStageTracker;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/index/GitStageTracker;Lcom/intellij/openapi/Disposable;)V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "stagedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "includedRoots", "", "getInclusion", "", "getInclusionState", "Lcom/intellij/util/ui/ThreeStateCheckBox$State;", "item", "isInclusionEmpty", "", "updateInclusion", "", "addInclusion", "items", "", "removeInclusion", "setInclusion", "retainInclusion", "clearInclusion", "Companion", "intellij.vcs.git"})
public final class GitStageRootInclusionModel
extends BaseInclusionModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitStageTracker tracker;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private Set<? extends VirtualFile> stagedRoots;
    @NotNull
    private final Set<VirtualFile> includedRoots;

    public GitStageRootInclusionModel(@NotNull Project project, @NotNull GitStageTracker tracker, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.tracker = tracker;
        this.lock = new ReentrantReadWriteLock();
        this.stagedRoots = SetsKt.emptySet();
        this.includedRoots = new LinkedHashSet();
        this.tracker.addListener(new GitStageTrackerListener(){

            @Override
            public void update() {
                this.updateInclusion();
            }
        }, disposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<Object> getInclusion() {
        List list;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)this.includedRoots);
        }
        finally {
            readLock.unlock();
        }
        List roots = list;
        return GitStageRootInclusionModel.Companion.asRepositories(roots, this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ThreeStateCheckBox.State getInclusionState(@NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!(item instanceof GitRepository)) {
            return ThreeStateCheckBox.State.NOT_SELECTED;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            boolean isIncluded = this.includedRoots.contains(((GitRepository)item).getRoot());
            ThreeStateCheckBox.State state2 = isIncluded ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED;
            return state2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInclusionEmpty() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.includedRoots.isEmpty();
            return bl2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateInclusion() {
        boolean wasChanged = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Set removedRoots = SetsKt.minus(this.stagedRoots, (Iterable)this.tracker.getState().getStagedRoots());
            Set addedRoots = SetsKt.minus(this.tracker.getState().getStagedRoots(), (Iterable)this.stagedRoots);
            this.stagedRoots = this.tracker.getState().getStagedRoots();
            this.includedRoots.removeAll(removedRoots);
            this.includedRoots.addAll(addedRoots);
            wasChanged = !((Collection)removedRoots).isEmpty() || !((Collection)addedRoots).isEmpty();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (wasChanged) {
            this.fireInclusionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.includedRoots.addAll(GitStageRootInclusionModel.Companion.asRoots(items));
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.fireInclusionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = VcsUtil.removeAllFromSet(this.includedRoots, (Collection)GitStageRootInclusionModel.Companion.asRoots(items));
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.fireInclusionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.includedRoots.clear();
            boolean bl2 = this.includedRoots.addAll(GitStageRootInclusionModel.Companion.asRoots(items));
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.fireInclusionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retainInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.includedRoots.retainAll(GitStageRootInclusionModel.Companion.asRoots(items));
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.fireInclusionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInclusion() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.includedRoots.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        this.fireInclusionChanged();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\bH\u0002J \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lgit4idea/index/ui/GitStageRootInclusionModel$Companion;", "", "<init>", "()V", "asRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "T", "", "asRepositories", "", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitStageRootInclusionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStageRootInclusionModel.kt\ngit4idea/index/ui/GitStageRootInclusionModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1611#2,9:121\n1863#2:130\n1864#2:132\n1620#2:133\n1619#2:134\n1863#2:135\n1864#2:137\n1620#2:138\n1#3:131\n1#3:136\n*S KotlinDebug\n*F\n+ 1 GitStageRootInclusionModel.kt\ngit4idea/index/ui/GitStageRootInclusionModel$Companion\n*L\n113#1:121,9\n113#1:130\n113#1:132\n113#1:133\n117#1:134\n117#1:135\n117#1:137\n117#1:138\n113#1:131\n117#1:136\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final <T> List<VirtualFile> asRoots(Collection<? extends T> $this$asRoots) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = $this$asRoots;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl2 = false;
                GitRepository gitRepository = it instanceof GitRepository ? (GitRepository)it : null;
                if ((gitRepository != null ? gitRepository.getRoot() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<GitRepository> asRepositories(Collection<? extends VirtualFile> $this$asRepositories, Project project) {
            void destination$iv;
            void $this$mapNotNullTo$iv;
            Iterable iterable = $this$asRepositories;
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                GitRepository it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl2 = false;
                if ((GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRootQuick(it) == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            return (Set)destination$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

