/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.community.ide.impl;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pycharm.community.ide.impl.PyIdeCommonOptionsPanel;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.PyCommonOptionsFormData;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIdeCommonOptionsForm
implements AbstractPyCommonOptionsForm {
    private final PyIdeCommonOptionsPanel content;
    private String mySelectedSdkHome = null;
    private Sdk mySelectedSdk = null;
    private JComponent labelAnchor;
    private final Project myProject;
    private List<Sdk> myPythonSdks;
    @NotNull
    private List<String> myEnvPaths = Collections.emptyList();
    private boolean myInterpreterRemote;
    private final List<Consumer<Boolean>> myRemoteInterpreterModeListeners = new ArrayList<Consumer<Boolean>>();

    public PyIdeCommonOptionsForm(PyCommonOptionsFormData data) {
        this.myProject = data.getProject();
        this.myPythonSdks = new ArrayList<Sdk>(PythonSdkUtil.getAllSdks());
        this.myPythonSdks.add(0, null);
        Module[] modules = ModuleManager.getInstance((Project)data.getProject()).getModules();
        boolean showModules = modules.length != 1;
        this.content = new PyIdeCommonOptionsPanel(data, showModules, this.myPythonSdks);
        this.content.workingDirectoryTextField.addBrowseFolderListener(data.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(PyBundle.message((String)"configurable.select.working.directory", (Object[])new Object[0])));
        if (!showModules) {
            this.setModule(modules[0]);
        } else {
            List validModules = data.getValidModules();
            Module selection = validModules.size() > 0 ? (Module)validModules.get(0) : null;
            this.content.moduleCombo.setModules((Collection)validModules);
            this.content.moduleCombo.setSelectedModule(selection);
            this.content.moduleCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PyIdeCommonOptionsForm.this.updateDefaultInterpreter(PyIdeCommonOptionsForm.this.content.moduleCombo.getSelectedModule());
                }
            });
            this.updateDefaultInterpreter(this.content.moduleCombo.getSelectedModule());
        }
        this.addInterpreterComboBoxActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PyIdeCommonOptionsForm.this.updateRemoteInterpreterMode();
            }
        });
        this.updateRemoteInterpreterMode();
        this.addInterpreterModeListener(b -> this.content.pathMappingsRow.visible(b.booleanValue()));
    }

    public JComponent getMainPanel() {
        return this.content.panel;
    }

    public void subscribe() {
        PyConfigurableInterpreterList myInterpreterList = PyConfigurableInterpreterList.getInstance((Project)this.myProject);
        ProjectSdksModel myProjectSdksModel = myInterpreterList.getModel();
        myProjectSdksModel.addListener((SdkModel.Listener)new MyListener(this, myInterpreterList));
        this.updateSdkList(true, myInterpreterList);
    }

    public JComponent getAnchor() {
        return this.labelAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.labelAnchor = anchor;
    }

    public String getInterpreterOptions() {
        return this.content.interpreterOptionsTextField.getText().trim();
    }

    public void setInterpreterOptions(String interpreterOptions) {
        this.content.interpreterOptionsTextField.setText(interpreterOptions);
    }

    public String getWorkingDirectory() {
        return FileUtil.toSystemIndependentName((String)this.content.workingDirectoryTextField.getText().trim());
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.content.workingDirectoryTextField.setText(workingDirectory == null ? "" : FileUtil.toSystemDependentName((String)workingDirectory));
    }

    public String getSdkHome() {
        Sdk selectedSdk = (Sdk)this.content.interpreterComboBox.getSelectedItem();
        return selectedSdk == null ? null : selectedSdk.getHomePath();
    }

    public void setSdkHome(String sdkHome) {
        this.mySelectedSdkHome = sdkHome;
    }

    @Nullable
    public Sdk getSdk() {
        return (Sdk)this.content.interpreterComboBox.getSelectedItem();
    }

    public void setSdk(@Nullable Sdk sdk2) {
        this.mySelectedSdk = sdk2;
    }

    @Nullable
    public Module getModule() {
        Module selectedItem = this.content.moduleCombo.getSelectedModule();
        if (selectedItem != null) {
            return selectedItem;
        }
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules.length == 1) {
            return modules[0];
        }
        return null;
    }

    public void setModule(Module module) {
        this.content.moduleCombo.setSelectedModule(module);
        this.updateDefaultInterpreter(module);
    }

    private void updateDefaultInterpreter(Module module) {
        Sdk sdk2 = module == null ? null : ModuleRootManager.getInstance((Module)module).getSdk();
        this.content.interpreterComboBox.setRenderer((ListCellRenderer<Sdk>)(sdk2 == null ? new PySdkListCellRenderer() : new PySdkListCellRenderer(PyBundle.message((String)"python.sdk.rendering.project.default.0", (Object[])new Object[]{sdk2.getName()}), sdk2)));
    }

    public void updateSdkList(boolean preserveSelection, PyConfigurableInterpreterList myInterpreterList) {
        Sdk selection;
        this.myPythonSdks = myInterpreterList.getAllPythonSdks(this.myProject, null);
        Sdk sdk2 = selection = preserveSelection ? (Sdk)this.content.interpreterComboBox.getSelectedItem() : null;
        if (!this.myPythonSdks.contains(selection)) {
            selection = null;
        }
        this.myPythonSdks.add(0, null);
        this.content.interpreterComboBox.setModel((ComboBoxModel<Sdk>)new CollectionComboBoxModel(this.myPythonSdks, (Object)selection));
    }

    public boolean isUseModuleSdk() {
        return this.content.interpreterComboBox.getSelectedItem() == null;
    }

    public void setUseModuleSdk(boolean useModuleSdk) {
        if (this.mySelectedSdk != null) {
            this.content.interpreterComboBox.setSelectedItem(useModuleSdk ? null : this.mySelectedSdk);
            return;
        }
        this.content.interpreterComboBox.setSelectedItem(useModuleSdk ? null : PythonSdkUtil.findSdkByPath(this.myPythonSdks, (String)this.mySelectedSdkHome));
    }

    public boolean isPassParentEnvs() {
        return this.content.envsComponent.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.content.envsComponent.setPassParentEnvs(passParentEnvs);
    }

    public Map<String, String> getEnvs() {
        return this.content.envsComponent.getEnvs();
    }

    public void setEnvs(Map<String, String> envs) {
        this.content.envsComponent.setEnvs(envs);
    }

    @Nullable
    public PathMappingSettings getMappingSettings() {
        if (this.myInterpreterRemote) {
            return this.content.pathMappingsComponent.getMappingSettings();
        }
        return new PathMappingSettings();
    }

    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.content.pathMappingsComponent.setMappingSettings(mappingSettings);
    }

    public boolean shouldAddContentRoots() {
        return this.content.addContentRootsCheckbox.isSelected();
    }

    public boolean shouldAddSourceRoots() {
        return this.content.addSourceRootsCheckbox.isSelected();
    }

    public void setAddContentRoots(boolean flag) {
        this.content.addContentRootsCheckbox.setSelected(flag);
    }

    public void setAddSourceRoots(boolean flag) {
        this.content.addSourceRootsCheckbox.setSelected(flag);
    }

    private void setRemoteInterpreterMode(boolean isInterpreterRemote) {
        this.myInterpreterRemote = isInterpreterRemote;
    }

    private void updateRemoteInterpreterMode() {
        this.setRemoteInterpreterMode(PythonSdkUtil.isRemote((Sdk)this.getSdkSelected()));
        for (Consumer<Boolean> f : this.myRemoteInterpreterModeListeners) {
            f.accept(this.myInterpreterRemote);
        }
    }

    @Nullable
    private Sdk getSdkSelected() {
        Sdk projectJdk;
        String sdkHome = this.getSdkHome();
        if (StringUtil.isEmptyOrSpaces((String)sdkHome) && (projectJdk = PythonSdkUtil.findPythonSdk((Module)this.getModule())) != null) {
            sdkHome = projectJdk.getHomePath();
        }
        return PythonSdkUtil.findSdkByPath((String)sdkHome);
    }

    public void addInterpreterComboBoxActionListener(ActionListener listener) {
        this.content.interpreterComboBox.addActionListener(listener);
    }

    public void removeInterpreterComboBoxActionListener(ActionListener listener) {
        this.content.interpreterComboBox.removeActionListener(listener);
    }

    @NotNull
    public List<String> getEnvFilePaths() {
        List<String> list = this.myEnvPaths;
        if (list == null) {
            PyIdeCommonOptionsForm.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setEnvFilePaths(@NotNull List<String> strings) {
        if (strings == null) {
            PyIdeCommonOptionsForm.$$$reportNull$$$0(1);
        }
        this.myEnvPaths = strings;
    }

    public String getModuleName() {
        Module module = this.getModule();
        return module != null ? module.getName() : null;
    }

    public void addInterpreterModeListener(Consumer<Boolean> listener) {
        this.myRemoteInterpreterModeListeners.add(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/pycharm/community/ide/impl/PyIdeCommonOptionsForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvFilePaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/pycharm/community/ide/impl/PyIdeCommonOptionsForm";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEnvFilePaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class MyListener
    implements SdkModel.Listener {
        private final PyIdeCommonOptionsForm myForm;
        private final PyConfigurableInterpreterList myInterpreterList;

        MyListener(PyIdeCommonOptionsForm form, PyConfigurableInterpreterList interpreterList) {
            this.myForm = form;
            this.myInterpreterList = interpreterList;
        }

        private void update() {
            this.myForm.updateSdkList(true, this.myInterpreterList);
        }

        public void sdkAdded(@NotNull Sdk sdk2) {
            if (sdk2 == null) {
                MyListener.$$$reportNull$$$0(0);
            }
            this.update();
        }

        public void beforeSdkRemove(@NotNull Sdk sdk2) {
            if (sdk2 == null) {
                MyListener.$$$reportNull$$$0(1);
            }
            this.update();
        }

        public void sdkChanged(@NotNull Sdk sdk2, String previousName) {
            if (sdk2 == null) {
                MyListener.$$$reportNull$$$0(2);
            }
            this.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "sdk";
            objectArray2[1] = "com/intellij/pycharm/community/ide/impl/PyIdeCommonOptionsForm$MyListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeSdkRemove";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

