/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.java.ExplodedDirectoryModuleExtension;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsAnnotationRootType;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaDependencyScope;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.java.JpsNativeLibraryRootType;
import org.jetbrains.jps.model.java.JpsProductionModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.JpsProductionModuleSourcePackagingElement;
import org.jetbrains.jps.model.java.JpsTestModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsRepositoryLibraryType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsPathMapper;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsCompilerValidationExcludeSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsEclipseCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerConfigurationSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerNotNullableSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerWorkspaceConfigurationSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsValidationSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.RmicCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryPropertiesSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryRootTypeSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;

public final class JpsJavaModelSerializerExtension
extends JpsModelSerializerExtension {
    private static final Logger LOG = Logger.getInstance(JpsJavaModelSerializerExtension.class);
    public static final String EXPORTED_ATTRIBUTE = "exported";
    public static final String SCOPE_ATTRIBUTE = "scope";
    public static final String OUTPUT_TAG = "output";
    public static final String URL_ATTRIBUTE = "url";
    public static final String LANGUAGE_LEVEL_ATTRIBUTE = "languageLevel";
    public static final String EXPLODED_TAG = "exploded";
    public static final String EXCLUDE_EXPLODED_TAG = "exclude-exploded";
    public static final String TEST_OUTPUT_TAG = "output-test";
    public static final String INHERIT_COMPILER_OUTPUT_ATTRIBUTE = "inherit-compiler-output";
    public static final String EXCLUDE_OUTPUT_TAG = "exclude-output";
    public static final String ANNOTATION_PATHS_TAG = "annotation-paths";
    public static final String JAVADOC_PATHS_TAG = "javadoc-paths";
    public static final String MODULE_LANGUAGE_LEVEL_ATTRIBUTE = "LANGUAGE_LEVEL";
    public static final String ROOT_TAG = "root";
    public static final String RELATIVE_OUTPUT_PATH_ATTRIBUTE = "relativeOutputPath";
    public static final String IS_GENERATED_ATTRIBUTE = "generated";
    public static final JavaSourceRootPropertiesSerializer JAVA_SOURCE_ROOT_PROPERTIES_SERIALIZER = new JavaSourceRootPropertiesSerializer(JavaSourceRootType.SOURCE, "java-source");
    public static final String JAVA_RESOURCE_ROOT_ID = "java-resource";
    public static final String JAVA_TEST_RESOURCE_ROOT_ID = "java-test-resource";
    public static final String PRODUCTION_MODULE_NAME_ATTRIBUTE = "production-module";

    @Override
    public void loadRootModel(@NotNull JpsModule module, @NotNull Element rootModel) {
        if (module == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(0);
        }
        if (rootModel == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(1);
        }
        JpsJavaModelSerializerExtension.loadExplodedDirectoryExtension(module, rootModel);
        JpsJavaModelSerializerExtension.loadJavaModuleExtension(module, rootModel);
    }

    @Override
    public void loadModuleOptions(@NotNull JpsModule module, @NotNull Element rootElement) {
        String productionModuleName;
        Element testModuleProperties;
        if (module == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(2);
        }
        if (rootElement == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(3);
        }
        if ((testModuleProperties = JDomSerializationUtil.findComponent(rootElement, "TestModuleProperties")) != null && (productionModuleName = testModuleProperties.getAttributeValue(PRODUCTION_MODULE_NAME_ATTRIBUTE)) != null) {
            JpsJavaModelSerializerExtension.getService().setTestModuleProperties(module, JpsElementFactory.getInstance().createModuleReference(productionModuleName));
        }
    }

    @Override
    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        List<JpsProjectExtensionSerializer> list = Arrays.asList(new JavaProjectExtensionSerializer(), new JpsJavaCompilerConfigurationSerializer(), new JpsValidationSerializer(), new JpsJavaCompilerNotNullableSerializer(), new JpsCompilerValidationExcludeSerializer(), new JpsJavaCompilerWorkspaceConfigurationSerializer(), new JpsJavaCompilerOptionsSerializer("JavacSettings", "Javac"), new JpsEclipseCompilerOptionsSerializer("EclipseCompilerSettings", "Eclipse"), new RmicCompilerOptionsSerializer("RmicSettings", "Rmic"));
        if (list == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends JpsModuleSourceRootPropertiesSerializer<?>> getModuleSourceRootPropertiesSerializers() {
        List<JpsModuleSourceRootPropertiesSerializer> list = Arrays.asList(JAVA_SOURCE_ROOT_PROPERTIES_SERIALIZER, new JavaSourceRootPropertiesSerializer(JavaSourceRootType.TEST_SOURCE, "java-test"), new JavaResourceRootPropertiesSerializer(JavaResourceRootType.RESOURCE, JAVA_RESOURCE_ROOT_ID), new JavaResourceRootPropertiesSerializer(JavaResourceRootType.TEST_RESOURCE, JAVA_TEST_RESOURCE_ROOT_ID));
        if (list == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public void loadModuleDependencyProperties(JpsDependencyElement dependency, Element entry) {
        JpsJavaDependencyScope scope;
        boolean exported = entry.getAttributeValue(EXPORTED_ATTRIBUTE) != null;
        String scopeName = entry.getAttributeValue(SCOPE_ATTRIBUTE);
        try {
            scope = scopeName != null ? JpsJavaDependencyScope.valueOf(scopeName) : JpsJavaDependencyScope.COMPILE;
        }
        catch (IllegalArgumentException e) {
            scope = JpsJavaDependencyScope.COMPILE;
        }
        JpsJavaDependencyExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateDependencyExtension(dependency);
        extension.setExported(exported);
        extension.setScope(scope);
    }

    @Override
    public List<JpsLibraryRootTypeSerializer> getLibraryRootTypeSerializers() {
        return Arrays.asList(new JpsLibraryRootTypeSerializer("JAVADOC", JpsOrderRootType.DOCUMENTATION, true), new JpsLibraryRootTypeSerializer("ANNOTATIONS", JpsAnnotationRootType.INSTANCE, false), new JpsLibraryRootTypeSerializer("NATIVE", JpsNativeLibraryRootType.INSTANCE, false));
    }

    @Override
    @NotNull
    public List<JpsLibraryRootTypeSerializer> getSdkRootTypeSerializers() {
        List<JpsLibraryRootTypeSerializer> list = Arrays.asList(new JpsLibraryRootTypeSerializer("javadocPath", JpsOrderRootType.DOCUMENTATION, true), new JpsLibraryRootTypeSerializer("annotationsPath", JpsAnnotationRootType.INSTANCE, true));
        if (list == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends JpsPackagingElementSerializer<?>> getPackagingElementSerializers() {
        List<JpsPackagingElementSerializer> list = Arrays.asList(new JpsModuleOutputPackagingElementSerializer(), new JpsTestModuleOutputPackagingElementSerializer(), new JpsModuleSourcePackagingElementSerializer());
        if (list == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public List<? extends JpsLibraryPropertiesSerializer<?>> getLibraryPropertiesSerializers() {
        List<JpsRepositoryLibraryPropertiesSerializer> list = Collections.singletonList(new JpsRepositoryLibraryPropertiesSerializer());
        if (list == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static void loadExplodedDirectoryExtension(JpsModule module, Element rootModelComponent) {
        Element exploded = rootModelComponent.getChild(EXPLODED_TAG);
        if (exploded != null) {
            ExplodedDirectoryModuleExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateExplodedDirectoryExtension(module);
            extension.setExcludeExploded(rootModelComponent.getChild(EXCLUDE_EXPLODED_TAG) != null);
            extension.setExplodedUrl(exploded.getAttributeValue(URL_ATTRIBUTE));
        }
    }

    private static void loadJavaModuleExtension(JpsModule module, Element rootModelComponent) {
        JpsJavaModuleExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateModuleExtension(module);
        Element outputTag = rootModelComponent.getChild(OUTPUT_TAG);
        String outputUrl = outputTag != null ? outputTag.getAttributeValue(URL_ATTRIBUTE) : null;
        extension.setOutputUrl(outputUrl);
        Element testOutputTag = rootModelComponent.getChild(TEST_OUTPUT_TAG);
        String testOutputUrl = testOutputTag != null ? testOutputTag.getAttributeValue(URL_ATTRIBUTE) : null;
        extension.setTestOutputUrl(StringUtil.isEmpty((String)testOutputUrl) ? outputUrl : testOutputUrl);
        extension.setInheritOutput(Boolean.parseBoolean(rootModelComponent.getAttributeValue(INHERIT_COMPILER_OUTPUT_ATTRIBUTE)));
        extension.setExcludeOutput(rootModelComponent.getChild(EXCLUDE_OUTPUT_TAG) != null);
        String languageLevel = rootModelComponent.getAttributeValue(MODULE_LANGUAGE_LEVEL_ATTRIBUTE);
        if (languageLevel != null) {
            extension.setLanguageLevel(JpsJavaModelSerializerExtension.readLanguageLevel(languageLevel, null));
        }
        JpsJavaModelSerializerExtension.loadAdditionalRoots(rootModelComponent, ANNOTATION_PATHS_TAG, extension.getAnnotationRoots());
        JpsJavaModelSerializerExtension.loadAdditionalRoots(rootModelComponent, JAVADOC_PATHS_TAG, extension.getJavadocRoots());
    }

    private static void loadAdditionalRoots(Element rootModelComponent, String rootsTagName, JpsUrlList result) {
        Element roots = rootModelComponent.getChild(rootsTagName);
        for (Element root : JDOMUtil.getChildren((Element)roots, (String)ROOT_TAG)) {
            result.addUrl(root.getAttributeValue(URL_ATTRIBUTE));
        }
    }

    private static JpsJavaExtensionService getService() {
        return JpsJavaExtensionService.getInstance();
    }

    private static LanguageLevel readLanguageLevel(String level, LanguageLevel defaultLevel) {
        for (LanguageLevel languageLevel : LanguageLevel.values()) {
            if (!level.equals(languageLevel.name())) continue;
            return languageLevel;
        }
        return defaultLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectExtensionSerializers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSourceRootPropertiesSerializers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRootTypeSerializers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagingElementSerializers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryPropertiesSerializers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadRootModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadModuleOptions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class JavaProjectExtensionSerializer
    extends JpsProjectExtensionSerializer {
        JavaProjectExtensionSerializer() {
            super(null, "ProjectRootManager");
        }

        @Override
        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            String languageLevel;
            String url;
            if (project == null) {
                JavaProjectExtensionSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                JavaProjectExtensionSerializer.$$$reportNull$$$0(1);
            }
            JpsJavaProjectExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateProjectExtension(project);
            Element output = componentTag.getChild(JpsJavaModelSerializerExtension.OUTPUT_TAG);
            if (output != null && (url = output.getAttributeValue(JpsJavaModelSerializerExtension.URL_ATTRIBUTE)) != null) {
                extension.setOutputUrl(url);
            }
            if ((languageLevel = componentTag.getAttributeValue(JpsJavaModelSerializerExtension.LANGUAGE_LEVEL_ATTRIBUTE)) != null) {
                extension.setLanguageLevel(JpsJavaModelSerializerExtension.readLanguageLevel(languageLevel, LanguageLevel.HIGHEST));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentTag";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaProjectExtensionSerializer";
            objectArray[2] = "loadExtension";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JavaSourceRootPropertiesSerializer
    extends JpsModuleSourceRootPropertiesSerializer<JavaSourceRootProperties> {
        private JavaSourceRootPropertiesSerializer(JpsModuleSourceRootType<JavaSourceRootProperties> type, String typeId) {
            super(type, typeId);
        }

        @Override
        public JavaSourceRootProperties loadProperties(@NotNull Element sourceRootTag) {
            if (sourceRootTag == null) {
                JavaSourceRootPropertiesSerializer.$$$reportNull$$$0(0);
            }
            String packagePrefix = StringUtil.notNullize((String)sourceRootTag.getAttributeValue("packagePrefix"));
            boolean isGenerated = Boolean.parseBoolean(sourceRootTag.getAttributeValue(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE));
            return JpsJavaModelSerializerExtension.getService().createSourceRootProperties(packagePrefix, isGenerated);
        }

        @Override
        public void saveProperties(@NotNull JavaSourceRootProperties properties, @NotNull Element sourceRootTag) {
            if (properties == null) {
                JavaSourceRootPropertiesSerializer.$$$reportNull$$$0(1);
            }
            if (sourceRootTag == null) {
                JavaSourceRootPropertiesSerializer.$$$reportNull$$$0(2);
            }
            String isTestSource = Boolean.toString(((JpsModuleSourceRootType)this.getType()).equals(JavaSourceRootType.TEST_SOURCE));
            sourceRootTag.setAttribute("isTestSource", isTestSource);
            String packagePrefix = properties.getPackagePrefix();
            if (!packagePrefix.isEmpty()) {
                sourceRootTag.setAttribute("packagePrefix", packagePrefix);
            }
            if (properties.isForGeneratedSources()) {
                sourceRootTag.setAttribute(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE, Boolean.TRUE.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRootTag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaSourceRootPropertiesSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadProperties";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveProperties";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JavaResourceRootPropertiesSerializer
    extends JpsModuleSourceRootPropertiesSerializer<JavaResourceRootProperties> {
        private JavaResourceRootPropertiesSerializer(JpsModuleSourceRootType<JavaResourceRootProperties> type, String typeId) {
            super(type, typeId);
        }

        @Override
        public JavaResourceRootProperties loadProperties(@NotNull Element sourceRootTag) {
            if (sourceRootTag == null) {
                JavaResourceRootPropertiesSerializer.$$$reportNull$$$0(0);
            }
            String relativeOutputPath = StringUtil.notNullize((String)sourceRootTag.getAttributeValue(JpsJavaModelSerializerExtension.RELATIVE_OUTPUT_PATH_ATTRIBUTE));
            boolean isGenerated = Boolean.parseBoolean(sourceRootTag.getAttributeValue(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE));
            return JpsJavaModelSerializerExtension.getService().createResourceRootProperties(relativeOutputPath, isGenerated);
        }

        @Override
        public void saveProperties(@NotNull JavaResourceRootProperties properties, @NotNull Element sourceRootTag) {
            String relativeOutputPath;
            if (properties == null) {
                JavaResourceRootPropertiesSerializer.$$$reportNull$$$0(1);
            }
            if (sourceRootTag == null) {
                JavaResourceRootPropertiesSerializer.$$$reportNull$$$0(2);
            }
            if (!(relativeOutputPath = properties.getRelativeOutputPath()).isEmpty()) {
                sourceRootTag.setAttribute(JpsJavaModelSerializerExtension.RELATIVE_OUTPUT_PATH_ATTRIBUTE, relativeOutputPath);
            }
            if (properties.isForGeneratedSources()) {
                sourceRootTag.setAttribute(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE, Boolean.TRUE.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRootTag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaResourceRootPropertiesSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadProperties";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveProperties";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JpsModuleOutputPackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsProductionModuleOutputPackagingElement> {
        private JpsModuleOutputPackagingElementSerializer() {
            super("module-output", JpsProductionModuleOutputPackagingElement.class);
        }

        @Override
        public JpsProductionModuleOutputPackagingElement load(Element element) {
            JpsModuleReference reference = JpsElementFactory.getInstance().createModuleReference(element.getAttributeValue("name"));
            return JpsJavaModelSerializerExtension.getService().createProductionModuleOutput(reference);
        }
    }

    private static final class JpsTestModuleOutputPackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsTestModuleOutputPackagingElement> {
        private JpsTestModuleOutputPackagingElementSerializer() {
            super("module-test-output", JpsTestModuleOutputPackagingElement.class);
        }

        @Override
        public JpsTestModuleOutputPackagingElement load(Element element) {
            JpsModuleReference reference = JpsElementFactory.getInstance().createModuleReference(element.getAttributeValue("name"));
            return JpsJavaModelSerializerExtension.getService().createTestModuleOutput(reference);
        }
    }

    private static final class JpsModuleSourcePackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsProductionModuleSourcePackagingElement> {
        private JpsModuleSourcePackagingElementSerializer() {
            super("module-source", JpsProductionModuleSourcePackagingElement.class);
        }

        @Override
        public JpsProductionModuleSourcePackagingElement load(Element element) {
            JpsModuleReference reference = JpsElementFactory.getInstance().createModuleReference(element.getAttributeValue("name"));
            return JpsJavaModelSerializerExtension.getService().createProductionModuleSource(reference);
        }
    }

    private static final class JpsRepositoryLibraryPropertiesSerializer
    extends JpsLibraryPropertiesSerializer<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>> {
        private static final String MAVEN_ID_ATTRIBUTE = "maven-id";
        private static final String INCLUDE_TRANSITIVE_DEPS_ATTRIBUTE = "include-transitive-deps";
        private static final String EXCLUDE_TAG = "exclude";
        private static final String DEPENDENCY_TAG = "dependency";
        private static final String JAR_REPOSITORY_ID_ATTRIBUTE = "jar-repository-id";
        private static final String VERIFICATION_TAG = "verification";
        private static final String ARTIFACT_TAG = "artifact";
        private static final String URL_ATTRIBUTE = "url";
        private static final String SHA256SUM_TAG = "sha256sum";

        JpsRepositoryLibraryPropertiesSerializer() {
            super(JpsRepositoryLibraryType.INSTANCE, JpsRepositoryLibraryType.INSTANCE.getTypeId());
        }

        @Override
        public JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor> loadProperties(@Nullable Element elem, @NotNull JpsPathMapper pathMapper) {
            if (pathMapper == null) {
                JpsRepositoryLibraryPropertiesSerializer.$$$reportNull$$$0(0);
            }
            return JpsElementFactory.getInstance().createSimpleElement(JpsRepositoryLibraryPropertiesSerializer.loadDescriptor(elem, pathMapper));
        }

        @NotNull
        private static JpsMavenRepositoryLibraryDescriptor loadDescriptor(@Nullable Element elem, @NotNull JpsPathMapper pathMapper) {
            if (pathMapper == null) {
                JpsRepositoryLibraryPropertiesSerializer.$$$reportNull$$$0(1);
            }
            if (elem == null) {
                return new JpsMavenRepositoryLibraryDescriptor(null);
            }
            String mavenId = elem.getAttributeValue(MAVEN_ID_ATTRIBUTE, (String)null);
            boolean includeTransitiveDependencies = Boolean.parseBoolean(elem.getAttributeValue(INCLUDE_TRANSITIVE_DEPS_ATTRIBUTE, "true"));
            String jarRepositoryId = elem.getAttributeValue(JAR_REPOSITORY_ID_ATTRIBUTE);
            Element excludeTag = elem.getChild(EXCLUDE_TAG);
            List dependencyTags = excludeTag != null ? excludeTag.getChildren(DEPENDENCY_TAG) : Collections.emptyList();
            List excludedDependencies = ContainerUtil.map((Collection)dependencyTags, it -> it.getAttributeValue(MAVEN_ID_ATTRIBUTE));
            List<JpsMavenRepositoryLibraryDescriptor.ArtifactVerification> verificationProperties = JpsRepositoryLibraryPropertiesSerializer.loadArtifactsVerificationProperties(mavenId, elem.getChild(VERIFICATION_TAG), pathMapper);
            return new JpsMavenRepositoryLibraryDescriptor(mavenId, includeTransitiveDependencies, excludedDependencies, verificationProperties, jarRepositoryId);
        }

        private static List<JpsMavenRepositoryLibraryDescriptor.ArtifactVerification> loadArtifactsVerificationProperties(@Nullable String mavenId, @Nullable Element element, @NotNull JpsPathMapper pathMapper) {
            if (pathMapper == null) {
                JpsRepositoryLibraryPropertiesSerializer.$$$reportNull$$$0(2);
            }
            if (element == null) {
                return Collections.emptyList();
            }
            List children = element.getChildren(ARTIFACT_TAG);
            ArrayList<JpsMavenRepositoryLibraryDescriptor.ArtifactVerification> result = new ArrayList<JpsMavenRepositoryLibraryDescriptor.ArtifactVerification>(children.size());
            for (Element child : children) {
                String artifactUrl = child.getAttributeValue("url");
                if (artifactUrl != null) {
                    String sha256sum;
                    Element sha256sumElement = child.getChild(SHA256SUM_TAG);
                    String string = sha256sum = sha256sumElement != null ? sha256sumElement.getText() : null;
                    if (sha256sum == null) {
                        LOG.warn("Missing sha256sum attribute for verification artifact tag for descriptor maven-id=" + mavenId);
                        continue;
                    }
                    result.add(new JpsMavenRepositoryLibraryDescriptor.ArtifactVerification(pathMapper.mapUrl(artifactUrl), sha256sum));
                    continue;
                }
                LOG.warn("Missing url attribute for verification artifact tag for descriptor maven-id=" + mavenId);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "pathMapper";
            objectArray2[1] = "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JpsRepositoryLibraryPropertiesSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadProperties";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadArtifactsVerificationProperties";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

