/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.smartstepinto;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoContext;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariant;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariantCallExpression;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariantComprehension;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariantOperator;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PySmartStepIntoVariantVisitor
extends PyRecursiveElementVisitor {
    @NotNull
    @NonNls
    private static final ImmutableSet<String> BUILTINS_MODULES = ImmutableSet.of((Object)"builtins.py", (Object)"__builtin__.py");
    int myVariantIndex;
    @NotNull
    private final List<PySmartStepIntoVariant> myCollector;
    @NotNull
    private final List<Pair<String, Boolean>> myVariantsFromPython;
    @NotNull
    private final PySmartStepIntoContext myContext;
    @NotNull
    private final Map<String, Integer> mySeenVariants;
    @NotNull
    private final Set<PsiElement> alreadyVisited;

    public PySmartStepIntoVariantVisitor(@NotNull List<PySmartStepIntoVariant> collector, @NotNull List<Pair<String, Boolean>> variantsFromPython, @NotNull PySmartStepIntoContext context) {
        if (collector == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(0);
        }
        if (variantsFromPython == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(2);
        }
        this.myVariantIndex = -1;
        this.mySeenVariants = Maps.newHashMap();
        this.alreadyVisited = new HashSet<PsiElement>();
        this.myCollector = collector;
        this.myVariantsFromPython = variantsFromPython;
        this.myContext = context;
    }

    @Override
    public void visitPyCallExpression(@NotNull PyCallExpression node) {
        PsiElement ref;
        if (node == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(3);
        }
        node.acceptChildren(this);
        if (this.alreadyVisited.contains(node)) {
            return;
        }
        this.alreadyVisited.add((PsiElement)node);
        if (this.myVariantIndex == this.myVariantsFromPython.size() - 1) {
            return;
        }
        PyExpression callee = node.getCallee();
        if (callee == null || callee.getName() == null) {
            return;
        }
        if (!callee.getName().equals(this.myVariantsFromPython.get((int)(this.myVariantIndex + 1)).first)) {
            return;
        }
        ++this.myVariantIndex;
        int callOrder = this.getCallOrder();
        this.mySeenVariants.put((String)this.myVariantsFromPython.get((int)this.myVariantIndex).first, ++callOrder);
        PsiElement psiElement = ref = callee.getReference() != null ? callee.getReference().resolve() : null;
        if (ref != null && PySmartStepIntoVariantVisitor.isBuiltIn(ref)) {
            return;
        }
        if (LanguageLevel.forElement((PsiElement)node).isOlderThan(LanguageLevel.PYTHON312) && ref instanceof PyFunction && (((PyFunction)ref).isAsync() || ((PyFunction)ref).isGenerator())) {
            return;
        }
        if (this.isAlreadyCalled()) {
            return;
        }
        this.myCollector.add(new PySmartStepIntoVariantCallExpression(node, callOrder, this.myContext));
    }

    @Override
    public void visitPyDecoratorList(@NotNull PyDecoratorList node) {
        PyDecorator[] decorators;
        if (node == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(4);
        }
        if ((decorators = node.getDecorators()).length > 0) {
            decorators[0].accept(this);
        }
    }

    @Override
    public void visitPyComprehensionElement(@NotNull PyComprehensionElement node) {
        if (node == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(5);
        }
        node.acceptChildren(this);
        if (this.alreadyVisited.contains(node)) {
            return;
        }
        this.alreadyVisited.add(node);
        if (this.myVariantIndex == this.myVariantsFromPython.size() - 1) {
            return;
        }
        if (!PySmartStepIntoVariantComprehension.isComprehensionName((String)this.myVariantsFromPython.get((int)(this.myVariantIndex + 1)).first)) {
            return;
        }
        ++this.myVariantIndex;
        int callOrder = this.getCallOrder();
        this.mySeenVariants.put((String)this.myVariantsFromPython.get((int)this.myVariantIndex).first, ++callOrder);
        if (this.isAlreadyCalled()) {
            return;
        }
        this.myCollector.add(new PySmartStepIntoVariantComprehension(node, callOrder, this.myContext));
    }

    @Override
    public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
        if (node == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(6);
        }
        node.getLeftExpression().accept(this);
        if (node.getRightExpression() != null) {
            node.getRightExpression().accept(this);
        }
        node.acceptChildren(this);
        if (this.alreadyVisited.contains(node)) {
            return;
        }
        this.alreadyVisited.add((PsiElement)node);
        if (this.myVariantIndex == this.myVariantsFromPython.size() - 1) {
            return;
        }
        PyElementType operator = node.getOperator();
        if (PyTokenTypes.OPERATIONS.contains((IElementType)operator)) {
            this.processOperator(operator, node);
        }
    }

    @Override
    public void visitPyPrefixExpression(@NotNull PyPrefixExpression node) {
        PyExpression operand;
        if (node == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(7);
        }
        if ((operand = node.getOperand()) != null) {
            operand.accept(this);
        }
        PyElementType operator = node.getOperator();
        this.processOperator(operator, node);
    }

    private void processOperator(PyElementType operator, PyReferenceOwner expression) {
        PyReferenceOwner psiOperator;
        String specialMethodName;
        boolean isBinaryOperator = expression instanceof PyBinaryExpression;
        String string = specialMethodName = isBinaryOperator ? operator.getSpecialMethodName() : PySmartStepIntoVariantOperator.getUnaryOperatorSpecialMethodName(operator);
        if (specialMethodName == null || !specialMethodName.equals(this.myVariantsFromPython.get((int)(this.myVariantIndex + 1)).first)) {
            return;
        }
        ++this.myVariantIndex;
        int callOrder = this.getCallOrder();
        this.mySeenVariants.put((String)this.myVariantsFromPython.get((int)this.myVariantIndex).first, ++callOrder);
        TypeEvalContext context = TypeEvalContext.userInitiated(expression.getProject(), expression.getContainingFile());
        PsiElement resolved = expression.getReference(PyResolveContext.defaultContext(context)).resolve();
        if (resolved == null || PySmartStepIntoVariantVisitor.isBuiltIn(resolved) || this.isAlreadyCalled()) {
            return;
        }
        PyReferenceOwner pyReferenceOwner = psiOperator = isBinaryOperator ? ((PyBinaryExpression)expression).getPsiOperator() : expression;
        if (psiOperator != null) {
            this.myCollector.add(new PySmartStepIntoVariantOperator((PsiElement)psiOperator, callOrder, this.myContext));
        }
    }

    private static boolean isBuiltIn(@NotNull PsiElement ref) {
        PsiFile navFile;
        if (ref == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(8);
        }
        return (navFile = ref.getNavigationElement().getContainingFile()) instanceof PyFile && BUILTINS_MODULES.contains((Object)navFile.getContainingFile().getName()) || navFile instanceof PyiFile;
    }

    private boolean isAlreadyCalled() {
        return (Boolean)this.myVariantsFromPython.get((int)this.myVariantIndex).second;
    }

    private int getCallOrder() {
        return this.mySeenVariants.getOrDefault(this.myVariantsFromPython.get((int)this.myVariantIndex).first, -1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantsFromPython";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/smartstepinto/PySmartStepIntoVariantVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyCallExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyDecoratorList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyComprehensionElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyBinaryExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyPrefixExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isBuiltIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

