/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.plugin.java.psi.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.NotNull;

public final class PyConstructorArgumentCompletionContributor
extends CompletionContributor
implements DumbAware {
    public PyConstructorArgumentCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParents(new Class[]{PyReferenceExpression.class, PyArgumentList.class, PyCallExpression.class}), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                PyCallExpression call;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getOriginalPosition(), PyCallExpression.class)) == null) {
                    return;
                }
                PyExpression calleeExpression = call.getCallee();
                if (calleeExpression instanceof PyReferenceExpression) {
                    PsiElement callee = ((PyReferenceExpression)calleeExpression).getReference().resolve();
                    if (callee instanceof PsiClass) {
                        PyConstructorArgumentCompletionContributor.addSettersAndListeners(result2, (PsiClass)callee, parameters.getOriginalFile());
                    } else if (callee instanceof PsiMethod && ((PsiMethod)callee).isConstructor()) {
                        PsiClass containingClass = ((PsiMethod)callee).getContainingClass();
                        assert (containingClass != null);
                        PyConstructorArgumentCompletionContributor.addSettersAndListeners(result2, containingClass, parameters.getOriginalFile());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/python/community/plugin/java/psi/impl/PyConstructorArgumentCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void addSettersAndListeners(CompletionResultSet result2, PsiClass containingClass, PsiFile origin) {
        for (PsiMethod method : containingClass.getAllMethods()) {
            PsiClass parameterClass;
            PsiType type2;
            PsiParameter[] parameters;
            Project project = containingClass.getProject();
            if (PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
                String propName = PropertyUtilBase.getPropertyName((PsiMethod)method);
                result2.addElement(PyUtil.createNamedParameterLookup(propName, origin));
                continue;
            }
            if (!method.getName().startsWith("add") || !method.getName().endsWith("Listener") || !PsiTypes.voidType().equals((Object)method.getReturnType()) || (parameters = method.getParameterList().getParameters()).length != 1 || !((type2 = parameters[0].getType()) instanceof PsiClassType) || (parameterClass = ((PsiClassType)type2).resolve()) == null) continue;
            result2.addElement(PyUtil.createNamedParameterLookup(StringUtil.decapitalize((String)StringUtil.notNullize((String)parameterClass.getName())), origin));
            for (PsiMethod parameterMethod : parameterClass.getMethods()) {
                result2.addElement(PyUtil.createNamedParameterLookup(parameterMethod.getName(), origin));
            }
        }
    }
}

