/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.actions.SimpleCodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.xml.XmlContentDFA;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GenerateXmlTagAction
extends SimpleCodeInsightAction {
    public static final ThreadLocal<String> TEST_THREAD_LOCAL = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance(GenerateXmlTagAction.class);

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project2 == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(2);
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        try {
            XmlTag contextTag = GenerateXmlTagAction.getContextTag(editor, file);
            if (contextTag == null) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException("Caret should be positioned inside a tag");
            }
            XmlElementDescriptor currentTagDescriptor = contextTag.getDescriptor();
            assert (currentTagDescriptor != null);
            Object[] descriptors = currentTagDescriptor.getElementsDescriptors(contextTag);
            Arrays.sort(descriptors, Comparator.comparing(PsiMetaData::getName));
            Consumer consumer = selected -> WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])new PsiFile[]{file}).withName(XmlBundle.message((String)"generate.xml.tag", (Object[])new Object[0])).run(() -> {
                if (selected == null) {
                    return;
                }
                XmlTag newTag = GenerateXmlTagAction.createTag(contextTag, selected);
                XmlTag anchor = GenerateXmlTagAction.getAnchor(contextTag, editor, selected);
                if (anchor == null) {
                    int offset = editor.getCaretModel().getOffset();
                    Document document = editor.getDocument();
                    document.insertString(offset, (CharSequence)newTag.getText());
                    PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
                    newTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset + 1), XmlTag.class, (boolean)false);
                } else {
                    newTag = (XmlTag)contextTag.addAfter((PsiElement)newTag, (PsiElement)anchor);
                }
                if (newTag != null) {
                    GenerateXmlTagAction.generateTag(newTag, editor);
                }
            });
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                XmlElementDescriptor descriptor = (XmlElementDescriptor)ContainerUtil.find((Object[])descriptors, xmlElementDescriptor -> xmlElementDescriptor.getName().equals(TEST_THREAD_LOCAL.get()));
                consumer.consume((Object)descriptor);
            } else {
                JBPopupFactory.getInstance().createPopupChooserBuilder(List.of(descriptors)).setRenderer((ListCellRenderer)new MyListCellRenderer()).setTitle(XmlBundle.message((String)"choose.tag.name", (Object[])new Object[0])).setItemChosenCallback(consumer).setNamerForFiltering(o -> o.getName()).createPopup().showInBestPositionFor(editor);
            }
        }
        catch (CommonRefactoringUtil.RefactoringErrorHintException e) {
            HintManager.getInstance().showErrorHint(editor, e.getMessage());
        }
    }

    @Nullable
    private static XmlTag getAnchor(@NotNull XmlTag contextTag, Editor editor, XmlElementDescriptor selected) {
        if (contextTag == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(3);
        }
        XmlContentDFA contentDFA = XmlContentDFA.getContentDFA(contextTag);
        int offset = editor.getCaretModel().getOffset();
        if (contentDFA == null) {
            return null;
        }
        XmlTag anchor = null;
        boolean previousPositionIsPossible = true;
        for (XmlTag subTag : contextTag.getSubTags()) {
            if (contentDFA.getPossibleElements().contains(selected)) {
                if (subTag.getTextOffset() > offset) break;
                anchor = subTag;
                previousPositionIsPossible = true;
            } else {
                previousPositionIsPossible = false;
            }
            contentDFA.transition(subTag);
        }
        return previousPositionIsPossible ? null : anchor;
    }

    public static void generateTag(@NotNull XmlTag newTag, Editor editor) {
        if (newTag == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(4);
        }
        GenerateXmlTagAction.generateRaw(newTag);
        XmlTag restored = (XmlTag)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)newTag);
        if (restored == null) {
            LOG.error("Could not restore tag: " + newTag.getText());
        }
        TemplateBuilder builder2 = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)restored);
        GenerateXmlTagAction.replaceElements(restored, builder2);
        builder2.run(editor, false);
    }

    private static void generateRaw(@NotNull XmlTag newTag) {
        XmlElementDescriptor selected;
        if (newTag == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(5);
        }
        if ((selected = newTag.getDescriptor()) == null) {
            return;
        }
        switch (selected.getContentType()) {
            case 0: {
                newTag.collapseIfEmpty();
                ASTNode node = newTag.getNode();
                assert (node != null);
                ASTNode elementEnd = node.findChildByType(XmlTokenType.XML_EMPTY_ELEMENT_END);
                if (elementEnd != null) break;
                LeafElement emptyTagEnd = Factory.createSingleLeafElement((IElementType)XmlTokenType.XML_EMPTY_ELEMENT_END, (CharSequence)"/>", (int)0, (int)2, null, (PsiManager)newTag.getManager());
                node.addChild((ASTNode)emptyTagEnd);
                break;
            }
            case 3: {
                newTag.getValue().setText("");
            }
        }
        for (ASTNode descriptor : selected.getAttributesDescriptors(newTag)) {
            if (!descriptor.isRequired()) continue;
            newTag.setAttribute(descriptor.getName(), "");
        }
        List<XmlElementDescriptor> tags = GenerateXmlTagAction.getRequiredSubTags(selected);
        for (XmlElementDescriptor descriptor : tags) {
            if (descriptor == null) {
                XmlTag tag = XmlElementFactory.getInstance((Project)newTag.getProject()).createTagFromText((CharSequence)"<", newTag.getLanguage());
                newTag.addSubTag(tag, false);
                continue;
            }
            XmlTag subTag = newTag.addSubTag(GenerateXmlTagAction.createTag(newTag, descriptor), false);
            GenerateXmlTagAction.generateRaw(subTag);
        }
    }

    public static List<XmlElementDescriptor> getRequiredSubTags(XmlElementDescriptor selected) {
        XmlElementsGroup topGroup = selected.getTopGroup();
        if (topGroup == null) {
            return Collections.emptyList();
        }
        return GenerateXmlTagAction.computeRequiredSubTags(topGroup);
    }

    private static void replaceElements(XmlTag tag, TemplateBuilder builder2) {
        int i;
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            XmlAttributeValue value = xmlAttribute.getValueElement();
            if (value == null) continue;
            builder2.replaceElement((PsiElement)value, TextRange.from((int)1, (int)0), (Expression)new MacroCallNode((Macro)new CompleteMacro()));
        }
        if ("<".equals(tag.getText())) {
            builder2.replaceElement((PsiElement)tag, TextRange.from((int)1, (int)0), (Expression)new MacroCallNode((Macro)new CompleteSmartMacro()));
        } else if (tag.getSubTags().length == 0 && (i = tag.getText().indexOf("></")) > 0) {
            builder2.replaceElement((PsiElement)tag, TextRange.from((int)(i + 1), (int)0), (Expression)new MacroCallNode((Macro)new CompleteMacro()));
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            GenerateXmlTagAction.replaceElements((XmlTag)xmlAttribute, builder2);
        }
    }

    private static XmlTag createTag(@NotNull XmlTag contextTag, @NotNull XmlElementDescriptor descriptor) {
        if (contextTag == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(7);
        }
        String namespace = GenerateXmlTagAction.getNamespace(descriptor);
        XmlTag tag = contextTag.createChildTag(descriptor.getName(), namespace, null, false);
        PsiElement lastChild = tag.getLastChild();
        assert (lastChild != null);
        lastChild.delete();
        return tag;
    }

    @NlsSafe
    private static String getNamespace(XmlElementDescriptor descriptor) {
        return descriptor instanceof XmlElementDescriptorImpl ? ((XmlElementDescriptorImpl)descriptor).getNamespace() : "";
    }

    @Nullable
    private static XmlTag getContextTag(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        XmlTag tag = null;
        if (element != null) {
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        }
        if (tag == null) {
            tag = ((XmlFile)file).getRootTag();
        }
        return tag;
    }

    private static List<XmlElementDescriptor> computeRequiredSubTags(XmlElementsGroup group) {
        if (group.getMinOccurs() < 1) {
            return Collections.emptyList();
        }
        switch (group.getGroupType()) {
            case LEAF: {
                XmlTag tag;
                String abstractValue;
                XmlElementDescriptor descriptor = group.getLeafDescriptor();
                if (descriptor == null) {
                    return Collections.emptyList();
                }
                PsiElement declaration = descriptor.getDeclaration();
                if (declaration instanceof XmlTag && "true".equals(abstractValue = (tag = (XmlTag)descriptor.getDeclaration()).getAttributeValue("abstract", "http://www.w3.org/2001/XMLSchema"))) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(descriptor);
            }
            case CHOICE: {
                LinkedHashSet<XmlElementDescriptor> set = null;
                for (XmlElementsGroup subGroup : group.getSubGroups()) {
                    List<XmlElementDescriptor> descriptors = GenerateXmlTagAction.computeRequiredSubTags(subGroup);
                    if (set == null) {
                        set = new LinkedHashSet<XmlElementDescriptor>(descriptors);
                        continue;
                    }
                    set.retainAll(descriptors);
                }
                if (set == null || set.isEmpty()) {
                    return Collections.singletonList(null);
                }
                return new ArrayList<XmlElementDescriptor>(set);
            }
        }
        ArrayList<XmlElementDescriptor> list2 = new ArrayList<XmlElementDescriptor>();
        for (XmlElementsGroup subGroup : group.getSubGroups()) {
            list2.addAll(GenerateXmlTagAction.computeRequiredSubTags(subGroup));
        }
        return list2;
    }

    private static boolean isInsideTagBody(XmlTag contextTag, @NotNull Editor editor) {
        if (editor == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(8);
        }
        return contextTag.getValue().getTextRange().contains(editor.getCaretModel().getOffset());
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project2 == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(10);
        }
        if (file == null) {
            GenerateXmlTagAction.$$$reportNull$$$0(11);
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        XmlTag contextTag = GenerateXmlTagAction.getContextTag(editor, file);
        return contextTag != null && GenerateXmlTagAction.isInsideTagBody(contextTag, editor) && contextTag.getDescriptor() != null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextTag";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/actions/GenerateXmlTagAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnchor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "generateTag";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "generateRaw";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createTag";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideTagBody";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidForFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyListCellRenderer
    implements ListCellRenderer<XmlElementDescriptor> {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myNameLabel;
        private final JLabel myNSLabel;

        MyListCellRenderer() {
            this.myPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.myNameLabel = new JLabel();
            this.myPanel.add((Component)this.myNameLabel, "West");
            this.myPanel.add(new JLabel("     "));
            this.myNSLabel = new JLabel();
            this.myPanel.add((Component)this.myNSLabel, "East");
            Font font = EditorFontType.getGlobalPlainFont();
            this.myNameLabel.setFont(font);
            this.myNSLabel.setFont(font);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends XmlElementDescriptor> list2, XmlElementDescriptor value, int index, boolean isSelected, boolean cellHasFocus) {
            Color backgroundColor = isSelected ? list2.getSelectionBackground() : list2.getBackground();
            this.myNameLabel.setText(value.getName());
            this.myNameLabel.setForeground(isSelected ? list2.getSelectionForeground() : list2.getForeground());
            this.myPanel.setBackground(backgroundColor);
            this.myNSLabel.setText(GenerateXmlTagAction.getNamespace(value));
            this.myNSLabel.setForeground(LookupCellRenderer.getGrayedForeground((boolean)isSelected));
            this.myNSLabel.setBackground(backgroundColor);
            return this.myPanel;
        }
    }
}

