/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.models.local;

import com.intellij.internal.ml.ModelMetadataReader;
import com.intellij.internal.ml.catboost.NaiveCatBoostModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/ml/models/local/LocalCatBoostModelMetadataReader;", "Lcom/intellij/internal/ml/ModelMetadataReader;", "modelDirectory", "", "featuresDirectory", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "binaryFeatures", "floatFeatures", "categoricalFeatures", "allKnown", "featureOrderDirect", "", "extractVersion", "loadModel", "Lcom/intellij/internal/ml/catboost/NaiveCatBoostModel;", "readFeaturesFile", "filename", "intellij.platform.ml.impl"})
@ApiStatus.Internal
public final class LocalCatBoostModelMetadataReader
implements ModelMetadataReader {
    @NotNull
    private final String modelDirectory;
    @NotNull
    private final String featuresDirectory;

    public LocalCatBoostModelMetadataReader(@NotNull String modelDirectory, @NotNull String featuresDirectory) {
        Intrinsics.checkNotNullParameter((Object)modelDirectory, (String)"modelDirectory");
        Intrinsics.checkNotNullParameter((Object)featuresDirectory, (String)"featuresDirectory");
        this.modelDirectory = modelDirectory;
        this.featuresDirectory = featuresDirectory;
    }

    @NotNull
    public String binaryFeatures() {
        return this.readFeaturesFile("binary.json");
    }

    @NotNull
    public String floatFeatures() {
        return this.readFeaturesFile("float.json");
    }

    @NotNull
    public String categoricalFeatures() {
        return this.readFeaturesFile("categorical.json");
    }

    @NotNull
    public String allKnown() {
        return this.readFeaturesFile("all_features.json");
    }

    @NotNull
    public List<String> featureOrderDirect() {
        return StringsKt.lines((CharSequence)this.readFeaturesFile("features_order.txt"));
    }

    @Nullable
    public String extractVersion() {
        return null;
    }

    @NotNull
    public final NaiveCatBoostModel loadModel() {
        FileInputStream modelInputStream = new FileInputStream(new File(this.modelDirectory + "/model.bin"));
        NaiveCatBoostModel naiveCatBoostModel = NaiveCatBoostModel.loadModel((InputStream)modelInputStream);
        Intrinsics.checkNotNullExpressionValue((Object)naiveCatBoostModel, (String)"loadModel(...)");
        return naiveCatBoostModel;
    }

    private final String readFeaturesFile(String filename) {
        File absolutePathToFile = new File(this.modelDirectory + "/" + this.featuresDirectory + "/" + filename);
        return FilesKt.readText$default((File)absolutePathToFile, null, (int)1, null);
    }
}

