/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * determinant(dmat3(-1.11lf, 0.13lf, 0.56lf, 1.67lf, 1.09lf, 0.95lf, -0.41lf, -0.02lf, 0.24lf)) => -0.18264500000000009lf
 * determinant(dmat3(-1.69lf, -1.09lf, -1.53lf, -0.46lf, 1.75lf, -0.7lf, -0.18lf, 2.0lf, -1.47lf)) => 3.506892999999999lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(determinant(dmat3(-1.11lf, 0.13lf, 0.56lf, 1.67lf, 1.09lf, 0.95lf, -0.41lf, -0.02lf, 0.24lf)), -0.18264500000000009lf) <= 1.826450000000001e-06lf ? 1 : -1] array0;
  double[distance(determinant(dmat3(-1.69lf, -1.09lf, -1.53lf, -0.46lf, 1.75lf, -0.7lf, -0.18lf, 2.0lf, -1.47lf)), 3.506892999999999lf) <= 3.5068929999999994e-05lf ? 1 : -1] array1;
  gl_FragColor = vec4(array0.length() + array1.length());
}
