/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIMatrix4x4;
import org.lwjgl.assimp.AIMetaData;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiNode")
public class AINode
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MTRANSFORMATION;
    public static final int MPARENT;
    public static final int MNUMCHILDREN;
    public static final int MCHILDREN;
    public static final int MNUMMESHES;
    public static final int MMESHES;
    public static final int MMETADATA;

    public AINode(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AINode.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AINode.nmName(this.address());
    }

    @NativeType(value="struct aiMatrix4x4")
    public AIMatrix4x4 mTransformation() {
        return AINode.nmTransformation(this.address());
    }

    @Nullable
    @NativeType(value="struct aiNode *")
    public AINode mParent() {
        return AINode.nmParent(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumChildren() {
        return AINode.nmNumChildren(this.address());
    }

    @Nullable
    @NativeType(value="struct aiNode **")
    public PointerBuffer mChildren() {
        return AINode.nmChildren(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumMeshes() {
        return AINode.nmNumMeshes(this.address());
    }

    @Nullable
    @NativeType(value="unsigned int *")
    public IntBuffer mMeshes() {
        return AINode.nmMeshes(this.address());
    }

    @Nullable
    @NativeType(value="struct aiMetadata *")
    public AIMetaData mMetadata() {
        return AINode.nmMetadata(this.address());
    }

    public AINode mName(@NativeType(value="struct aiString") AIString value) {
        AINode.nmName(this.address(), value);
        return this;
    }

    public AINode mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AINode mTransformation(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
        AINode.nmTransformation(this.address(), value);
        return this;
    }

    public AINode mTransformation(Consumer<AIMatrix4x4> consumer) {
        consumer.accept(this.mTransformation());
        return this;
    }

    public AINode mParent(@Nullable @NativeType(value="struct aiNode *") AINode value) {
        AINode.nmParent(this.address(), value);
        return this;
    }

    public AINode mChildren(@Nullable @NativeType(value="struct aiNode **") PointerBuffer value) {
        AINode.nmChildren(this.address(), value);
        return this;
    }

    public AINode mMeshes(@Nullable @NativeType(value="unsigned int *") IntBuffer value) {
        AINode.nmMeshes(this.address(), value);
        return this;
    }

    public AINode mMetadata(@Nullable @NativeType(value="struct aiMetadata *") AIMetaData value) {
        AINode.nmMetadata(this.address(), value);
        return this;
    }

    public AINode set(AIString mName, AIMatrix4x4 mTransformation, @Nullable AINode mParent, @Nullable PointerBuffer mChildren, @Nullable IntBuffer mMeshes, @Nullable AIMetaData mMetadata) {
        this.mName(mName);
        this.mTransformation(mTransformation);
        this.mParent(mParent);
        this.mChildren(mChildren);
        this.mMeshes(mMeshes);
        this.mMetadata(mMetadata);
        return this;
    }

    public AINode set(AINode src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AINode malloc() {
        return (AINode)AINode.wrap(AINode.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AINode calloc() {
        return (AINode)AINode.wrap(AINode.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AINode create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AINode)AINode.wrap(AINode.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AINode create(long address) {
        return (AINode)AINode.wrap(AINode.class, (long)address);
    }

    @Nullable
    public static AINode createSafe(long address) {
        return address == 0L ? null : (AINode)AINode.wrap(AINode.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AINode.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AINode.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AINode.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AINode.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AINode.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AINode.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AINode.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static AINode mallocStack() {
        return AINode.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AINode callocStack() {
        return AINode.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AINode mallocStack(MemoryStack stack) {
        return AINode.malloc(stack);
    }

    @Deprecated
    public static AINode callocStack(MemoryStack stack) {
        return AINode.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AINode.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AINode.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AINode.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AINode.calloc(capacity, stack);
    }

    public static AINode malloc(MemoryStack stack) {
        return (AINode)AINode.wrap(AINode.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AINode calloc(MemoryStack stack) {
        return (AINode)AINode.wrap(AINode.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)AINode.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)AINode.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static AIMatrix4x4 nmTransformation(long struct) {
        return AIMatrix4x4.create(struct + (long)MTRANSFORMATION);
    }

    @Nullable
    public static AINode nmParent(long struct) {
        return AINode.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MPARENT)));
    }

    public static int nmNumChildren(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMCHILDREN);
    }

    @Nullable
    public static PointerBuffer nmChildren(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)MCHILDREN)), (int)AINode.nmNumChildren(struct));
    }

    public static int nmNumMeshes(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMMESHES);
    }

    @Nullable
    public static IntBuffer nmMeshes(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)MMESHES)), (int)AINode.nmNumMeshes(struct));
    }

    @Nullable
    public static AIMetaData nmMetadata(long struct) {
        return AIMetaData.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MMETADATA)));
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (long)AIString.SIZEOF);
    }

    public static void nmTransformation(long struct, AIMatrix4x4 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MTRANSFORMATION), (long)AIMatrix4x4.SIZEOF);
    }

    public static void nmParent(long struct, @Nullable AINode value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MPARENT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmNumChildren(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMCHILDREN, value);
    }

    public static void nmChildren(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MCHILDREN), (long)MemoryUtil.memAddressSafe((Pointer)value));
        AINode.nmNumChildren(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumMeshes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMMESHES, value);
    }

    public static void nmMeshes(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MMESHES), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        AINode.nmNumMeshes(struct, value == null ? 0 : value.remaining());
    }

    public static void nmMetadata(long struct, @Nullable AIMetaData value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MMETADATA), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        long mMetadata;
        if (AINode.nmNumChildren(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MCHILDREN)));
        }
        if (AINode.nmNumMeshes(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MMESHES)));
        }
        if ((mMetadata = MemoryUtil.memGetAddress((long)(struct + (long)MMETADATA))) != 0L) {
            AIMetaData.validate(mMetadata);
        }
    }

    static {
        Struct.Layout layout = AINode.__struct((Struct.Member[])new Struct.Member[]{AINode.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AINode.__member((int)AIMatrix4x4.SIZEOF, (int)AIMatrix4x4.ALIGNOF), AINode.__member((int)POINTER_SIZE), AINode.__member((int)4), AINode.__member((int)POINTER_SIZE), AINode.__member((int)4), AINode.__member((int)POINTER_SIZE), AINode.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MTRANSFORMATION = layout.offsetof(1);
        MPARENT = layout.offsetof(2);
        MNUMCHILDREN = layout.offsetof(3);
        MCHILDREN = layout.offsetof(4);
        MNUMMESHES = layout.offsetof(5);
        MMESHES = layout.offsetof(6);
        MMETADATA = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<AINode, Buffer>
    implements NativeResource {
        private static final AINode ELEMENT_FACTORY = AINode.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AINode getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AINode.nmName(this.address());
        }

        @NativeType(value="struct aiMatrix4x4")
        public AIMatrix4x4 mTransformation() {
            return AINode.nmTransformation(this.address());
        }

        @Nullable
        @NativeType(value="struct aiNode *")
        public AINode mParent() {
            return AINode.nmParent(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumChildren() {
            return AINode.nmNumChildren(this.address());
        }

        @Nullable
        @NativeType(value="struct aiNode **")
        public PointerBuffer mChildren() {
            return AINode.nmChildren(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumMeshes() {
            return AINode.nmNumMeshes(this.address());
        }

        @Nullable
        @NativeType(value="unsigned int *")
        public IntBuffer mMeshes() {
            return AINode.nmMeshes(this.address());
        }

        @Nullable
        @NativeType(value="struct aiMetadata *")
        public AIMetaData mMetadata() {
            return AINode.nmMetadata(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AINode.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mTransformation(@NativeType(value="struct aiMatrix4x4") AIMatrix4x4 value) {
            AINode.nmTransformation(this.address(), value);
            return this;
        }

        public Buffer mTransformation(Consumer<AIMatrix4x4> consumer) {
            consumer.accept(this.mTransformation());
            return this;
        }

        public Buffer mParent(@Nullable @NativeType(value="struct aiNode *") AINode value) {
            AINode.nmParent(this.address(), value);
            return this;
        }

        public Buffer mChildren(@Nullable @NativeType(value="struct aiNode **") PointerBuffer value) {
            AINode.nmChildren(this.address(), value);
            return this;
        }

        public Buffer mMeshes(@Nullable @NativeType(value="unsigned int *") IntBuffer value) {
            AINode.nmMeshes(this.address(), value);
            return this;
        }

        public Buffer mMetadata(@Nullable @NativeType(value="struct aiMetadata *") AIMetaData value) {
            AINode.nmMetadata(this.address(), value);
            return this;
        }
    }
}

