/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import lucee.loader.TP;
import lucee.loader.engine.CFMLEngineFactory;
import org.osgi.framework.Version;

public abstract class CFMLEngineFactorySupport {
    private static File tempFile;
    private static File homeFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[65535];
        try {
            int len;
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            CFMLEngineFactorySupport.closeEL(in);
            CFMLEngineFactorySupport.closeEL(out);
        }
    }

    public static final void closeEL(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final void closeEL(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String toString(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer content = new StringBuffer();
        String line = br.readLine();
        if (line != null) {
            content.append(line);
            while ((line = br.readLine()) != null) {
                content.append("\n" + line);
            }
        }
        br.close();
        return content.toString();
    }

    public static Version toVersion(String version, Version defaultValue) {
        int rIndex = version.lastIndexOf(".lco");
        if (rIndex != -1) {
            version = version.substring(0, rIndex);
        }
        try {
            return Version.parseVersion(version);
        }
        catch (IllegalArgumentException iae) {
            return defaultValue;
        }
    }

    public static String removeQuotes(String str, boolean trim) {
        if (str == null) {
            return str;
        }
        if (trim) {
            str = str.trim();
        }
        if (str.length() < 2) {
            return str;
        }
        char first = str.charAt(0);
        char last = str.charAt(str.length() - 1);
        if ((first == '\"' || first == '\'') && first == last) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static String parsePlaceHolder(String path) {
        if (path == null) {
            return path;
        }
        if (path.startsWith("{temp")) {
            if (path.startsWith("}", 5)) {
                path = new File(CFMLEngineFactorySupport.getTempDirectory(), path.substring(6)).toString();
            } else if (path.startsWith("-dir}", 5)) {
                path = new File(CFMLEngineFactorySupport.getTempDirectory(), path.substring(10)).toString();
            } else if (path.startsWith("-directory}", 5)) {
                path = new File(CFMLEngineFactorySupport.getTempDirectory(), path.substring(16)).toString();
            }
        } else if (path.startsWith("{system")) {
            if (path.charAt(7) == ':') {
                String name;
                String prop;
                int end = path.indexOf(125, 8);
                if (end > 8 && (prop = System.getProperty(name = path.substring(8, end))) != null) {
                    return new File(new File(prop), path.substring(end + 1)).getAbsolutePath();
                }
            } else if (path.startsWith("}", 7)) {
                path = new File(CFMLEngineFactorySupport.getSystemDirectory(), path.substring(8)).toString();
            } else if (path.startsWith("-dir}", 7)) {
                path = new File(CFMLEngineFactorySupport.getSystemDirectory(), path.substring(12)).toString();
            } else if (path.startsWith("-directory}", 7)) {
                path = new File(CFMLEngineFactorySupport.getSystemDirectory(), path.substring(18)).toString();
            }
        } else if (path.startsWith("{env:")) {
            String name;
            String env;
            int end = path.indexOf(125, 5);
            if (end > 5 && (env = System.getenv(name = path.substring(5, end))) != null) {
                return new File(new File(env), path.substring(end + 1)).getAbsolutePath();
            }
        } else if (path.startsWith("{home")) {
            if (path.startsWith("}", 5)) {
                path = new File(CFMLEngineFactorySupport.getHomeDirectory(), path.substring(6)).toString();
            } else if (path.startsWith("-dir}", 5)) {
                path = new File(CFMLEngineFactorySupport.getHomeDirectory(), path.substring(10)).toString();
            } else if (path.startsWith("-directory}", 5)) {
                path = new File(CFMLEngineFactorySupport.getHomeDirectory(), path.substring(16)).toString();
            }
        }
        if (path.startsWith("{classloader")) {
            if (path.startsWith("}", 12)) {
                path = new File(CFMLEngineFactorySupport.getClassLoaderDirectory(), path.substring(13)).toString();
            } else if (path.startsWith("-dir}", 12)) {
                path = new File(CFMLEngineFactorySupport.getClassLoaderDirectory(), path.substring(17)).toString();
            } else if (path.startsWith("-directory}", 12)) {
                path = new File(CFMLEngineFactorySupport.getClassLoaderDirectory(), path.substring(23)).toString();
            }
        }
        return path;
    }

    public static File getHomeDirectory() {
        if (homeFile != null) {
            return homeFile;
        }
        String homeStr = System.getProperty("user.home");
        if (homeStr != null) {
            homeFile = new File(homeStr);
            homeFile = CFMLEngineFactorySupport.getCanonicalFileEL(homeFile);
        }
        return homeFile;
    }

    public static File getClassLoaderDirectory() {
        return CFMLEngineFactory.getClassLoaderRoot(TP.class.getClassLoader());
    }

    public static File getTempDirectory() {
        if (tempFile != null) {
            return tempFile;
        }
        String tmpStr = System.getProperty("java.io.tmpdir");
        if (tmpStr != null && (tempFile = new File(tmpStr)).exists()) {
            tempFile = CFMLEngineFactorySupport.getCanonicalFileEL(tempFile);
            return tempFile;
        }
        try {
            File tmp = File.createTempFile("a", "a");
            tempFile = tmp.getParentFile();
            tempFile = CFMLEngineFactorySupport.getCanonicalFileEL(tempFile);
            tmp.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tempFile;
    }

    public static File getSystemDirectory() {
        String pathes = System.getProperty("java.library.path");
        if (pathes != null) {
            File file;
            String[] arr;
            for (String element : arr = pathes.split(File.pathSeparator)) {
                if (element.toLowerCase().indexOf("windows\\system") == -1 || !(file = new File(element)).exists() || !file.isDirectory() || !file.canWrite()) continue;
                return CFMLEngineFactorySupport.getCanonicalFileEL(file);
            }
            for (String element : arr) {
                if (element.toLowerCase().indexOf("windows") == -1 || !(file = new File(element)).exists() || !file.isDirectory() || !file.canWrite()) continue;
                return CFMLEngineFactorySupport.getCanonicalFileEL(file);
            }
            for (String element : arr) {
                if (element.toLowerCase().indexOf("winnt") == -1 || !(file = new File(element)).exists() || !file.isDirectory() || !file.canWrite()) continue;
                return CFMLEngineFactorySupport.getCanonicalFileEL(file);
            }
            for (String element : arr) {
                if (element.toLowerCase().indexOf("win") == -1 || !(file = new File(element)).exists() || !file.isDirectory() || !file.canWrite()) continue;
                return CFMLEngineFactorySupport.getCanonicalFileEL(file);
            }
            for (String element : arr) {
                file = new File(element);
                if (!file.exists() || !file.isDirectory() || !file.canWrite()) continue;
                return CFMLEngineFactorySupport.getCanonicalFileEL(file);
            }
        }
        return null;
    }

    private static File getCanonicalFileEL(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }
}

