/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ingest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.logstash.ingest.IngestAppend;
import org.logstash.ingest.IngestConvert;
import org.logstash.ingest.IngestConverter;
import org.logstash.ingest.IngestDate;
import org.logstash.ingest.IngestGeoIp;
import org.logstash.ingest.IngestGrok;
import org.logstash.ingest.IngestGsub;
import org.logstash.ingest.IngestJson;
import org.logstash.ingest.IngestLowercase;
import org.logstash.ingest.IngestRename;
import org.logstash.ingest.IngestSet;

public class IngestPipeline {
    public static String toLogstash(String json, boolean appendStdio) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        HashMap<String, Object> jsonDefinition = mapper.readValue(json, typeRef);
        List processors = (List)jsonDefinition.get("processors");
        List<String> filters_pipeline = processors.stream().map(IngestPipeline::mapProcessor).collect(Collectors.toList());
        String logstash_pipeline = IngestConverter.filterHash(IngestConverter.joinHashFields(filters_pipeline.toArray(new String[0])));
        return IngestConverter.filtersToFile(IngestConverter.appendIoPlugins(Collections.singletonList(logstash_pipeline), appendStdio));
    }

    private static String mapProcessor(Map processor) {
        ArrayList<String> filter_blocks = new ArrayList<String>();
        if (IngestGrok.has_grok(processor)) {
            filter_blocks.add(IngestConverter.createHash(IngestGrok.get_name(), IngestGrok.grokHash(processor)));
            if (IngestConverter.hasOnFailure(processor, IngestGrok.get_name())) {
                filter_blocks.add(IngestPipeline.handle_on_failure_pipeline(IngestConverter.getOnFailure(processor, IngestGrok.get_name()), "_grokparsefailure"));
            }
        }
        boolean processed = false;
        if (IngestDate.has_date(processor)) {
            filter_blocks.add(IngestConverter.createHash("date", IngestDate.dateHash(processor)));
            processed = true;
        }
        if (IngestGeoIp.has_geoip(processor)) {
            filter_blocks.add(IngestConverter.createHash("geoip", IngestGeoIp.geoIpHash(processor)));
            processed = true;
        }
        if (IngestConvert.has_convert(processor)) {
            filter_blocks.add(IngestConverter.createHash("mutate", IngestConvert.convertHash(processor)));
            processed = true;
        }
        if (IngestGsub.has_gsub(processor)) {
            filter_blocks.add(IngestConverter.createHash("mutate", IngestGsub.gsubHash(processor)));
            processed = true;
        }
        if (IngestAppend.has_append(processor)) {
            filter_blocks.add(IngestConverter.createHash("mutate", IngestAppend.appendHash(processor)));
            processed = true;
        }
        if (IngestJson.has_json(processor)) {
            filter_blocks.add(IngestConverter.createHash("json", IngestJson.jsonHash(processor)));
            processed = true;
        }
        if (IngestRename.has_rename(processor)) {
            filter_blocks.add(IngestConverter.createHash("mutate", IngestRename.renameHash(processor)));
            processed = true;
        }
        if (IngestLowercase.has_lowercase(processor)) {
            filter_blocks.add(IngestConverter.createHash("mutate", IngestLowercase.lowercaseHash(processor)));
            processed = true;
        }
        if (IngestSet.has_set(processor)) {
            filter_blocks.add(IngestConverter.createHash("mutate", IngestSet.setHash(processor)));
            processed = true;
        }
        if (!processed) {
            System.out.println("WARN Found unrecognized processor named: " + String.valueOf(processor.keySet().iterator().next()));
        }
        return IngestConverter.joinHashFields(filter_blocks.toArray(new String[0]));
    }

    public static String handle_on_failure_pipeline(List<Map> on_failure_json, String tag_name) {
        List<String> mapped = on_failure_json.stream().map(IngestPipeline::mapProcessor).collect(Collectors.toList());
        return IngestConverter.createTagConditional(tag_name, IngestConverter.joinHashFields(mapped.toArray(new String[0])));
    }
}

