/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret.store;

import java.nio.CharBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.logstash.secret.store.SecretStoreUtil;

public class SecureConfig {
    private Map<String, CharBuffer> config = new ConcurrentHashMap<String, CharBuffer>();
    volatile boolean cleared;

    public void add(String key, char[] value) {
        if (this.cleared) {
            throw new IllegalStateException("This configuration has been cleared and can not be re-used.");
        }
        this.config.put(key, CharBuffer.wrap(SecretStoreUtil.obfuscate(value)));
    }

    public void clearValues() {
        this.config.forEach((k, v) -> SecretStoreUtil.clearChars(v.array()));
        this.cleared = true;
    }

    public SecureConfig clone() {
        if (this.cleared) {
            throw new IllegalStateException("This configuration has been cleared and can not be re-used.");
        }
        SecureConfig clone = new SecureConfig();
        this.config.forEach((k, v) -> clone.add((String)k, SecretStoreUtil.deObfuscate((char[])v.array().clone())));
        return clone;
    }

    public char[] getPlainText(String key) {
        if (this.cleared) {
            throw new IllegalStateException("This configuration has been cleared and can not be re-used.");
        }
        return this.config.get(key) == null ? null : SecretStoreUtil.deObfuscate((char[])this.config.get(key).array().clone());
    }

    public boolean has(String key) {
        return this.config.get(key) != null;
    }
}

