/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.maven.polyglot.mapping.Mapping;

@Singleton
@Named
public class PolyglotModelManager {
    protected Logger log = LoggerFactory.getLogger(PolyglotModelManager.class);
    @Inject
    protected List<Mapping> mappings;
    private static final Comparator<Mapping> DESCENDING_PRIORITY = Comparator.comparingDouble(Mapping::getPriority).reversed();

    public void addMapping(Mapping mapping) {
        assert (mapping != null);
        this.mappings.add(mapping);
    }

    public List<Mapping> getSortedMappings() {
        ArrayList<Mapping> sortedMappings = new ArrayList<Mapping>(this.mappings);
        sortedMappings.sort(DESCENDING_PRIORITY);
        return sortedMappings;
    }

    public ModelReader getReaderFor(Map<String, ?> options) {
        for (Mapping mapping : this.getSortedMappings()) {
            if (!mapping.accept(options)) continue;
            return mapping.getReader();
        }
        throw new RuntimeException("Unable to determine model input format; options=" + options);
    }

    public Properties getEnhancementPropertiesFor(Map<String, ?> options) {
        for (Mapping mapping : this.getSortedMappings()) {
            if (!mapping.accept(options)) continue;
            return mapping.getEnhancementProperties(options);
        }
        return null;
    }

    public ModelWriter getWriterFor(Map<String, ?> options) {
        for (Mapping mapping : this.getSortedMappings()) {
            if (!mapping.accept(options)) continue;
            return mapping.getWriter();
        }
        throw new RuntimeException("Unable to determine model output format; options=" + options);
    }

    public File findPom(File dir) {
        assert (dir != null);
        for (Mapping mapping : this.getSortedMappings()) {
            File file = mapping.locatePom(dir);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public String determineFlavourFromPom(File dir) {
        assert (dir != null);
        for (Mapping mapping : this.getSortedMappings()) {
            File file = mapping.locatePom(dir);
            if (file == null) continue;
            return mapping.getFlavour();
        }
        return null;
    }

    public String getFlavourFor(Map<String, ?> options) {
        for (Mapping mapping : this.getSortedMappings()) {
            if (!mapping.accept(options)) continue;
            return mapping.getFlavour();
        }
        throw new RuntimeException("Unable determine model input format; options=" + options);
    }
}

