/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.shared.common.util.ArrayUtil;

public class CursorInfo
implements Formatable {
    ExecCursorTableReference targetTable;
    List<String> updateColumns;
    int updateMode;

    public CursorInfo() {
    }

    public CursorInfo(int updateMode, ExecCursorTableReference targetTable, List<String> updateColumns) {
        this.updateMode = updateMode;
        this.targetTable = targetTable;
        this.updateColumns = updateColumns == null ? updateColumns : new ArrayList(updateColumns);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.updateMode);
        out.writeObject(this.targetTable);
        ArrayUtil.writeArray((ObjectOutput)out, (Object[])null);
        ArrayUtil.writeArray((ObjectOutput)out, this.updateColumns == null ? null : this.updateColumns.toArray());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.updateMode = in.readInt();
        this.targetTable = (ExecCursorTableReference)in.readObject();
        ArrayUtil.readObjectArray((ObjectInput)in);
        int len = ArrayUtil.readArrayLength((ObjectInput)in);
        if (len > 0) {
            this.updateColumns = Arrays.asList(ArrayUtil.readStringArray((ObjectInput)in));
        }
    }

    @Override
    public int getTypeFormatId() {
        return 297;
    }

    public String toString() {
        return "CursorInfo\n\tupdateMode: " + this.updateMode + "\n\ttargetTable: " + String.valueOf(this.targetTable) + "\n\tupdateColumns: " + String.valueOf(this.updateColumns) + "\n";
    }
}

