/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.config.runtime;

import io.quarkus.opentelemetry.runtime.config.runtime.AttributeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.BatchSpanProcessorConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.InstrumentRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.MetricsRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.SpanConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.TracesRuntimeConfig;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingObject;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class OTelRuntimeConfig1155755747Impl
implements ConfigMappingObject,
OTelRuntimeConfig {
    private boolean sdkDisabled;
    private MetricsRuntimeConfig metric;
    private TracesRuntimeConfig traces;
    private Duration experimentalShutdownWaitTime;
    private Optional experimentalResourceDisabledKeys;
    private InstrumentRuntimeConfig instrument;
    private AttributeConfig attribute;
    private Optional serviceName;
    private boolean mpCompatibility;
    private Optional resourceAttributes;
    private BatchSpanProcessorConfig bsp;
    private SpanConfig span;

    public OTelRuntimeConfig1155755747Impl() {
    }

    public OTelRuntimeConfig1155755747Impl(ConfigMappingContext mc) {
        StringBuilder sb = mc.getNameBuilder();
        int len = sb.length();
        ConfigMapping.NamingStrategy ns = mc.applyNamingStrategy(ConfigMapping.NamingStrategy.KEBAB_CASE);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append("sdk.disabled");
        try {
            this.sdkDisabled = (Boolean)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).value(Boolean.class, null).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append(ns.apply("metric"));
        try {
            this.metric = (MetricsRuntimeConfig)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).group(MetricsRuntimeConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append(ns.apply("traces"));
        try {
            this.traces = (TracesRuntimeConfig)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).group(TracesRuntimeConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append("experimental.shutdown-wait-time");
        try {
            this.experimentalShutdownWaitTime = (Duration)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).value(Duration.class, null).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append("experimental.resource.disabled-keys");
        try {
            this.experimentalResourceDisabledKeys = (Optional)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).optionalValues(String.class, null, List.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append(ns.apply("instrument"));
        try {
            this.instrument = (InstrumentRuntimeConfig)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).group(InstrumentRuntimeConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append(ns.apply("attribute"));
        try {
            this.attribute = (AttributeConfig)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).group(AttributeConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append("service.name");
        try {
            this.serviceName = (Optional)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).optionalValue(String.class, null).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append("mp.compatibility");
        try {
            this.mpCompatibility = (Boolean)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).value(Boolean.class, null).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append("resource.attributes");
        try {
            this.resourceAttributes = (Optional)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).optionalValues(String.class, null, List.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append(ns.apply("bsp"));
        try {
            this.bsp = (BatchSpanProcessorConfig)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).group(BatchSpanProcessorConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
        if (sb.length() != 0) {
            sb.append((char)46);
        }
        sb.append(ns.apply("span"));
        try {
            this.span = (SpanConfig)new ConfigMappingContext.ObjectCreator(mc, sb.toString()).group(SpanConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        sb.setLength(len);
    }

    public boolean sdkDisabled() {
        return this.sdkDisabled;
    }

    public MetricsRuntimeConfig metric() {
        return this.metric;
    }

    public TracesRuntimeConfig traces() {
        return this.traces;
    }

    public Duration experimentalShutdownWaitTime() {
        return this.experimentalShutdownWaitTime;
    }

    public Optional experimentalResourceDisabledKeys() {
        return this.experimentalResourceDisabledKeys;
    }

    public InstrumentRuntimeConfig instrument() {
        return this.instrument;
    }

    public AttributeConfig attribute() {
        return this.attribute;
    }

    public Optional serviceName() {
        return this.serviceName;
    }

    public boolean mpCompatibility() {
        return this.mpCompatibility;
    }

    public Optional resourceAttributes() {
        return this.resourceAttributes;
    }

    public BatchSpanProcessorConfig bsp() {
        return this.bsp;
    }

    public SpanConfig span() {
        return this.span;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OTelRuntimeConfig1155755747Impl oTelRuntimeConfig1155755747Impl = (OTelRuntimeConfig1155755747Impl)object;
        return this.sdkDisabled() == oTelRuntimeConfig1155755747Impl.sdkDisabled() && Objects.equals(this.metric(), oTelRuntimeConfig1155755747Impl.metric()) && Objects.equals(this.traces(), oTelRuntimeConfig1155755747Impl.traces()) && Objects.equals(this.experimentalShutdownWaitTime(), oTelRuntimeConfig1155755747Impl.experimentalShutdownWaitTime()) && Objects.equals(this.experimentalResourceDisabledKeys(), oTelRuntimeConfig1155755747Impl.experimentalResourceDisabledKeys()) && Objects.equals(this.instrument(), oTelRuntimeConfig1155755747Impl.instrument()) && Objects.equals(this.attribute(), oTelRuntimeConfig1155755747Impl.attribute()) && Objects.equals(this.serviceName(), oTelRuntimeConfig1155755747Impl.serviceName()) && this.mpCompatibility() == oTelRuntimeConfig1155755747Impl.mpCompatibility() && Objects.equals(this.resourceAttributes(), oTelRuntimeConfig1155755747Impl.resourceAttributes()) && Objects.equals(this.bsp(), oTelRuntimeConfig1155755747Impl.bsp()) && Objects.equals(this.span(), oTelRuntimeConfig1155755747Impl.span());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.sdkDisabled, this.metric, this.traces, this.experimentalShutdownWaitTime, this.experimentalResourceDisabledKeys, this.instrument, this.attribute, this.serviceName, this.mpCompatibility, this.resourceAttributes, this.bsp, this.span};
        Object[] objectArray2 = objectArray;
        return Objects.hash(objectArray);
    }

    public static Map<String, Map<String, Set<String>>> getNames() {
        HashMap<String, Map<String, Set<String>>> hashMap = new HashMap<String, Map<String, Set<String>>>();
        HashMap hashMap2 = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("experimental.resource.disabled-keys");
        hashSet.add("instrument.vertx-sql-client");
        hashSet.add("traces.suppress-non-application-uris");
        hashSet.add("instrument.vertx-redis-client");
        hashSet.add("metric.export.interval");
        hashSet.add("span.event.count.limit");
        hashSet.add("instrument.vertx-event-bus");
        hashSet.add("experimental.shutdown-wait-time");
        hashSet.add("span.link.count.limit");
        hashSet.add("span.attribute.value.length.limit");
        hashSet.add("service.name");
        hashSet.add("mp.compatibility");
        hashSet.add("traces.sampler.arg");
        hashSet.add("bsp.max.queue.size");
        hashSet.add("attribute.count.limit");
        hashSet.add("bsp.schedule.delay");
        hashSet.add("traces.include-static-resources");
        hashSet.add("bsp.max.export.batch.size");
        hashSet.add("span.attribute.count.limit");
        hashSet.add("sdk.disabled");
        hashSet.add("bsp.export.timeout");
        hashSet.add("experimental.resource.disabled-keys[*]");
        hashSet.add("resource.attributes");
        hashSet.add("resource.attributes[*]");
        hashSet.add("instrument.vertx-http");
        hashSet.add("attribute.value.length.limit");
        hashMap2.put("", hashSet);
        hashMap.put("io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig", hashMap2);
        hashMap2 = new HashMap();
        hashSet = new HashSet();
        hashSet.add("traces.sampler.arg");
        hashSet.add("traces.suppress-non-application-uris");
        hashSet.add("traces.include-static-resources");
        hashMap2.put("traces", hashSet);
        hashMap.put("io.quarkus.opentelemetry.runtime.config.runtime.TracesRuntimeConfig", hashMap2);
        hashMap2 = new HashMap();
        hashSet = new HashSet();
        hashSet.add("bsp.max.export.batch.size");
        hashSet.add("bsp.max.queue.size");
        hashSet.add("bsp.schedule.delay");
        hashSet.add("bsp.export.timeout");
        hashMap2.put("bsp", hashSet);
        hashMap.put("io.quarkus.opentelemetry.runtime.config.runtime.BatchSpanProcessorConfig", hashMap2);
        hashMap2 = new HashMap();
        hashSet = new HashSet();
        hashSet.add("instrument.vertx-sql-client");
        hashSet.add("instrument.vertx-redis-client");
        hashSet.add("instrument.vertx-event-bus");
        hashSet.add("instrument.vertx-http");
        hashMap2.put("instrument", hashSet);
        hashMap.put("io.quarkus.opentelemetry.runtime.config.runtime.InstrumentRuntimeConfig", hashMap2);
        hashMap2 = new HashMap();
        hashSet = new HashSet();
        hashSet.add("span.attribute.value.length.limit");
        hashSet.add("span.attribute.count.limit");
        hashSet.add("span.event.count.limit");
        hashSet.add("span.link.count.limit");
        hashMap2.put("span", hashSet);
        hashMap.put("io.quarkus.opentelemetry.runtime.config.runtime.SpanConfig", hashMap2);
        hashMap2 = new HashMap();
        hashSet = new HashSet();
        hashSet.add("metric.export.interval");
        hashMap2.put("metric", hashSet);
        hashMap.put("io.quarkus.opentelemetry.runtime.config.runtime.MetricsRuntimeConfig", hashMap2);
        hashMap2 = new HashMap();
        hashSet = new HashSet();
        hashSet.add("attribute.count.limit");
        hashSet.add("attribute.value.length.limit");
        hashMap2.put("attribute", hashSet);
        hashMap.put("io.quarkus.opentelemetry.runtime.config.runtime.AttributeConfig", hashMap2);
        return hashMap;
    }

    public static Map<String, String> getDefaults() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("instrument.vertx-sql-client", "true");
        hashMap.put("traces.suppress-non-application-uris", "true");
        hashMap.put("instrument.vertx-redis-client", "true");
        hashMap.put("metric.export.interval", "60s");
        hashMap.put("span.event.count.limit", "128");
        hashMap.put("instrument.vertx-event-bus", "true");
        hashMap.put("experimental.shutdown-wait-time", "1s");
        hashMap.put("span.link.count.limit", "128");
        hashMap.put("service.name", "${quarkus.application.name:unset}");
        hashMap.put("mp.compatibility", "false");
        hashMap.put("traces.sampler.arg", "1.0d");
        hashMap.put("bsp.max.queue.size", "2048");
        hashMap.put("attribute.count.limit", "128");
        hashMap.put("bsp.schedule.delay", "5s");
        hashMap.put("traces.include-static-resources", "false");
        hashMap.put("bsp.max.export.batch.size", "512");
        hashMap.put("span.attribute.count.limit", "128");
        hashMap.put("sdk.disabled", "false");
        hashMap.put("bsp.export.timeout", "30s");
        hashMap.put("instrument.vertx-http", "true");
        return hashMap;
    }
}

