/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.ValueResolver;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ValueResolverBuilder {
    private int priority = 1;
    private Predicate<EvalContext> appliesTo;
    private Function<EvalContext, CompletionStage<Object>> resolve;

    ValueResolverBuilder() {
    }

    public ValueResolverBuilder priority(int value) {
        this.priority = value;
        return this;
    }

    public ValueResolverBuilder applyToBaseClass(final Class<?> baseClass) {
        Predicate<EvalContext> p = new Predicate<EvalContext>(){

            @Override
            public boolean test(EvalContext ec) {
                return ValueResolver.matchClass(ec, baseClass);
            }
        };
        this.appliesTo = this.appliesTo != null ? this.appliesTo.and(p) : p;
        return this;
    }

    public ValueResolverBuilder applyToName(final String name) {
        Predicate<EvalContext> p = new Predicate<EvalContext>(){

            @Override
            public boolean test(EvalContext ec) {
                return ec.getName().equals(name);
            }
        };
        this.appliesTo = this.appliesTo != null ? this.appliesTo.and(p) : p;
        return this;
    }

    public ValueResolverBuilder applyToNoParameters() {
        Predicate<EvalContext> p = new Predicate<EvalContext>(){

            @Override
            public boolean test(EvalContext ec) {
                return ec.getParams().size() == 0;
            }
        };
        this.appliesTo = this.appliesTo != null ? this.appliesTo.and(p) : p;
        return this;
    }

    public ValueResolverBuilder applyToParameters(final int size) {
        Predicate<EvalContext> p = new Predicate<EvalContext>(){

            @Override
            public boolean test(EvalContext ec) {
                return ec.getParams().size() == size;
            }
        };
        this.appliesTo = this.appliesTo != null ? this.appliesTo.and(p) : p;
        return this;
    }

    public ValueResolverBuilder appliesTo(Predicate<EvalContext> predicate) {
        this.appliesTo = predicate;
        return this;
    }

    public ValueResolverBuilder resolveSync(final Function<EvalContext, Object> fun) {
        this.resolve = new Function<EvalContext, CompletionStage<Object>>(){

            @Override
            public CompletionStage<Object> apply(EvalContext context) {
                return CompletedStage.of(fun.apply(context));
            }
        };
        return this;
    }

    public ValueResolverBuilder resolveAsync(Function<EvalContext, CompletionStage<Object>> fun) {
        this.resolve = fun;
        return this;
    }

    public ValueResolverBuilder resolveWith(Object value) {
        return this.resolveAsync(ec -> CompletedStage.of(value));
    }

    public ValueResolver build() {
        return new ValueResolverImpl(this.priority, this.appliesTo, this.resolve);
    }

    private static final class ValueResolverImpl
    implements ValueResolver {
        private final int priority;
        private final Predicate<EvalContext> appliesTo;
        private final Function<EvalContext, CompletionStage<Object>> resolve;

        public ValueResolverImpl(int priority, Predicate<EvalContext> appliesTo, Function<EvalContext, CompletionStage<Object>> resolve) {
            this.priority = priority;
            this.appliesTo = appliesTo;
            this.resolve = resolve;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public boolean appliesTo(EvalContext context) {
            return this.appliesTo != null ? this.appliesTo.test(context) : true;
        }

        @Override
        public CompletionStage<Object> resolve(EvalContext context) {
            return this.resolve.apply(context);
        }
    }
}

