/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.spi.runtime;

import io.quarkus.runtime.BlockingOperationControl;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface BlockingSecurityExecutor {
    public <T> Uni<T> executeBlocking(Supplier<? extends T> var1);

    public static BlockingSecurityExecutor createBlockingExecutor(final Supplier<Executor> executorSupplier) {
        return new BlockingSecurityExecutor(){

            @Override
            public <T> Uni<T> executeBlocking(final Supplier<? extends T> function) {
                return Uni.createFrom().deferred(new Supplier<Uni<? extends T>>(){

                    @Override
                    public Uni<? extends T> get() {
                        if (BlockingOperationControl.isBlockingAllowed()) {
                            try {
                                return Uni.createFrom().item(function.get());
                            }
                            catch (Throwable t) {
                                return Uni.createFrom().failure(t);
                            }
                        }
                        return Uni.createFrom().emitter(new Consumer<UniEmitter<? super T>>(){

                            @Override
                            public void accept(final UniEmitter<? super T> uniEmitter) {
                                ((Executor)executorSupplier.get()).execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            uniEmitter.complete(function.get());
                                        }
                                        catch (Throwable t) {
                                            uniEmitter.fail(t);
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            }
        };
    }
}

