/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.loader;

import java.security.Key;
import java.util.Collections;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.keys.PublicKeyLoader;

public class HardcodedPublicKeyLoader
implements PublicKeyLoader {
    private final KeyWrapper keyWrapper;

    public HardcodedPublicKeyLoader(String kid, String encodedKey, String algorithm) {
        if (encodedKey != null && !encodedKey.trim().isEmpty()) {
            this.keyWrapper = new KeyWrapper();
            this.keyWrapper.setKid(kid);
            this.keyWrapper.setUse(KeyUse.SIG);
            if (JavaAlgorithm.isRSAJavaAlgorithm((String)algorithm)) {
                this.keyWrapper.setType("RSA");
                this.keyWrapper.setPublicKey((Key)PemUtils.decodePublicKey((String)encodedKey, (String)"RSA"));
            } else if (JavaAlgorithm.isECJavaAlgorithm((String)algorithm)) {
                this.keyWrapper.setType("EC");
                this.keyWrapper.setPublicKey((Key)PemUtils.decodePublicKey((String)encodedKey, (String)"EC"));
            } else if (JavaAlgorithm.isEddsaJavaAlgorithm((String)algorithm)) {
                this.keyWrapper.setType("OKP");
                this.keyWrapper.setPublicKey((Key)PemUtils.decodePublicKey((String)encodedKey, (String)"OKP"));
            } else if (JavaAlgorithm.isHMACJavaAlgorithm((String)algorithm)) {
                this.keyWrapper.setType("OCT");
                this.keyWrapper.setSecretKey(KeyUtils.loadSecretKey((byte[])Base64Url.decode((String)encodedKey), (String)algorithm));
            }
        } else {
            this.keyWrapper = null;
        }
    }

    public PublicKeysWrapper loadKeys() throws Exception {
        return this.keyWrapper != null ? new PublicKeysWrapper(Collections.singletonList(this.getSavedPublicKey())) : PublicKeysWrapper.EMPTY;
    }

    protected KeyWrapper getSavedPublicKey() {
        return this.keyWrapper;
    }
}

