/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.temp;

import java.io.File;
import java.io.IOException;
import javax.annotation.CheckReturnValue;

public final class TempFiles {
    private TempFiles() {
    }

    @CheckReturnValue
    static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        if (directory == null) {
            throw new NullPointerException("The `directory` argument must not be null as this will default to the system temporary directory");
        }
        if (prefix == null) {
            prefix = "gradle-";
        }
        if (prefix.length() <= 3) {
            prefix = "tmp-" + prefix;
        }
        return File.createTempFile(prefix, suffix, directory);
    }
}

