/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.initialization.ScriptClassPathInitializer;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.composite.internal.BuildTreeWorkGraphController;
import org.gradle.composite.internal.TaskIdentifier;
import org.gradle.internal.build.BuildState;

public class CompositeBuildClassPathInitializer
implements ScriptClassPathInitializer {
    private final BuildTreeWorkGraphController buildTreeWorkGraphController;
    private final BuildState currentBuild;

    public CompositeBuildClassPathInitializer(BuildTreeWorkGraphController buildTreeWorkGraphController, BuildState currentBuild) {
        this.buildTreeWorkGraphController = buildTreeWorkGraphController;
        this.currentBuild = currentBuild;
    }

    public void execute(Configuration classpath) {
        ArrayList<TaskIdentifier.TaskBasedTaskIdentifier> tasksToBuild = new ArrayList<TaskIdentifier.TaskBasedTaskIdentifier>();
        Set dependencies = TaskDependencyUtil.getDependenciesForInternalUse((TaskDependency)classpath.getBuildDependencies(), null);
        for (Task task : dependencies) {
            BuildState targetBuild = ((ProjectInternal)task.getProject()).getOwner().getOwner();
            assert (targetBuild != this.currentBuild);
            tasksToBuild.add(TaskIdentifier.of((BuildIdentifier)targetBuild.getBuildIdentifier(), (TaskInternal)((TaskInternal)task)));
        }
        if (!tasksToBuild.isEmpty()) {
            this.buildTreeWorkGraphController.withNewWorkGraph(graph -> {
                graph.scheduleWork(builder -> builder.scheduleTasks((Collection)tasksToBuild)).runWork().rethrow();
                return null;
            });
        }
    }
}

