/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.IPv6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class IPv6AddressTest {
    private static Logger log = LoggerFactory.getLogger(IPv6AddressTest.class);
    private static final String[][] TEST_ADDRESSES = new String[][]{{"fedc:ba98:7654:3210:fedc:ba98:7654:3210"}, {"FEDC:BA98:7654:3210:FEDC:BA98:7654:3211", "fedc:ba98:7654:3210:fedc:ba98:7654:3211"}, {"2001:0db8:85a3:0000:0000:8a2e:0370:7334", "2001:db8:85a3::8a2e:370:7334"}, {"2001:db8:85a3::8a2e:370:7334", "2001:db8:85a3::8a2e:370:7334"}, {"0:0:0:0:0:0:0:1", "::1"}, {"0:0:0:0:0:0:0:0", "::"}, {"::1"}, {"::"}, {"::ffff:192.0.2.128", "::ffff:c000:280"}, {"::192.0.2.128", "::c000:280"}};

    @Test
    public void parseIPv6Address() throws GalimatiasParseException {
        for (String[] testAddress : TEST_ADDRESSES) {
            String origin = testAddress[0];
            log.debug("TESTING: {}", (Object)origin);
            String target = testAddress.length > 1 ? testAddress[1] : testAddress[0];
            IPv6Address address = IPv6Address.parseIPv6Address(origin);
            Assertions.assertThat((String)address.toString()).isEqualTo((Object)target);
        }
    }

    @Test
    public void equals() throws GalimatiasParseException {
        for (String[] testAddress : TEST_ADDRESSES) {
            IPv6Address original = IPv6Address.parseIPv6Address(testAddress[0]);
            IPv6Address result = IPv6Address.parseIPv6Address(testAddress[testAddress.length > 1 ? 1 : 0]);
            Assertions.assertThat((Object)original).isEqualTo((Object)original);
            Assertions.assertThat((Object)original).isEqualTo((Object)result);
            Assertions.assertThat((int)original.hashCode()).isEqualTo(result.hashCode());
            Assertions.assertThat((Object)original).isNotEqualTo(null);
            Assertions.assertThat((Object)original).isNotEqualTo((Object)"foo");
            Assertions.assertThat((String)original.toHumanString()).isEqualTo((Object)original.toString());
        }
        Assertions.assertThat((Object)IPv6Address.parseIPv6Address(TEST_ADDRESSES[0][0])).isNotEqualTo((Object)IPv6Address.parseIPv6Address(TEST_ADDRESSES[1][0]));
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseInvalidPrefix1() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address(":1");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseInvalidPrefix2() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address(":");
    }

    @Test(expected=NullPointerException.class)
    public void parseNullAddress() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address(null);
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseEmptyAddress() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseIllegalCharacter() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("1::x:1");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseTooLongAddress() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("0:0:0:0:0:0:0:1:2");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseAddressWithFinalColon() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("0:0:0:0:0:0:0:1:");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseTooLongIPv4MappedAddress() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("0:0:0:0:0:0:0:192.168.1.1");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseTooShortAddress() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("0:0:0:0:0:1");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseDoubleCompressedAddress() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("1::2::3");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseTooLongIPv4Mapped() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("::192.168.1.1.5");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseMalformedIPv4Mapped() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("::192.168.1a.1");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseMalformedIPv4Mapped2() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("::192.168.a1.1");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseMalformedIPv4Mapped3() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("::.192.168.1.1");
    }

    @Test(expected=GalimatiasParseException.class)
    public void parseHighValueIPv4Mapped() throws GalimatiasParseException {
        IPv6Address.parseIPv6Address("::192.168.1.256");
    }

    @Test
    public void toInetAddress() throws UnknownHostException, GalimatiasParseException {
        for (String[] testAddress : TEST_ADDRESSES) {
            String origin = testAddress[0];
            log.debug("TESTING: {}", (Object)origin);
            InetAddress target = InetAddress.getByName(origin);
            IPv6Address address = IPv6Address.parseIPv6Address(origin);
            Assertions.assertThat((Object)address.toInetAddress()).isEqualTo((Object)target);
        }
    }
}

