/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.di.core.Messages;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.laf.BasePropertyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Const {
    public static final String VERSION = "3.2.2";
    public static final int TIMEOUT_GET_MILLIS = 50;
    public static final int TIMEOUT_PUT_MILLIS = 50;
    public static final int ROWS_UPDATE = 50000;
    public static final int ROWS_IN_ROWSET = 10000;
    public static final int FETCH_SIZE = 5000;
    public static final int SORT_SIZE = 5000;
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String CR = System.getProperty("line.separator");
    public static final String DOSCR = "\n\r";
    public static final String EMPTY_STRING = "";
    public static final String JAVA_VERSION = System.getProperty("java.vm.version");
    public static final String USER_HOME_DIRECTORY = Const.NVL(System.getProperty("KETTLE_HOME"), System.getProperty("user.home"));
    public static final String PLUGIN_STEPS_DIRECTORY_PUBLIC = "plugins" + FILE_SEPARATOR + "steps";
    public static final String PLUGIN_STEPS_DIRECTORY_PRIVATE = Const.getKettleDirectory() + FILE_SEPARATOR + "plugins" + FILE_SEPARATOR + "steps";
    public static final String PLUGIN_JOBENTRIES_DIRECTORY_PUBLIC = "plugins" + FILE_SEPARATOR + "jobentries";
    public static final String PLUGIN_JOBENTRIES_DIRECTORY_PRIVATE = Const.getKettleDirectory() + FILE_SEPARATOR + "plugins" + FILE_SEPARATOR + "jobentries";
    public static final Date MIN_DATE = new Date(-2208992400000L);
    public static final Date MAX_DATE = new Date(7258114799468L);
    public static final int MIN_YEAR = 1900;
    public static final int MAX_YEAR = 2199;
    public static final int RIGHT = 400;
    public static final int LENGTH = 350;
    public static final int MARGIN = 4;
    public static final int MIDDLE_PCT = 35;
    public static final int ARROW_WIDTH = 1;
    public static final int FORM_MARGIN = 5;
    public static final int SHADOW_SIZE = 4;
    public static final int SYMBOLSIZE = 10;
    public static final int MAX_FILE_HIST = 9;
    public static final Locale DEFAULT_LOCALE = Locale.getDefault();
    public static final char DEFAULT_DECIMAL_SEPARATOR = new DecimalFormatSymbols(DEFAULT_LOCALE).getDecimalSeparator();
    public static final char DEFAULT_GROUPING_SEPARATOR = new DecimalFormatSymbols(DEFAULT_LOCALE).getGroupingSeparator();
    public static final String DEFAULT_CURRENCY_SYMBOL = new DecimalFormatSymbols(DEFAULT_LOCALE).getCurrencySymbol();
    public static final String DEFAULT_NUMBER_FORMAT = ((DecimalFormat)NumberFormat.getInstance()).toPattern();
    public static final String NULL_STRING = "";
    public static final String NULL_NUMBER = "";
    public static final String NULL_DATE = "";
    public static final String NULL_BIGNUMBER = "";
    public static final String NULL_BOOLEAN = "";
    public static final String NULL_INTEGER = "";
    public static final String NULL_BINARY = "";
    public static final String NULL_NONE = "";
    public static final String CHEF_LOG_FILE = "chef";
    public static final String SPOON_LOG_FILE = "spoon";
    public static final String MENU_LOG_FILE = "menu";
    private static String[] tips;
    private static String[] dateFormats;
    private static String[] numberFormats;
    public static final String GENERALIZED_DATE_TIME_FORMAT = "yyyyddMM_hhmmss";
    public static final String GENERALIZED_DATE_TIME_FORMAT_MILLIS = "yyyyddMM_hhmmssSSS";
    public static final String XML_ENCODING = "UTF-8";
    public static final String[] STRING_TRANS_AND_JOB_FILTER_EXT;
    private static String[] STRING_TRANS_AND_JOB_FILTER_NAMES;
    public static final String STRING_TRANS_DEFAULT_EXT = "ktr";
    public static final String[] STRING_TRANS_FILTER_EXT;
    private static String[] STRING_TRANS_FILTER_NAMES;
    public static final String STRING_JOB_DEFAULT_EXT = "kjb";
    public static final String[] STRING_JOB_FILTER_EXT;
    private static String[] STRING_JOB_FILTER_NAMES;
    public static final String KETTLE_PROPERTIES = "kettle.properties";
    public static final String INTERNAL_VARIABLE_PREFIX = "Internal";
    public static final String INTERNAL_VARIABLE_KETTLE_VERSION = "Internal.Kettle.Version";
    public static final String INTERNAL_VARIABLE_KETTLE_BUILD_VERSION = "Internal.Kettle.Build.Version";
    public static final String INTERNAL_VARIABLE_KETTLE_BUILD_DATE = "Internal.Kettle.Build.Date";
    public static final String INTERNAL_VARIABLE_JOB_FILENAME_DIRECTORY = "Internal.Job.Filename.Directory";
    public static final String INTERNAL_VARIABLE_JOB_FILENAME_NAME = "Internal.Job.Filename.Name";
    public static final String INTERNAL_VARIABLE_JOB_NAME = "Internal.Job.Name";
    public static final String INTERNAL_VARIABLE_JOB_REPOSITORY_DIRECTORY = "Internal.Transformation.Repository.Directory";
    public static final String[] INTERNAL_TRANS_VARIABLES;
    public static final String[] INTERNAL_JOB_VARIABLES;
    public static final String INTERNAL_VARIABLE_TRANSFORMATION_FILENAME_DIRECTORY = "Internal.Transformation.Filename.Directory";
    public static final String INTERNAL_VARIABLE_TRANSFORMATION_FILENAME_NAME = "Internal.Transformation.Filename.Name";
    public static final String INTERNAL_VARIABLE_TRANSFORMATION_NAME = "Internal.Transformation.Name";
    public static final String INTERNAL_VARIABLE_TRANSFORMATION_REPOSITORY_DIRECTORY = "Internal.Transformation.Repository.Directory";
    public static final String INTERNAL_VARIABLE_STEP_PARTITION_ID = "Internal.Step.Partition.ID";
    public static final String INTERNAL_VARIABLE_STEP_PARTITION_NR = "Internal.Step.Partition.Number";
    public static final String INTERNAL_VARIABLE_SLAVE_SERVER_NUMBER = "Internal.Slave.Transformation.Number";
    public static final String INTERNAL_VARIABLE_SLAVE_SERVER_NAME = "Internal.Slave.Server.Name";
    public static final String INTERNAL_VARIABLE_CLUSTER_SIZE = "Internal.Cluster.Size";
    public static final String INTERNAL_VARIABLE_STEP_UNIQUE_NUMBER = "Internal.Step.Unique.Number";
    public static final String INTERNAL_VARIABLE_CLUSTER_MASTER = "Internal.Cluster.Master";
    public static final String INTERNAL_VARIABLE_STEP_UNIQUE_COUNT = "Internal.Step.Unique.Count";
    public static final String INTERNAL_VARIABLE_STEP_NAME = "Internal.Step.Name";
    public static final String INTERNAL_VARIABLE_STEP_COPYNR = "Internal.Step.CopyNr";
    public static final int MAX_NR_LOG_LINES = 5000;
    public static final int MAX_NR_HISTORY_LINES = 50;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int INFO = 3;
    public static final int NOTE_MARGIN = 5;
    public static final int MAX_UNDO = 100;
    public static final String KETTLE_PLUGIN_PACKAGES = "KETTLE_PLUGIN_PACKAGES";
    public static final String KETTLE_LOG_SIZE_LIMIT = "KETTLE_LOG_SIZE_LIMIT";
    private static String[] emptyPaddedSpacesStrings;

    public static final double round(double f, int places) {
        BigDecimal bdtemp = BigDecimal.valueOf(f);
        bdtemp = bdtemp.setScale(places, 6);
        return bdtemp.doubleValue();
    }

    public static final int toInt(String str, int def) {
        int retval;
        try {
            retval = Integer.parseInt(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final long toLong(String str, long def) {
        long retval;
        try {
            retval = Long.parseLong(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final double toDouble(String str, double def) {
        double retval;
        try {
            retval = Double.parseDouble(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }

    public static final Date toDate(String str, Date def) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.US);
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return def;
        }
    }

    public static final boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static String ltrim(String source) {
        int from;
        if (source == null) {
            return null;
        }
        for (from = 0; from < source.length() && Const.isSpace(source.charAt(from)); ++from) {
        }
        return source.substring(from);
    }

    public static String rtrim(String source) {
        int max;
        if (source == null) {
            return null;
        }
        for (max = source.length(); max > 0 && Const.isSpace(source.charAt(max - 1)); --max) {
        }
        return source.substring(0, max);
    }

    public static final String trim(String str) {
        int min;
        if (str == null) {
            return null;
        }
        int max = str.length() - 1;
        for (min = 0; min <= max && Const.isSpace(str.charAt(min)); ++min) {
        }
        while (max >= 0 && Const.isSpace(str.charAt(max))) {
            --max;
        }
        if (max < min) {
            return "";
        }
        return str.substring(min, max + 1);
    }

    public static final String rightPad(String ret, int limit) {
        if (ret == null) {
            return Const.rightPad(new StringBuffer(), limit);
        }
        return Const.rightPad(new StringBuffer(ret), limit);
    }

    public static final String rightPad(StringBuffer ret, int limit) {
        int len = ret.length();
        if (len > limit) {
            ret.setLength(limit);
        } else {
            for (int l = len; l < limit; ++l) {
                ret.append(' ');
            }
        }
        return ret.toString();
    }

    public static final String replace(String string, String repl, String with) {
        StringBuffer str = new StringBuffer(string);
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!str.substring(i).startsWith(repl)) continue;
            str.delete(i, i + repl.length());
            str.insert(i, with);
        }
        return str.toString();
    }

    public static void repl(StringBuffer str, String code, String repl) {
        int clength = code.length();
        for (int i = str.length() - clength; i >= 0; --i) {
            String look = str.substring(i, i + clength);
            if (!look.equalsIgnoreCase(code)) continue;
            str.replace(i, i + clength, repl);
        }
    }

    public static final int nrSpacesBefore(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final int nrSpacesAfter(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(field.length() - 1 - nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final boolean onlySpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Const.isSpace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final String getOS() {
        return System.getProperty("os.name");
    }

    public static final boolean isWindows() {
        return Const.getOS().startsWith("Windows");
    }

    public static final boolean isLinux() {
        return Const.getOS().startsWith("Linux");
    }

    public static final boolean isOSX() {
        return Const.getOS().toUpperCase().contains("OS X");
    }

    public static final String getHostname() {
        String lastHostname = "localhost";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface nwi = en.nextElement();
                Enumeration<InetAddress> ip = nwi.getInetAddresses();
                while (ip.hasMoreElements()) {
                    InetAddress in = ip.nextElement();
                    lastHostname = in.getHostName();
                    if (lastHostname.equalsIgnoreCase("localhost") || lastHostname.indexOf(58) >= 0) continue;
                    return lastHostname;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return lastHostname;
    }

    public static final String getIPAddress() throws Exception {
        Enumeration<NetworkInterface> enumInterfaces = NetworkInterface.getNetworkInterfaces();
        while (enumInterfaces.hasMoreElements()) {
            NetworkInterface nwi = enumInterfaces.nextElement();
            Enumeration<InetAddress> ip = nwi.getInetAddresses();
            while (ip.hasMoreElements()) {
                InetAddress in = ip.nextElement();
                if (in.isLoopbackAddress() || in.toString().indexOf(":") >= 0) continue;
                return in.getHostAddress();
            }
        }
        return "127.0.0.1";
    }

    public static final String getIPAddress(String networkInterfaceName) throws SocketException {
        NetworkInterface networkInterface = NetworkInterface.getByName(networkInterfaceName);
        Enumeration<InetAddress> ipAddresses = networkInterface.getInetAddresses();
        while (ipAddresses.hasMoreElements()) {
            InetAddress inetAddress = ipAddresses.nextElement();
            if (inetAddress.isLoopbackAddress() || inetAddress.toString().indexOf(":") >= 0) continue;
            String hostname = inetAddress.getHostAddress();
            return hostname;
        }
        return null;
    }

    public static final String getMACAddress() throws Exception {
        String ip = Const.getIPAddress();
        String mac = "none";
        String os = Const.getOS();
        String s = "";
        if (os.equalsIgnoreCase("Windows NT") || os.equalsIgnoreCase("Windows 2000") || os.equalsIgnoreCase("Windows XP") || os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("Windows 98") || os.equalsIgnoreCase("Windows Me") || os.startsWith("Windows")) {
            try {
                Process p = Runtime.getRuntime().exec("nbtstat -a " + ip);
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        if (s.indexOf("MAC") < 0) continue;
                        int idx = s.indexOf(61);
                        mac = s.substring(idx + 2);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {}
        } else if (os.equalsIgnoreCase("Linux")) {
            try {
                Process p = Runtime.getRuntime().exec("/sbin/ifconfig -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        int idx = s.indexOf("HWaddr");
                        if (idx < 0) continue;
                        mac = s.substring(idx + 7);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {}
        } else if (os.equalsIgnoreCase("Solaris")) {
            try {
                Process p = Runtime.getRuntime().exec("/usr/sbin/ifconfig -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        int idx = s.indexOf("ether");
                        if (idx < 0) continue;
                        mac = s.substring(idx + 6);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {}
        } else if (os.equalsIgnoreCase("HP-UX")) {
            try {
                Process p = Runtime.getRuntime().exec("/usr/sbin/lanscan -a");
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while (!Const.procDone(p)) {
                    while ((s = stdInput.readLine()) != null) {
                        if (s.indexOf("MAC") < 0) continue;
                        int idx = s.indexOf("0x");
                        mac = s.substring(idx + 2);
                    }
                }
                stdInput.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Const.trim(mac);
    }

    private static final boolean procDone(Process p) {
        try {
            p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public static final String getKettleDirectory() {
        return USER_HOME_DIRECTORY + FILE_SEPARATOR + BasePropertyHandler.getProperty("userBaseDir", ".kettle");
    }

    public static final String getSharedObjectsFile() {
        return Const.getKettleDirectory() + FILE_SEPARATOR + "shared.xml";
    }

    public static final String getKettleLocalRepositoriesFile() {
        return "repositories.xml";
    }

    public static final String getKettleUserRepositoriesFile() {
        return Const.getKettleDirectory() + FILE_SEPARATOR + Const.getKettleLocalRepositoriesFile();
    }

    public static final String getKettleLocalCartePasswordFile() {
        return "pwd/kettle.pwd";
    }

    public static final String getKettleCartePasswordFile() {
        return Const.getKettleDirectory() + FILE_SEPARATOR + "kettle.pwd";
    }

    public static String getEnvironmentVariable(String variable, String deflt) {
        return System.getProperty(variable, deflt);
    }

    public static final String replEnv(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer str = new StringBuffer(string);
        int idx = str.indexOf("%%");
        while (idx >= 0) {
            int to = str.indexOf("%%", idx + 2);
            if (to >= 0) {
                String newval;
                String marker = str.substring(idx, to + 2);
                String var = str.substring(idx + 2, to);
                if (var != null && var.length() > 0 && (newval = Const.getEnvironmentVariable(var, null)) != null) {
                    str.replace(idx, to + 2, newval);
                    to += newval.length() - marker.length();
                }
            } else {
                to = idx;
            }
            idx = str.indexOf("%%", to + 1);
        }
        return str.toString();
    }

    public static final String[] replEnv(String[] string) {
        String[] retval = new String[string.length];
        for (int i = 0; i < string.length; ++i) {
            retval[i] = Const.replEnv(string[i]);
        }
        return retval;
    }

    public static final String NVL(String source, String def) {
        if (source == null || source.length() == 0) {
            return def;
        }
        return source;
    }

    public static final int indexOfString(String lookup, String[] array) {
        if (array == null) {
            return -1;
        }
        if (lookup == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!lookup.equalsIgnoreCase(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static final int[] indexsOfStrings(String[] lookup, String[] array) {
        int[] indexes = new int[lookup.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = Const.indexOfString(lookup[i], array);
        }
        return indexes;
    }

    public static final int[] indexsOfFoundStrings(String[] lookup, String[] array) {
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        for (int i = 0; i < lookup.length; ++i) {
            int idx = Const.indexOfString(lookup[i], array);
            if (idx < 0) continue;
            indexesList.add(idx);
        }
        int[] indexes = new int[indexesList.size()];
        for (int i = 0; i < indexesList.size(); ++i) {
            indexes[i] = (Integer)indexesList.get(i);
        }
        return indexes;
    }

    public static final int indexOfString(String lookup, List<String> list) {
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            String compare = list.get(i);
            if (!lookup.equalsIgnoreCase(compare)) continue;
            return i;
        }
        return -1;
    }

    public static final String[] sortStrings(String[] input) {
        Arrays.sort(input);
        return input;
    }

    public static final String[] splitString(String string, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int sepLen = separator.length();
        int from = 0;
        int end = string.length() - sepLen + 1;
        for (int i = from; i < end; i += sepLen) {
            if (!string.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            list.add(Const.NVL(string.substring(from, i), ""));
            from = i + sepLen;
        }
        if (from + sepLen <= string.length()) {
            list.add(Const.NVL(string.substring(from, string.length()), ""));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String[] splitString(String string, char separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int from = 0;
        int end = string.length();
        for (int i = from; i < end; ++i) {
            if (string.charAt(i) != separator) continue;
            list.add(Const.NVL(string.substring(from, i), ""));
            from = i + 1;
        }
        if (from + 1 <= string.length()) {
            list.add(Const.NVL(string.substring(from, string.length()), ""));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final String[] splitPath(String path, String separator) {
        int from;
        if (path == null || path.length() == 0 || path.equals(separator)) {
            return new String[0];
        }
        int sepLen = separator.length();
        int nr_separators = 1;
        for (int i = from = path.startsWith(separator) ? sepLen : 0; i < path.length(); i += sepLen) {
            if (!path.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            ++nr_separators;
        }
        String[] spath = new String[nr_separators];
        int nr = 0;
        for (int i = from; i < path.length(); i += sepLen) {
            if (!path.substring(i, i + sepLen).equalsIgnoreCase(separator)) continue;
            spath[nr] = path.substring(from, i);
            ++nr;
            from = i + sepLen;
        }
        if (nr < spath.length) {
            spath[nr] = path.substring(from);
        }
        if (spath.length == 0 && path.length() > 0) {
            spath = new String[]{path};
        }
        return spath;
    }

    public static String[] getConversionFormats() {
        int x;
        String[] dats = Const.getDateFormats();
        String[] nums = Const.getNumberFormats();
        int totsize = dats.length + nums.length;
        String[] formats = new String[totsize];
        for (x = 0; x < dats.length; ++x) {
            formats[x] = dats[x];
        }
        for (x = 0; x < nums.length; ++x) {
            formats[dats.length + x] = nums[x];
        }
        return formats;
    }

    public static final String[] getDistinctStrings(String[] strings) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return new String[0];
        }
        String[] sorted = Const.sortStrings(strings);
        ArrayList<String> result = new ArrayList<String>();
        String previous = "";
        for (int i = 0; i < sorted.length; ++i) {
            if (!sorted[i].equalsIgnoreCase(previous)) {
                result.add(sorted[i]);
            }
            previous = sorted[i];
        }
        return result.toArray(new String[result.size()]);
    }

    public static final String getStackTracker(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String string = stringWriter.getBuffer().toString();
        try {
            stringWriter.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return string;
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static final boolean isEmpty(StringBuffer string) {
        return string == null || string.length() == 0;
    }

    public static final boolean isEmpty(String[] strings) {
        return strings == null || strings.length == 0;
    }

    public static final boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static final ClassLoader createNewClassLoader() throws KettleException {
        try {
            URL[] urls = new URL[]{};
            URLClassLoader ucl = new URLClassLoader(urls);
            return ucl;
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error during classloader creation", e);
        }
    }

    public static final byte[] createByteArray(int size) {
        return new byte[size];
    }

    public static final String initCap(String string) {
        StringBuffer change = new StringBuffer(string);
        boolean new_word = true;
        for (int i = 0; i < string.length(); ++i) {
            char upper;
            char lower = change.substring(i, i + 1).toLowerCase().charAt(0);
            char ch = upper = change.substring(i, i + 1).toUpperCase().charAt(0);
            if (new_word) {
                change.setCharAt(i, upper);
            } else {
                change.setCharAt(i, lower);
            }
            new_word = false;
            if (Character.isLetterOrDigit((int)ch) || ch == '_') continue;
            new_word = true;
        }
        return change.toString();
    }

    public static final String createFilename(String name) {
        StringBuffer filename = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUnicodeIdentifierPart(c)) {
                filename.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            filename.append('_');
        }
        return filename.toString().toLowerCase();
    }

    public static final String createFilename(String directory, String name, String extension) {
        if (directory.endsWith(FILE_SEPARATOR)) {
            return directory + Const.createFilename(name) + extension;
        }
        return directory + FILE_SEPARATOR + Const.createFilename(name) + extension;
    }

    public static final String createName(String filename) {
        if (Const.isEmpty(filename)) {
            return filename;
        }
        String pureFilename = Const.filenameOnly(filename);
        if (pureFilename.endsWith(".ktr") || pureFilename.endsWith(".kjb") || pureFilename.endsWith(".xml")) {
            pureFilename = pureFilename.substring(0, pureFilename.length() - 4);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pureFilename.length(); ++i) {
            char c = pureFilename.charAt(i);
            if (Character.isUnicodeIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                sb.append(' ');
                continue;
            }
            if (c != '-') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String filenameOnly(String sFullPath) {
        if (Const.isEmpty(sFullPath)) {
            return sFullPath;
        }
        int idx = sFullPath.lastIndexOf(FILE_SEPARATOR);
        if (idx != -1) {
            return sFullPath.substring(idx + 1);
        }
        idx = sFullPath.lastIndexOf(47);
        if (idx != -1) {
            return sFullPath.substring(idx + 1);
        }
        return sFullPath;
    }

    public static String[] getTips() {
        if (tips == null) {
            int tipsOfDayCount = Const.toInt(Messages.getString("Const.TipOfDay.Count"), 0);
            tips = new String[tipsOfDayCount];
            for (int i = 1; i <= tipsOfDayCount; ++i) {
                Const.tips[i - 1] = Messages.getString("Const.TipOfDay" + Integer.toString(i));
            }
        }
        return tips;
    }

    public static String[] getDateFormats() {
        if (dateFormats == null) {
            int dateFormatsCount = Const.toInt(Messages.getString("Const.DateFormat.Count"), 0);
            dateFormats = new String[dateFormatsCount];
            for (int i = 1; i <= dateFormatsCount; ++i) {
                Const.dateFormats[i - 1] = Messages.getString("Const.DateFormat" + Integer.toString(i));
            }
        }
        return dateFormats;
    }

    public static String[] getNumberFormats() {
        if (numberFormats == null) {
            int numberFormatsCount = Const.toInt(Messages.getString("Const.NumberFormat.Count"), 0);
            numberFormats = new String[numberFormatsCount + 1];
            Const.numberFormats[0] = DEFAULT_NUMBER_FORMAT;
            for (int i = 1; i <= numberFormatsCount; ++i) {
                Const.numberFormats[i] = Messages.getString("Const.NumberFormat" + Integer.toString(i));
            }
        }
        return numberFormats;
    }

    public static String[] getTransformationAndJobFilterNames() {
        if (STRING_TRANS_AND_JOB_FILTER_NAMES == null) {
            STRING_TRANS_AND_JOB_FILTER_NAMES = new String[]{Messages.getString("Const.FileFilter.TransformationJob"), Messages.getString("Const.FileFilter.Transformations"), Messages.getString("Const.FileFilter.Jobs"), Messages.getString("Const.FileFilter.XML"), Messages.getString("Const.FileFilter.All")};
        }
        return STRING_TRANS_AND_JOB_FILTER_NAMES;
    }

    public static String[] getTransformationFilterNames() {
        if (STRING_TRANS_FILTER_NAMES == null) {
            STRING_TRANS_FILTER_NAMES = new String[]{Messages.getString("Const.FileFilter.Transformations"), Messages.getString("Const.FileFilter.XML"), Messages.getString("Const.FileFilter.All")};
        }
        return STRING_TRANS_FILTER_NAMES;
    }

    public static String[] getJobFilterNames() {
        if (STRING_JOB_FILTER_NAMES == null) {
            STRING_JOB_FILTER_NAMES = new String[]{Messages.getString("Const.FileFilter.Jobs"), Messages.getString("Const.FileFilter.XML"), Messages.getString("Const.FileFilter.All")};
        }
        return STRING_JOB_FILTER_NAMES;
    }

    public static long nanoTime() {
        return new Date().getTime() * 1000L;
    }

    public static String trimToType(String string, int trimType) {
        switch (trimType) {
            case 3: {
                return Const.trim(string);
            }
            case 1: {
                return Const.ltrim(string);
            }
            case 2: {
                return Const.rtrim(string);
            }
        }
        return string;
    }

    public static String safeAppendDirectory(String dir, String file) {
        boolean fileHasSeparator;
        boolean dirHasSeparator = dir.lastIndexOf(FILE_SEPARATOR) == dir.length();
        boolean bl = fileHasSeparator = file.indexOf(FILE_SEPARATOR) != 0;
        if (dirHasSeparator && !fileHasSeparator || !dirHasSeparator && fileHasSeparator) {
            return dir + file;
        }
        if (dirHasSeparator && fileHasSeparator) {
            return dir + file.substring(1);
        }
        return dir + FILE_SEPARATOR + file;
    }

    public static String[] getEmptyPaddedStrings() {
        if (emptyPaddedSpacesStrings == null) {
            emptyPaddedSpacesStrings = new String[250];
            for (int i = 0; i < emptyPaddedSpacesStrings.length; ++i) {
                Const.emptyPaddedSpacesStrings[i] = Const.rightPad("", i);
            }
        }
        return emptyPaddedSpacesStrings;
    }

    public static final int getPercentageFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long totalFreeMemory = freeMemory + (maxMemory - allocatedMemory);
        int percentage = (int)Math.round(100.0 * (double)totalFreeMemory / (double)maxMemory);
        return percentage;
    }

    public static String removeDigits(String input) {
        if (Const.isEmpty(input)) {
            return null;
        }
        StringBuffer digitsOnly = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isDigit(c)) continue;
            digitsOnly.append(c);
        }
        return digitsOnly.toString();
    }

    public static String getDigitsOnly(String input) {
        if (Const.isEmpty(input)) {
            return null;
        }
        StringBuffer digitsOnly = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Character.isDigit(c)) continue;
            digitsOnly.append(c);
        }
        return digitsOnly.toString();
    }

    public static Date removeTimeFromDate(Date input) {
        if (input == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(input);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String maskXML(String content) {
        if (Const.isEmpty(content)) {
            return content;
        }
        StringBuffer out = new StringBuffer();
        char[] chars = content.toCharArray();
        block7: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    out.append("&apos;");
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    public static String removeCRLF(String in) {
        char[] inArray = in.toCharArray();
        StringBuffer out = new StringBuffer(inArray.length);
        for (int i = 0; i < inArray.length; ++i) {
            char c = inArray[i];
            if (c == '\n' || c == '\r') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String removeCR(String in) {
        char[] inArray = in.toCharArray();
        StringBuffer out = new StringBuffer(inArray.length);
        for (int i = 0; i < inArray.length; ++i) {
            char c = inArray[i];
            if (c == '\n') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String removeLF(String in) {
        char[] inArray = in.toCharArray();
        StringBuffer out = new StringBuffer(inArray.length);
        for (int i = 0; i < inArray.length; ++i) {
            char c = inArray[i];
            if (c == '\r') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static String removeTAB(String in) {
        char[] inArray = in.toCharArray();
        StringBuffer out = new StringBuffer(inArray.length);
        for (int i = 0; i < inArray.length; ++i) {
            char c = inArray[i];
            if (c == '\t') continue;
            out.append(c);
        }
        return out.toString();
    }

    public static Date addTimeToDate(Date input, String time, String DateFormat2) throws Exception {
        if (Const.isEmpty(time)) {
            return input;
        }
        if (input == null) {
            return null;
        }
        String dateformatString = Const.NVL(DateFormat2, "HH:mm:ss");
        int t = Const.decodeTime(time, dateformatString);
        Date d = new Date(input.getTime() + (long)t);
        return d;
    }

    public static int decodeTime(String s, String DateFormat2) throws Exception {
        SimpleDateFormat f = new SimpleDateFormat(DateFormat2);
        TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
        f.setTimeZone(utcTimeZone);
        f.setLenient(false);
        ParsePosition p = new ParsePosition(0);
        Date d = f.parse(s, p);
        if (d == null) {
            throw new Exception("Invalid time value " + DateFormat2 + ": \"" + s + "\".");
        }
        return (int)d.getTime();
    }

    public static int getOccurenceString(String string, String searchFor) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int counter = 0;
        int len = searchFor.length();
        int result = 0;
        if (len > 0) {
            int start = string.indexOf(searchFor);
            while (start != -1) {
                ++result;
                start = string.indexOf(searchFor, start + len);
            }
        }
        return counter;
    }

    static {
        STRING_TRANS_AND_JOB_FILTER_EXT = new String[]{"*.ktr;*.kjb;*.xml", "*.ktr;*.xml", "*.kjb;*.xml", "*.xml", "*.*"};
        STRING_TRANS_FILTER_EXT = new String[]{"*.ktr;*.xml", "*.xml", "*.*"};
        STRING_JOB_FILTER_EXT = new String[]{"*.kjb;*.xml", "*.xml", "*.*"};
        INTERNAL_TRANS_VARIABLES = new String[]{INTERNAL_VARIABLE_TRANSFORMATION_FILENAME_DIRECTORY, INTERNAL_VARIABLE_TRANSFORMATION_FILENAME_NAME, INTERNAL_VARIABLE_TRANSFORMATION_NAME, "Internal.Transformation.Repository.Directory"};
        INTERNAL_JOB_VARIABLES = new String[]{INTERNAL_VARIABLE_JOB_FILENAME_DIRECTORY, INTERNAL_VARIABLE_JOB_FILENAME_NAME, INTERNAL_VARIABLE_JOB_NAME, "Internal.Transformation.Repository.Directory"};
    }
}

