/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolox.swt.SWTTimer;
import org.eclipse.swt.widgets.Display;

public class SWTTimerQueue
implements Runnable {
    static SWTTimerQueue instance;
    Display display = null;
    SWTTimer firstTimer;
    boolean running;

    public SWTTimerQueue(Display display) {
        this.display = display;
        this.start();
    }

    public static SWTTimerQueue sharedInstance(Display display) {
        if (instance == null) {
            instance = new SWTTimerQueue(display);
        }
        return instance;
    }

    synchronized void start() {
        if (this.running) {
            throw new RuntimeException("Can't start a TimerQueue that is already running");
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Thread thread = new Thread((Runnable)SWTTimerQueue.this, "TimerQueue");
                thread.setDaemon(true);
                thread.setPriority(5);
                thread.start();
            }
        });
        this.running = true;
    }

    synchronized void stop() {
        this.running = false;
        this.notify();
    }

    synchronized void addTimer(SWTTimer sWTTimer, long l) {
        if (sWTTimer.running) {
            return;
        }
        SWTTimer sWTTimer2 = null;
        SWTTimer sWTTimer3 = this.firstTimer;
        while (sWTTimer3 != null && sWTTimer3.expirationTime <= l) {
            sWTTimer2 = sWTTimer3;
            sWTTimer3 = sWTTimer3.nextTimer;
        }
        if (sWTTimer2 == null) {
            this.firstTimer = sWTTimer;
        } else {
            sWTTimer2.nextTimer = sWTTimer;
        }
        sWTTimer.expirationTime = l;
        sWTTimer.nextTimer = sWTTimer3;
        sWTTimer.running = true;
        this.notify();
    }

    synchronized void removeTimer(SWTTimer sWTTimer) {
        if (!sWTTimer.running) {
            return;
        }
        SWTTimer sWTTimer2 = null;
        SWTTimer sWTTimer3 = this.firstTimer;
        boolean bl = false;
        while (sWTTimer3 != null) {
            if (sWTTimer3 == sWTTimer) {
                bl = true;
                break;
            }
            sWTTimer2 = sWTTimer3;
            sWTTimer3 = sWTTimer3.nextTimer;
        }
        if (!bl) {
            return;
        }
        if (sWTTimer2 == null) {
            this.firstTimer = sWTTimer.nextTimer;
        } else {
            sWTTimer2.nextTimer = sWTTimer.nextTimer;
        }
        sWTTimer.expirationTime = 0L;
        sWTTimer.nextTimer = null;
        sWTTimer.running = false;
    }

    synchronized boolean containsTimer(SWTTimer sWTTimer) {
        return sWTTimer.running;
    }

    synchronized long postExpiredTimers() {
        long l;
        do {
            SWTTimer sWTTimer;
            if ((sWTTimer = this.firstTimer) == null) {
                return 0L;
            }
            long l2 = System.currentTimeMillis();
            l = sWTTimer.expirationTime - l2;
            if (l > 0L) continue;
            try {
                sWTTimer.postOverride();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.removeTimer(sWTTimer);
            if (sWTTimer.isRepeats()) {
                this.addTimer(sWTTimer, l2 + (long)sWTTimer.getDelay());
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (l <= 0L);
        return l;
    }

    public synchronized void run() {
        try {
            while (this.running) {
                long l = this.postExpiredTimers();
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (ThreadDeath threadDeath) {
            this.running = false;
            SWTTimer sWTTimer = this.firstTimer;
            while (sWTTimer != null) {
                sWTTimer.cancelEventOverride();
                sWTTimer = sWTTimer.nextTimer;
            }
            this.display.asyncExec((Runnable)new SWTTimerQueueRestart(this.display));
            throw threadDeath;
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TimerQueue (");
        SWTTimer sWTTimer = this.firstTimer;
        while (sWTTimer != null) {
            stringBuffer.append(sWTTimer.toString());
            sWTTimer = sWTTimer.nextTimer;
            if (sWTTimer == null) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected static class SWTTimerQueueRestart
    implements Runnable {
        boolean attemptedStart;
        Display display = null;

        public SWTTimerQueueRestart(Display display) {
            this.display = display;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (!this.attemptedStart) {
                SWTTimerQueue sWTTimerQueue;
                SWTTimerQueue sWTTimerQueue2 = sWTTimerQueue = SWTTimerQueue.sharedInstance(this.display);
                synchronized (sWTTimerQueue2) {
                    if (!sWTTimerQueue.running) {
                        sWTTimerQueue.start();
                    }
                }
                this.attemptedStart = true;
            }
        }
    }
}

