import events from 'node:events';
import { Adapter, Events as AdapterEvents } from '../adapter';
import * as Zcl from '../zspec/zcl';
import { GreenPowerDeviceJoinedPayload } from './tstype';
interface GreenPowerEventMap {
    deviceJoined: [payload: GreenPowerDeviceJoinedPayload];
}
export declare class GreenPower extends events.EventEmitter<GreenPowerEventMap> {
    private adapter;
    constructor(adapter: Adapter);
    private encryptSecurityKey;
    private sendPairingCommand;
    onZclGreenPowerData(dataPayload: AdapterEvents.ZclPayload, frame: Zcl.Frame): Promise<void>;
    permitJoin(time: number, networkAddress?: number): Promise<void>;
}
export default GreenPower;
//# sourceMappingURL=greenPower.d.ts.map