/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class BstplProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("BSTPL$").number("(d),").expression("([^,]+),").expression("([AV]),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(d+.d+),([0NS]),").number("(d+.d+),([0EW]),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("([01]),").number("(d+),").number("([01]),").number("([01]),").number("([01]),").number("([01]),").number("(d+.d+),").number("d+,").number("(d+.d+),").expression("([^,]+),").number("([^,]+),").number("(d+.d+)").compile();

    public BstplProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int value) {
        return switch (value) {
            case 4 -> "lowBattery";
            case 5 -> "hardAcceleration";
            case 6 -> "hardBraking";
            case 7 -> "overspeed";
            case 9 -> "sos";
            default -> null;
        };
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        boolean charge;
        boolean boxOpen;
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        int type = parser.nextInt();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.addAlarm(this.decodeAlarm(type));
        position.setValid(parser.next().equals("A"));
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.set("odometer", (long)parser.nextInt().intValue() * 1000L);
        position.setCourse(parser.nextInt().intValue());
        position.set("sat", parser.nextInt());
        boolean bl = boxOpen = parser.nextInt() > 0;
        if (type == 8 && boxOpen) {
            position.addAlarm("tampering");
        }
        position.set("boxOpen", boxOpen);
        position.set("rssi", parser.nextInt());
        boolean bl2 = charge = parser.nextInt() > 0;
        if (type == 3) {
            position.addAlarm(charge ? "powerRestored" : "powerCut");
        }
        position.set("charge", charge);
        position.set("ignition", parser.nextInt() > 0);
        position.set("engine", parser.nextInt() > 0);
        position.set("blocked", parser.nextInt() > 0);
        position.set("adc1", parser.nextDouble());
        position.set("battery", parser.nextDouble());
        position.set("iccid", parser.next());
        position.set("power", parser.nextDouble());
        return position;
    }
}

