/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.xmss.BDS;
import org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import org.bouncycastle.pqc.crypto.xmss.XMSSKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSNode;
import org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;

public final class XMSSKeyPairGenerator {
    private XMSSParameters params;
    private SecureRandom prng;

    public void init(KeyGenerationParameters param) {
        XMSSKeyGenerationParameters parameters = (XMSSKeyGenerationParameters)param;
        this.prng = parameters.getRandom();
        this.params = parameters.getParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        XMSSPrivateKeyParameters privateKey = this.generatePrivateKey(this.params, this.prng);
        XMSSNode root = privateKey.getBDSState().getRoot();
        privateKey = new XMSSPrivateKeyParameters.Builder(this.params).withSecretKeySeed(privateKey.getSecretKeySeed()).withSecretKeyPRF(privateKey.getSecretKeyPRF()).withPublicSeed(privateKey.getPublicSeed()).withRoot(root.getValue()).withBDSState(privateKey.getBDSState()).build();
        XMSSPublicKeyParameters publicKey = new XMSSPublicKeyParameters.Builder(this.params).withRoot(root.getValue()).withPublicSeed(privateKey.getPublicSeed()).build();
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }

    private XMSSPrivateKeyParameters generatePrivateKey(XMSSParameters params, SecureRandom prng) {
        int n = params.getDigestSize();
        byte[] secretKeySeed = new byte[n];
        prng.nextBytes(secretKeySeed);
        byte[] secretKeyPRF = new byte[n];
        prng.nextBytes(secretKeyPRF);
        byte[] publicSeed = new byte[n];
        prng.nextBytes(publicSeed);
        XMSSPrivateKeyParameters privateKey = new XMSSPrivateKeyParameters.Builder(params).withSecretKeySeed(secretKeySeed).withSecretKeyPRF(secretKeyPRF).withPublicSeed(publicSeed).withBDSState(new BDS(params, publicSeed, secretKeySeed, (OTSHashAddress)new OTSHashAddress.Builder().build())).build();
        return privateKey;
    }
}

