/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleLookup
extends Lookup {
    private Collection<Lookup.Item<?>> allItems;

    SimpleLookup(Collection<Object> collection) {
        this.allItems = new ArrayList(collection.size());
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.allItems.add(new InstanceContent.SimpleItem<Object>(iterator.next()));
        }
    }

    <T, R> SimpleLookup(Collection<T> collection, InstanceContent.Convertor<? super T, R> convertor) {
        this.allItems = new ArrayList(collection.size());
        for (T t : collection) {
            this.allItems.add(new InstanceContent.ConvertingItem<T, R>(t, convertor));
        }
    }

    public String toString() {
        return "SimpleLookup" + this.lookup(new Lookup.Template<Object>(Object.class)).allInstances();
    }

    @Override
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        if (template == null) {
            throw new NullPointerException();
        }
        return new SimpleResult<T>(template);
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        for (Lookup.Item<?> item : this.allItems) {
            Object t;
            AbstractLookup.Pair pair;
            if (!(item instanceof AbstractLookup.Pair) || !(pair = (AbstractLookup.Pair)item).instanceOf(clazz) || !clazz.isInstance(t = pair.getInstance())) continue;
            return clazz.cast(t);
        }
        return null;
    }

    private static boolean matches(Lookup.Template<?> template, AbstractLookup.Pair<?> pair) {
        if (!AbstractLookup.matches(template, pair, true)) {
            return false;
        }
        Class clazz = template.getType();
        return clazz == null || clazz.isAssignableFrom(pair.getType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleResult<T>
    extends Lookup.Result<T> {
        private Set<Class<? extends T>> classes;
        private Collection<? extends Lookup.Item<T>> items;
        private Lookup.Template<T> template;
        private Collection<T> results;

        SimpleResult(Lookup.Template<T> template) {
            this.template = template;
        }

        @Override
        public void addLookupListener(LookupListener lookupListener) {
        }

        @Override
        public void removeLookupListener(LookupListener lookupListener) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<? extends T> allInstances() {
            Object object = this;
            synchronized (object) {
                if (this.results != null) {
                    return this.results;
                }
            }
            object = new ArrayList(SimpleLookup.this.allItems.size());
            for (Lookup.Item<T> item : this.allItems()) {
                object.add(item.getInstance());
            }
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                this.results = Collections.unmodifiableCollection(object);
            }
            return this.results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Class<? extends T>> allClasses() {
            Object object = this;
            synchronized (object) {
                if (this.classes != null) {
                    return this.classes;
                }
            }
            object = new HashSet();
            for (Lookup.Item<T> item : this.allItems()) {
                object.add(item.getType());
            }
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                this.classes = Collections.unmodifiableSet(object);
            }
            return this.classes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            Object object = this;
            synchronized (object) {
                if (this.items != null) {
                    return this.items;
                }
            }
            object = new ArrayList(SimpleLookup.this.allItems.size());
            for (Lookup.Item item : SimpleLookup.this.allItems) {
                if (!(item instanceof AbstractLookup.Pair) || !SimpleLookup.matches(this.template, (AbstractLookup.Pair)item)) continue;
                object.add(this.cast(item));
            }
            SimpleResult simpleResult = this;
            synchronized (simpleResult) {
                this.items = Collections.unmodifiableCollection(object);
            }
            return this.items;
        }

        private Lookup.Item<T> cast(Lookup.Item<?> item) {
            return item;
        }
    }
}

