/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.codeInsight.intentions.SpecifyTypeInPy3AnnotationsIntention;
import com.jetbrains.python.codeInsight.intentions.TypeIntention;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyStatementList;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyAnnotateTypesIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.add.type.hints.for.function", new Object[0]);
        if (string == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        boolean allParametersAnnotated;
        if (project == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PyFile) || file instanceof PyDocstringFile) {
            return false;
        }
        PyFunction function = PyAnnotateTypesIntention.findSuitableFunction(editor2, file);
        if (function == null) {
            return false;
        }
        if (function.getTypeComment() != null) {
            return false;
        }
        PyAnnotation annotation = function.getAnnotation();
        if (annotation != null && (allParametersAnnotated = ContainerUtil.and((Object[])function.getParameterList().getParameters(), it -> it instanceof PyNamedParameter && ((PyNamedParameter)it).getAnnotation() != null))) {
            return false;
        }
        this.setText(PyPsiBundle.message("INTN.add.type.hints.for.function", function.getName()));
        return true;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PyFunction function;
        if (project == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(2);
        }
        if ((function = PyAnnotateTypesIntention.findSuitableFunction(editor2, file)) != null) {
            PyAnnotateTypesIntention.annotateTypes(editor2, function);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static PyFunction findSuitableFunction(@NotNull Editor editor2, @NotNull PsiFile file) {
        if (editor2 == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(3);
        }
        if (file == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(4);
        }
        return TypeIntention.findOnlySuitableFunction(editor2, file, input -> true);
    }

    public static void annotateTypes(Editor editor2, PyFunction function) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)function)) {
            return;
        }
        WriteAction.run(() -> {
            if (PyAnnotateTypesIntention.isPy3k(function.getContainingFile())) {
                PyAnnotateTypesIntention.generatePy3kTypeAnnotations(function.getProject(), editor2, function);
            } else {
                PyAnnotateTypesIntention.generateTypeCommentAnnotations(function.getProject(), function);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateTypeCommentAnnotations(Project project, PyFunction function) {
        StringBuilder replacementTextBuilder = new StringBuilder("# type: (");
        PyParameter[] params = function.getParameterList().getParameters();
        ArrayList<Pair> templates = new ArrayList<Pair>();
        for (int i = 0; i < params.length; ++i) {
            if (params[i].isSelf()) continue;
            String type2 = SpecifyTypeInPy3AnnotationsIntention.parameterType(params[i]);
            templates.add(Pair.create((Object)replacementTextBuilder.length(), (Object)type2));
            replacementTextBuilder.append(type2);
            if (i >= params.length - 1) continue;
            replacementTextBuilder.append(", ");
        }
        replacementTextBuilder.append(") -> ");
        String returnType = SpecifyTypeInPy3AnnotationsIntention.returnType(function);
        templates.add(Pair.create((Object)replacementTextBuilder.length(), (Object)returnType));
        replacementTextBuilder.append(returnType);
        PyStatementList statements = function.getStatementList();
        String indentation = PyIndentUtil.getElementIndent((PsiElement)statements);
        replacementTextBuilder.insert(0, indentation);
        replacementTextBuilder.insert(0, "\n");
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = manager.getDocument(function.getContainingFile());
        if (document != null) {
            PsiElement element;
            PsiElement beforeStatements = statements.getPrevSibling();
            int offset = beforeStatements.getTextRange().getStartOffset();
            if (":".equals(beforeStatements.getText())) {
                ++offset;
            }
            try {
                document.insertString(offset, (CharSequence)replacementTextBuilder.toString());
            }
            finally {
                manager.commitDocument(document);
            }
            for (element = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)function); element != null && !element.getText().contains(replacementTextBuilder.toString()); element = element.getParent()) {
            }
            if (element != null) {
                TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(element);
                for (Pair template : templates) {
                    builder.replaceRange(TextRange.from((int)(offset - element.getTextRange().getStartOffset() + replacementTextBuilder.toString().indexOf(35) + (Integer)template.first), (int)((String)template.second).length()), (String)template.second);
                }
                PyAnnotateTypesIntention.startTemplate(project, element, builder);
            }
        }
    }

    private static void startTemplate(Project project, PsiElement callable, TemplateBuilder builder) {
        int offset = callable.getTextRange().getStartOffset();
        Editor targetEditor = PythonUiService.getInstance().openTextEditor(project, callable.getContainingFile().getVirtualFile(), offset);
        if (targetEditor != null) {
            builder.run(targetEditor, true);
        } else {
            builder.runNonInteractively(true);
        }
    }

    private static boolean isPy3k(PsiFile file) {
        return !LanguageLevel.forElement((PsiElement)file).isPython2();
    }

    private static void generatePy3kTypeAnnotations(@NotNull Project project, Editor editor2, @NotNull PyFunction function) {
        int i;
        if (project == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(5);
        }
        if (function == null) {
            PyAnnotateTypesIntention.$$$reportNull$$$0(6);
        }
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)function);
        PyExpression returnType = SpecifyTypeInPy3AnnotationsIntention.annotateReturnType(project, function, false);
        if (returnType != null) {
            builder.replaceElement((PsiElement)returnType, returnType.getText());
        }
        PyParameter[] params = function.getParameterList().getParameters();
        for (i = params.length - 1; i >= 0; --i) {
            if (!(params[i] instanceof PyNamedParameter) || params[i].isSelf()) continue;
            params[i] = SpecifyTypeInPy3AnnotationsIntention.annotateParameter(project, editor2, (PyNamedParameter)params[i], false);
        }
        for (i = params.length - 1; i >= 0; --i) {
            PyExpression annotationValue;
            if (!(params[i] instanceof PyNamedParameter) || params[i].isSelf()) continue;
            params[i] = (PyParameter)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)params[i]);
            PyAnnotation annotation = ((PyNamedParameter)params[i]).getAnnotation();
            if (annotation == null || (annotationValue = annotation.getValue()) == null) continue;
            builder.replaceElement((PsiElement)annotationValue, annotationValue.getText());
        }
        PyAnnotateTypesIntention.startTemplate(project, function, builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyAnnotateTypesIntention";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyAnnotateTypesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableFunction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePy3kTypeAnnotations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

