/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.Interner;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateBundleToLoad;
import org.jetbrains.plugins.textmate.TextMateBundlesLoader;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.TextMateServiceImplKt;
import org.jetbrains.plugins.textmate.TextMateServiceImplKtKt;
import org.jetbrains.plugins.textmate.bundles.BundleReaderKt;
import org.jetbrains.plugins.textmate.bundles.BundleType;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.bundles.TextMateFileNameMatcher;
import org.jetbrains.plugins.textmate.bundles.TextMateGrammar;
import org.jetbrains.plugins.textmate.bundles.TextMatePreferences;
import org.jetbrains.plugins.textmate.bundles.VSCBundleReaderKt;
import org.jetbrains.plugins.textmate.configuration.TextMateBuiltinBundlesSettings;
import org.jetbrains.plugins.textmate.configuration.TextMatePersistentBundle;
import org.jetbrains.plugins.textmate.configuration.TextMateUserBundlesSettings;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtilsKt;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.preferences.TextMateTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTextAttributesAdapter;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.plist.Plist;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0007H\u0002J\b\u0010#\u001a\u00020 H\u0002J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u0011H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\rH\u0016J\u0014\u0010.\u001a\u0004\u0018\u00010,2\b\u0010/\u001a\u0004\u0018\u00010\rH\u0016J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\u0011H\u0016J\u0014\u00101\u001a\u0004\u0018\u0001022\b\u00103\u001a\u0004\u0018\u000104H\u0016J\b\u00105\u001a\u00020 H\u0002J&\u00106\u001a\u00020\u00072\b\u00103\u001a\u0004\u0018\u0001042\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r07H\u0002J\u0010\u00108\u001a\u00020 2\u0006\u00109\u001a\u000202H\u0002J\u0010\u0010:\u001a\u00020 2\u0006\u00109\u001a\u000202H\u0002J$\u0010;\u001a\u00020 2\u0006\u00109\u001a\u0002022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r07H\u0002J\u0012\u0010<\u001a\u00020 2\b\u0010=\u001a\u0004\u0018\u00010>H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u001b\u001a\u0015\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\r0\r0\u001c\u00a2\u0006\u0002\b\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/plugins/textmate/TextMateServiceImpl;", "Lorg/jetbrains/plugins/textmate/TextMateService;", "myScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "builtinBundlesDisabled", "", "isInitialized", "registrationLock", "Ljava/util/concurrent/locks/ReentrantLock;", "customHighlightingColors", "Ljava/util/HashMap;", "", "Lorg/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateTextAttributesAdapter;", "Lkotlin/collections/HashMap;", "extensionMapping", "", "Lorg/jetbrains/plugins/textmate/bundles/TextMateFileNameMatcher;", "syntaxTable", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable;", "snippetRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/SnippetsRegistryImpl;", "preferenceRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryImpl;", "shellVariablesRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistryImpl;", "interner", "Lcom/intellij/util/containers/Interner;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "reloadEnabledBundles", "", "registerBundles", "fireEvents", "unregisterAllBundles", "getCustomHighlightingColors", "getShellVariableRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry;", "getSnippetRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/SnippetsRegistry;", "getPreferenceRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry;", "getLanguageDescriptorByFileName", "Lorg/jetbrains/plugins/textmate/language/TextMateLanguageDescriptor;", "fileName", "getLanguageDescriptorByExtension", "extension", "getFileNameMatcherToScopeNameMapping", "readBundle", "Lorg/jetbrains/plugins/textmate/bundles/TextMateBundleReader;", "directory", "Ljava/nio/file/Path;", "ensureInitialized", "registerBundle", "", "registerSnippets", "reader", "registerPreferences", "registerLanguageSupport", "disableBuiltinBundles", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.textmate"})
@SourceDebugExtension(value={"SMAP\nTextMateServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateServiceImpl.kt\norg/jetbrains/plugins/textmate/TextMateServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n774#2:373\n865#2,2:374\n1611#2,9:376\n1863#2:385\n1864#2:387\n1620#2:388\n1628#2,3:389\n1628#2,3:392\n1628#2,3:395\n1#3:386\n*S KotlinDebug\n*F\n+ 1 TextMateServiceImpl.kt\norg/jetbrains/plugins/textmate/TextMateServiceImpl\n*L\n85#1:373\n85#1:374,2\n98#1:376,9\n98#1:385\n98#1:387\n98#1:388\n271#1:389,3\n279#1:392,3\n287#1:395,3\n98#1:386\n*E\n"})
public final class TextMateServiceImpl
extends TextMateService {
    @NotNull
    private final CoroutineScope myScope;
    private boolean builtinBundlesDisabled;
    private volatile boolean isInitialized;
    @NotNull
    private final ReentrantLock registrationLock;
    @NotNull
    private final HashMap<CharSequence, TextMateTextAttributesAdapter> customHighlightingColors;
    @NotNull
    private Map<TextMateFileNameMatcher, ? extends CharSequence> extensionMapping;
    @NotNull
    private final TextMateSyntaxTable syntaxTable;
    @NotNull
    private final SnippetsRegistryImpl snippetRegistry;
    @NotNull
    private final PreferencesRegistryImpl preferenceRegistry;
    @NotNull
    private final ShellVariablesRegistryImpl shellVariablesRegistry;
    @NotNull
    private final Interner<CharSequence> interner;

    public TextMateServiceImpl(@NotNull CoroutineScope myScope) {
        Intrinsics.checkNotNullParameter((Object)myScope, (String)"myScope");
        this.myScope = myScope;
        this.registrationLock = new ReentrantLock();
        this.customHighlightingColors = new HashMap();
        Map map = Map.of();
        Intrinsics.checkNotNullExpressionValue(map, (String)"of(...)");
        this.extensionMapping = map;
        this.syntaxTable = new TextMateSyntaxTable();
        this.snippetRegistry = new SnippetsRegistryImpl();
        this.preferenceRegistry = new PreferencesRegistryImpl();
        this.shellVariablesRegistry = new ShellVariablesRegistryImpl();
        Interner interner = Interner.createWeakInterner();
        Intrinsics.checkNotNullExpressionValue((Object)interner, (String)"createWeakInterner(...)");
        this.interner = interner;
        Application app = ApplicationManager.getApplication();
        Runnable checkCancelled = app == null || app.isUnitTestMode() ? null : TextMateServiceImpl::_init_$lambda$0;
        SyntaxMatchUtils.setCheckCancelledCallback(checkCancelled);
    }

    @Override
    public void reloadEnabledBundles() {
        this.registerBundles(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void registerBundles(boolean fireEvents) {
        this.registrationLock.lock();
        try {
            Iterable $this$filter$iv;
            Iterable<TextMateBundleToLoad> builtInBundles;
            TextMateBuiltinBundlesSettings builtinBundlesSettings;
            TextMateUserBundlesSettings textMateUserBundlesSettings;
            Map<TextMateFileNameMatcher, ? extends CharSequence> oldExtensionsMapping = this.extensionMapping;
            this.unregisterAllBundles();
            if (TextMateUserBundlesSettings.Companion.getInstance() == null) {
                return;
            }
            TextMateUserBundlesSettings settings = textMateUserBundlesSettings;
            ConcurrentHashMap newExtensionsMapping = new ConcurrentHashMap();
            if (!this.builtinBundlesDisabled && (builtinBundlesSettings = TextMateBuiltinBundlesSettings.Companion.getInstance()) != null) {
                Iterable<TextMateBundleToLoad> iterable;
                Set<String> turnedOffBundleNames = builtinBundlesSettings.getTurnedOffBundleNames();
                builtInBundles = TextMateServiceImplKt.discoverBuiltinBundles(builtinBundlesSettings);
                if (turnedOffBundleNames.isEmpty()) {
                    iterable = builtInBundles;
                } else {
                    void $this$filterTo$iv$iv;
                    $this$filter$iv = builtInBundles;
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        TextMateBundleToLoad it = (TextMateBundleToLoad)element$iv$iv;
                        boolean bl = false;
                        if (!(!turnedOffBundleNames.contains(it.getName()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    iterable = (List)destination$iv$iv;
                }
                Iterable<TextMateBundleToLoad> bundlesToEnable = iterable;
                TextMateBundlesLoader.registerBundlesInParallel$default(this.myScope, bundlesToEnable, arg_0 -> TextMateServiceImpl.registerBundles$lambda$2(this, newExtensionsMapping, arg_0), null, 8, null);
            }
            Map<String, TextMatePersistentBundle> userBundles = settings.getBundles();
            List<TextMateBundleToLoad> bundlesToLoad = TextMateServiceImplKtKt.getPluginBundles(this);
            if (!userBundles.isEmpty()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                builtInBundles = userBundles.entrySet();
                List<TextMateBundleToLoad> list = bundlesToLoad;
                boolean $i$f$mapNotNull = false;
                $this$filter$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    TextMateBundleToLoad it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    boolean bl2 = false;
                    if ((((TextMatePersistentBundle)entry.getValue()).getEnabled() ? new TextMateBundleToLoad(((TextMatePersistentBundle)entry.getValue()).getName(), (String)entry.getKey()) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list.addAll((List)destination$iv$iv);
            }
            if (!bundlesToLoad.isEmpty()) {
                TextMateBundlesLoader.registerBundlesInParallel(this.myScope, bundlesToLoad, (Function1<? super TextMateBundleToLoad, Boolean>)((Function1)arg_0 -> TextMateServiceImpl.registerBundles$lambda$4(this, newExtensionsMapping, arg_0)), arg_0 -> TextMateServiceImpl.registerBundles$lambda$6(settings, arg_0));
            }
            if (fireEvents && !Intrinsics.areEqual(oldExtensionsMapping, newExtensionsMapping)) {
                TextMateServiceImplKt.access$fireFileTypesChangedEvent("old mappings = " + oldExtensionsMapping + ", new mappings" + newExtensionsMapping, () -> TextMateServiceImpl.registerBundles$lambda$7(this, newExtensionsMapping));
            } else {
                this.extensionMapping = Map.copyOf(newExtensionsMapping);
            }
            this.syntaxTable.compact();
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    private final void unregisterAllBundles() {
        this.extensionMapping = Map.of();
        this.preferenceRegistry.clear();
        this.customHighlightingColors.clear();
        this.syntaxTable.clear();
        this.snippetRegistry.clear();
        this.shellVariablesRegistry.clear();
    }

    @Override
    @NotNull
    public Map<CharSequence, TextMateTextAttributesAdapter> getCustomHighlightingColors() {
        this.ensureInitialized();
        return this.customHighlightingColors;
    }

    @Override
    @NotNull
    public ShellVariablesRegistry getShellVariableRegistry() {
        this.ensureInitialized();
        return this.shellVariablesRegistry;
    }

    @Override
    @NotNull
    public SnippetsRegistry getSnippetRegistry() {
        this.ensureInitialized();
        return this.snippetRegistry;
    }

    @Override
    @NotNull
    public PreferencesRegistry getPreferenceRegistry() {
        this.ensureInitialized();
        return this.preferenceRegistry;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByFileName(@NotNull CharSequence fileName) {
        CharSequence scopeName;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (Strings.isEmpty((CharSequence)fileName)) {
            return null;
        }
        this.ensureInitialized();
        String string = ((Object)fileName).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        CharSequence charSequence = scopeName = this.extensionMapping.get(new TextMateFileNameMatcher.Name(string));
        if (!(charSequence == null || charSequence.length() == 0)) {
            return new TextMateLanguageDescriptor(scopeName, this.syntaxTable.getSyntax(scopeName));
        }
        Iterator extensionsIterator = TextMateEditorUtilsKt.fileNameExtensions(fileName).iterator();
        while (extensionsIterator.hasNext()) {
            TextMateLanguageDescriptor descriptor = this.getLanguageDescriptorByExtension((CharSequence)extensionsIterator.next());
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByExtension(@Nullable CharSequence extension) {
        CharSequence scopeName;
        if (Strings.isEmpty((CharSequence)extension)) {
            return null;
        }
        this.ensureInitialized();
        String string = StringUtil.toLowerCase((String)String.valueOf(extension));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        CharSequence charSequence = scopeName = this.extensionMapping.get(new TextMateFileNameMatcher.Extension(string));
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : new TextMateLanguageDescriptor(scopeName, this.syntaxTable.getSyntax(scopeName));
    }

    @Override
    @NotNull
    public Map<TextMateFileNameMatcher, CharSequence> getFileNameMatcherToScopeNameMapping() {
        this.ensureInitialized();
        return this.extensionMapping;
    }

    @Override
    @Nullable
    public TextMateBundleReader readBundle(@Nullable Path directory) {
        if (directory != null) {
            BundleType bundleType = BundleType.Companion.detectBundleType(directory);
            return switch (WhenMappings.$EnumSwitchMapping$0[bundleType.ordinal()]) {
                case 1 -> BundleReaderKt.readTextMateBundle(directory);
                case 2 -> BundleReaderKt.readSublimeBundle(directory);
                case 3 -> VSCBundleReaderKt.readVSCBundle((Function1<? super String, ? extends InputStream>)((Function1)arg_0 -> TextMateServiceImpl.readBundle$lambda$8(directory, arg_0)));
                case 4 -> null;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureInitialized() {
        if (!this.isInitialized) {
            this.registrationLock.lock();
            try {
                if (this.isInitialized) {
                    return;
                }
                this.registerBundles(false);
                this.isInitialized = true;
            }
            finally {
                this.registrationLock.unlock();
            }
        }
    }

    private final boolean registerBundle(Path directory, Map<TextMateFileNameMatcher, CharSequence> extensionMapping) {
        TextMateBundleReader reader = this.readBundle(directory);
        if (reader != null) {
            this.registerLanguageSupport(reader, extensionMapping);
            this.registerPreferences(reader);
            this.registerSnippets(reader);
            return true;
        }
        return false;
    }

    private final void registerSnippets(TextMateBundleReader reader) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Iterator snippetsIterator = reader.readSnippets().iterator();
            while (snippetsIterator.hasNext()) {
                this.snippetRegistry.register((TextMateSnippet)snippetsIterator.next());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerPreferences(TextMateBundleReader reader) {
        for (TextMatePreferences preferences : reader.readPreferences()) {
            Set set;
            Set internedSmartTypingPairs;
            Set internedHighlightingPairs;
            Object object;
            Iterable destination$iv;
            Object object2 = this.interner.intern((Object)preferences.getScopeName());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"intern(...)");
            CharSequence scopeName = (CharSequence)object2;
            Set<TextMateBracePair> set2 = preferences.getHighlightingPairs();
            if (set2 != null) {
                Set<TextMateBracePair> pairs = set2;
                boolean bl = false;
                if (pairs.isEmpty()) {
                    v2 = SetsKt.emptySet();
                } else {
                    void $this$mapTo$iv;
                    Iterable iterable = pairs;
                    destination$iv = new HashSet(pairs.size());
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        TextMateBracePair textMateBracePair = (TextMateBracePair)item$iv;
                        object = destination$iv;
                        boolean bl2 = false;
                        Object object3 = this.interner.intern((Object)it.getLeft());
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"intern(...)");
                        CharSequence charSequence = (CharSequence)object3;
                        Object object4 = this.interner.intern((Object)it.getRight());
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"intern(...)");
                        object.add(new TextMateBracePair(charSequence, (CharSequence)object4));
                    }
                    v2 = (Set)destination$iv;
                }
            } else {
                v2 = internedHighlightingPairs = null;
            }
            if (preferences.getSmartTypingPairs() != null) {
                Set<TextMateAutoClosingPair> pairs;
                boolean bl = false;
                if (pairs.isEmpty()) {
                    v6 = SetsKt.emptySet();
                } else {
                    void $this$mapTo$iv;
                    Object item$iv;
                    destination$iv = pairs;
                    Collection destination$iv2 = new HashSet(pairs.size());
                    boolean $i$f$mapTo = false;
                    item$iv = $this$mapTo$iv.iterator();
                    while (item$iv.hasNext()) {
                        void it;
                        Object item$iv2 = item$iv.next();
                        object = (TextMateAutoClosingPair)item$iv2;
                        Collection bl2 = destination$iv2;
                        boolean bl3 = false;
                        Object object5 = this.interner.intern((Object)it.getLeft());
                        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"intern(...)");
                        CharSequence charSequence = (CharSequence)object5;
                        Object object6 = this.interner.intern((Object)it.getRight());
                        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"intern(...)");
                        bl2.add(new TextMateAutoClosingPair(charSequence, (CharSequence)object6, it.getNotIn()));
                    }
                    v6 = (Set)destination$iv2;
                }
            } else {
                v6 = internedSmartTypingPairs = null;
            }
            if (preferences.getSurroundingPairs() != null) {
                Set<TextMateBracePair> pairs;
                boolean bl = false;
                if (pairs.isEmpty()) {
                    set = SetsKt.emptySet();
                } else {
                    void $this$mapTo$iv;
                    Iterable destination$iv2 = pairs;
                    Collection destination$iv3 = new HashSet(pairs.size());
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        TextMateBracePair bl2 = (TextMateBracePair)item$iv;
                        Collection collection = destination$iv3;
                        boolean bl4 = false;
                        Object object7 = this.interner.intern((Object)it.getLeft());
                        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"intern(...)");
                        CharSequence charSequence = (CharSequence)object7;
                        Object object8 = this.interner.intern((Object)it.getRight());
                        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"intern(...)");
                        collection.add(new TextMateBracePair(charSequence, (CharSequence)object8));
                    }
                    set = (Set)destination$iv3;
                }
            } else {
                set = null;
            }
            Set internedSurroundingPairs = set;
            this.preferenceRegistry.addPreferences(new Preferences(scopeName, internedHighlightingPairs, internedSmartTypingPairs, internedSurroundingPairs, preferences.getAutoCloseBefore(), preferences.getIndentationRules(), preferences.getOnEnterRules()));
            for (TextMateShellVariable variable : preferences.getVariables()) {
                this.shellVariablesRegistry.addVariable(variable);
            }
            TextMateTextAttributes customHighlightingAttributes = preferences.getCustomHighlightingAttributes();
            if (customHighlightingAttributes == null) continue;
            this.customHighlightingColors.put(scopeName, new TextMateTextAttributesAdapter(scopeName, customHighlightingAttributes));
        }
    }

    private final void registerLanguageSupport(TextMateBundleReader reader, Map<TextMateFileNameMatcher, CharSequence> extensionMapping) {
        for (TextMateGrammar grammar : reader.readGrammars()) {
            if (this.syntaxTable.loadSyntax((Plist)grammar.getPlist().getValue(), this.interner) == null) continue;
            for (TextMateFileNameMatcher fileNameMatcher : grammar.getFileNameMatchers()) {
                CharSequence charSequence;
                CharSequence rootScopeName;
                if (fileNameMatcher instanceof TextMateFileNameMatcher.Name) {
                    String newName;
                    Intrinsics.checkNotNullExpressionValue((Object)((TextMateFileNameMatcher.Name)fileNameMatcher).getFileName().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    charSequence = extensionMapping.put(((TextMateFileNameMatcher.Name)fileNameMatcher).copy(newName), rootScopeName);
                    continue;
                }
                charSequence = extensionMapping.put(fileNameMatcher, rootScopeName);
            }
        }
    }

    @TestOnly
    public final void disableBuiltinBundles(@Nullable Disposable disposable) {
        this.builtinBundlesDisabled = true;
        this.reloadEnabledBundles();
        this.isInitialized = true;
        Disposable disposable2 = disposable;
        Intrinsics.checkNotNull((Object)disposable2);
        Disposer.register((Disposable)disposable2, () -> TextMateServiceImpl.disableBuiltinBundles$lambda$15(this));
    }

    private static final void _init_$lambda$0() {
        ProgressManager.checkCanceled();
    }

    private static final boolean registerBundles$lambda$2(TextMateServiceImpl this$0, ConcurrentHashMap $newExtensionsMapping, TextMateBundleToLoad it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.registerBundle(Path.of(it.getPath(), new String[0]), $newExtensionsMapping);
    }

    private static final boolean registerBundles$lambda$4(TextMateServiceImpl this$0, ConcurrentHashMap $newExtensionsMapping, TextMateBundleToLoad bundleToLoad) {
        Intrinsics.checkNotNullParameter((Object)bundleToLoad, (String)"bundleToLoad");
        return this$0.registerBundle(Path.of(bundleToLoad.getPath(), new String[0]), $newExtensionsMapping);
    }

    private static final void registerBundles$lambda$6$lambda$5(TextMateUserBundlesSettings $settings, TextMateBundleToLoad $bundleToLoad) {
        $settings.disableBundle($bundleToLoad.getPath());
    }

    private static final void registerBundles$lambda$6(TextMateUserBundlesSettings $settings, TextMateBundleToLoad bundleToLoad) {
        Intrinsics.checkNotNullParameter((Object)bundleToLoad, (String)"bundleToLoad");
        String bundleName = bundleToLoad.getName();
        Object[] objectArray = new Object[]{bundleName};
        String string = TextMateBundle.message("textmate.cant.register.bundle", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String errorMessage = string;
        Object[] objectArray2 = new Object[]{bundleName};
        Notification notification = new Notification("TextMate Bundles", TextMateBundle.message("textmate.bundle.load.error", objectArray2), errorMessage, NotificationType.ERROR);
        objectArray2 = new Object[]{bundleName};
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)TextMateBundle.message("textmate.disable.bundle.notification.action", objectArray2), () -> TextMateServiceImpl.registerBundles$lambda$6$lambda$5($settings, bundleToLoad))).notify(null);
    }

    private static final void registerBundles$lambda$7(TextMateServiceImpl this$0, ConcurrentHashMap $newExtensionsMapping) {
        this$0.extensionMapping = Map.copyOf($newExtensionsMapping);
    }

    private static final InputStream readBundle$lambda$8(Path $directory, String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        try {
            return Files.newInputStream($directory.resolve(relativePath), new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            TextMateService.LOG.warn("Cannot find referenced file `" + relativePath + "` in bundle `" + $directory + "`");
            return null;
        }
        catch (Throwable e) {
            TextMateService.LOG.warn("Cannot read referenced file `" + relativePath + "` in bundle `" + $directory + "`", e);
            return null;
        }
    }

    private static final void disableBuiltinBundles$lambda$15(TextMateServiceImpl this$0) {
        this$0.builtinBundlesDisabled = false;
        this$0.unregisterAllBundles();
        this$0.isInitialized = false;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BundleType.values().length];
            try {
                nArray[BundleType.TEXTMATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.SUBLIME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.VSCODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.UNDEFINED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

