/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.parser.property;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CSSParseException;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.parser.property.AbstractPropertyBuilder;
import com.openhtmltopdf.css.parser.property.PageSize;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.List;

public class SizePropertyBuilder
extends AbstractPropertyBuilder {
    private static final CSSName[] ALL = new CSSName[]{CSSName.FS_PAGE_ORIENTATION, CSSName.FS_PAGE_HEIGHT, CSSName.FS_PAGE_WIDTH};

    @Override
    public List<PropertyDeclaration> buildDeclarations(CSSName cssName, List<PropertyValue> values, int origin, boolean important, boolean inheritAllowed) {
        this.checkValueCount(cssName, 1, 2, values.size());
        ArrayList<PropertyDeclaration> result2 = new ArrayList<PropertyDeclaration>(3);
        if (values.size() == 1) {
            PropertyValue value2 = values.get(0);
            this.checkInheritAllowed(value2, inheritAllowed);
            if (value2.getCssValueType() == 0) {
                return this.checkInheritAll(ALL, values, origin, important, inheritAllowed);
            }
            if (value2.getPrimitiveType() == 21) {
                PageSize pageSize = PageSize.getPageSize(value2.getStringValue());
                if (pageSize != null) {
                    result2.add(new PropertyDeclaration(CSSName.FS_PAGE_ORIENTATION, new PropertyValue(IdentValue.AUTO), important, origin));
                    result2.add(new PropertyDeclaration(CSSName.FS_PAGE_WIDTH, pageSize.getPageWidth(), important, origin));
                    result2.add(new PropertyDeclaration(CSSName.FS_PAGE_HEIGHT, pageSize.getPageHeight(), important, origin));
                    return result2;
                }
                IdentValue ident = this.checkIdent(cssName, value2);
                if (ident == IdentValue.LANDSCAPE || ident == IdentValue.PORTRAIT) {
                    result2.add(new PropertyDeclaration(CSSName.FS_PAGE_ORIENTATION, value2, important, origin));
                    result2.add(new PropertyDeclaration(CSSName.FS_PAGE_WIDTH, new PropertyValue(IdentValue.AUTO), important, origin));
                    result2.add(new PropertyDeclaration(CSSName.FS_PAGE_HEIGHT, new PropertyValue(IdentValue.AUTO), important, origin));
                    return result2;
                }
                if (ident == IdentValue.AUTO) {
                    result2.add(new PropertyDeclaration(CSSName.FS_PAGE_ORIENTATION, value2, important, origin));
                    result2.add(new PropertyDeclaration(CSSName.FS_PAGE_WIDTH, value2, important, origin));
                    result2.add(new PropertyDeclaration(CSSName.FS_PAGE_HEIGHT, value2, important, origin));
                    return result2;
                }
                throw new CSSParseException("Identifier " + ident + " is not a valid value for " + cssName, -1);
            }
            if (this.isLength(value2)) {
                if (value2.getFloatValue() < 0.0f) {
                    throw new CSSParseException("A page dimension may not be negative", -1);
                }
                result2.add(new PropertyDeclaration(CSSName.FS_PAGE_ORIENTATION, new PropertyValue(IdentValue.AUTO), important, origin));
                result2.add(new PropertyDeclaration(CSSName.FS_PAGE_WIDTH, value2, important, origin));
                result2.add(new PropertyDeclaration(CSSName.FS_PAGE_HEIGHT, value2, important, origin));
                return result2;
            }
            throw new CSSParseException("Value for " + cssName + " must be a length or identifier", -1);
        }
        PropertyValue value1 = values.get(0);
        PropertyValue value2 = values.get(1);
        this.checkInheritAllowed(value2, false);
        if (this.isLength(value1) && this.isLength(value2)) {
            if (value1.getFloatValue() < 0.0f) {
                throw new CSSParseException("A page dimension may not be negative", -1);
            }
            if (value2.getFloatValue() < 0.0f) {
                throw new CSSParseException("A page dimension may not be negative", -1);
            }
            result2.add(new PropertyDeclaration(CSSName.FS_PAGE_ORIENTATION, new PropertyValue(IdentValue.AUTO), important, origin));
            result2.add(new PropertyDeclaration(CSSName.FS_PAGE_WIDTH, value1, important, origin));
            result2.add(new PropertyDeclaration(CSSName.FS_PAGE_HEIGHT, value2, important, origin));
            return result2;
        }
        if (value1.getPrimitiveType() == 21 && value2.getPrimitiveType() == 21) {
            if (value2.getStringValue().equals("landscape") || value2.getStringValue().equals("portrait")) {
                PropertyValue temp = value1;
                value1 = value2;
                value2 = temp;
            }
            if (!value1.toString().equals("landscape") && !value1.toString().equals("portrait")) {
                throw new CSSParseException("Value " + value1 + " is not a valid page orientation", -1);
            }
            result2.add(new PropertyDeclaration(CSSName.FS_PAGE_ORIENTATION, value1, important, origin));
            PageSize pageSize = PageSize.getPageSize(value2.getStringValue());
            if (pageSize == null) {
                throw new CSSParseException("Value " + value1 + " is not a valid page size", -1);
            }
            result2.add(new PropertyDeclaration(CSSName.FS_PAGE_WIDTH, pageSize.getPageWidth(), important, origin));
            result2.add(new PropertyDeclaration(CSSName.FS_PAGE_HEIGHT, pageSize.getPageHeight(), important, origin));
            return result2;
        }
        throw new CSSParseException("Invalid value for size property", -1);
    }
}

