/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.noop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.language.Contributor;
import org.languagetool.noop.NoopChunker;
import org.languagetool.noop.NoopDisambiguator;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.xx.DemoTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;

public class NoopLanguage
extends Language {
    public static final String SHORT_CODE = "zz";

    @Override
    public Locale getLocale() {
        return new Locale("en");
    }

    @Override
    public Disambiguator createDefaultDisambiguator() {
        return new NoopDisambiguator();
    }

    @Override
    public String getName() {
        return "NoopLanguage";
    }

    @Override
    public String getShortCode() {
        return SHORT_CODE;
    }

    @Override
    public String[] getCountries() {
        return new String[0];
    }

    @Override
    @NotNull
    public Tagger createDefaultTagger() {
        return new DemoTagger();
    }

    @Override
    @Nullable
    public Chunker createDefaultChunker() {
        return new NoopChunker();
    }

    @Override
    public Contributor[] getMaintainers() {
        return null;
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) {
        return Collections.emptyList();
    }

    @Override
    protected synchronized List<AbstractPatternRule> getPatternRules() {
        return Collections.emptyList();
    }

    @Override
    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SentenceTokenizer(){

            @Override
            public List<String> tokenize(String text2) {
                return Collections.singletonList(text2);
            }

            @Override
            public void setSingleLineBreaksMarksParagraph(boolean lineBreakParagraphs) {
            }

            @Override
            public boolean singleLineBreaksMarksPara() {
                return false;
            }
        };
    }

    @Override
    public Tokenizer createDefaultWordTokenizer() {
        return text2 -> new ArrayList();
    }
}

