/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.FloatCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongFloatAssociativeContainer;
import com.carrotsearch.hppc.LongFloatMap;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.WormUtil;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.LongFloatPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.LongFloatProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongFloatWormMap
implements LongFloatMap,
Preallocable,
Cloneable,
Accountable {
    public long[] keys;
    public float[] values;
    public byte[] next;
    protected int size;
    protected int iterationSeed;

    public LongFloatWormMap() {
        this(4);
    }

    public LongFloatWormMap(int expectedElements) {
        if (expectedElements < 0) {
            throw new IllegalArgumentException("Invalid expectedElements=" + expectedElements);
        }
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public LongFloatWormMap(LongFloatAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    public static LongFloatWormMap from(long[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongFloatWormMap map = new LongFloatWormMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public LongFloatWormMap clone() {
        try {
            LongFloatWormMap cloneMap = (LongFloatWormMap)super.clone();
            cloneMap.keys = (long[])this.keys.clone();
            cloneMap.values = (float[])this.values.clone();
            cloneMap.next = (byte[])this.next.clone();
            cloneMap.iterationSeed = HashContainers.nextIterationSeed();
            return cloneMap;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public float noValue() {
        return 0.0f;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public float get(long key2) {
        int hashIndex = this.hashMod(key2);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return this.noValue();
        }
        int entryIndex = this.searchInChain(key2, hashIndex, nextOffset);
        return entryIndex < 0 ? this.noValue() : this.values[entryIndex];
    }

    @Override
    public float getOrDefault(long key2, float defaultValue) {
        float value = this.get(key2);
        return value == this.noValue() ? defaultValue : value;
    }

    @Override
    public float put(long key2, float value) {
        return this.put(key2, value, WormUtil.PutPolicy.NEW_OR_REPLACE, true);
    }

    @Override
    public int putAll(LongFloatAssociativeContainer container) {
        int initialSize = this.size();
        for (LongFloatCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - initialSize;
    }

    @Override
    public int putAll(Iterable<? extends LongFloatCursor> iterable) {
        int initialSize = this.size();
        for (LongFloatCursor longFloatCursor : iterable) {
            this.put(longFloatCursor.key, longFloatCursor.value);
        }
        return this.size() - initialSize;
    }

    @Override
    public float putOrAdd(long key2, float putValue, float incrementValue) {
        int keyIndex = this.indexOf(key2);
        if (this.indexExists(keyIndex)) {
            putValue = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key2, putValue);
        }
        return putValue;
    }

    @Override
    public float addTo(long key2, float additionValue) {
        return this.putOrAdd(key2, additionValue, additionValue);
    }

    @Override
    public boolean putIfAbsent(long key2, float value) {
        return this.noValue() == this.put(key2, value, WormUtil.PutPolicy.NEW_ONLY_IF_ABSENT, true);
    }

    @Override
    public float remove(long key2) {
        byte[] next = this.next;
        int hashIndex = this.hashMod(key2);
        byte nextOffset = next[hashIndex];
        if (nextOffset <= 0) {
            return this.noValue();
        }
        int previousEntryIndex = this.searchInChainReturnPrevious(key2, hashIndex, nextOffset);
        if (previousEntryIndex < 0) {
            return this.noValue();
        }
        int entryToRemoveIndex = previousEntryIndex == Integer.MAX_VALUE ? hashIndex : WormUtil.addOffset(previousEntryIndex, Math.abs(next[previousEntryIndex]), next.length);
        return this.remove(entryToRemoveIndex, previousEntryIndex);
    }

    @Override
    public int removeAll(LongContainer other) {
        int size = this.size();
        if (other.size() >= size && other instanceof LongLookupContainer) {
            long[] keys = this.keys;
            byte[] next = this.next;
            int capacity = next.length;
            int entryIndex = 0;
            while (entryIndex < capacity) {
                long key2;
                if (next[entryIndex] != 0 && other.contains(key2 = keys[entryIndex])) {
                    this.remove(key2);
                    continue;
                }
                ++entryIndex;
            }
        } else {
            for (LongCursor c : other) {
                this.remove(c.value);
            }
        }
        return size - this.size();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        long[] keys = this.keys;
        byte[] next = this.next;
        int capacity = next.length;
        int size = this.size();
        int entryIndex = 0;
        while (entryIndex < capacity) {
            long key2;
            if (next[entryIndex] != 0 && predicate.apply(key2 = keys[entryIndex])) {
                this.remove(key2);
                continue;
            }
            ++entryIndex;
        }
        return size - this.size();
    }

    @Override
    public int removeAll(LongFloatPredicate predicate) {
        long[] keys = this.keys;
        float[] values = this.values;
        byte[] next = this.next;
        int capacity = next.length;
        int size = this.size();
        int entryIndex = 0;
        while (entryIndex < capacity) {
            long key2;
            if (next[entryIndex] != 0 && predicate.apply(key2 = keys[entryIndex], values[entryIndex])) {
                this.remove(key2);
                continue;
            }
            ++entryIndex;
        }
        return size - this.size();
    }

    @Override
    public <T extends LongFloatProcedure> T forEach(T procedure) {
        long[] keys = this.keys;
        float[] values = this.values;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (next[slot] != 0) {
                procedure.apply(keys[slot], values[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends LongFloatPredicate> T forEach(T predicate) {
        long[] keys = this.keys;
        float[] values = this.values;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (next[slot] == 0 || predicate.apply(keys[slot], values[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public FloatCollection values() {
        return new ValuesContainer();
    }

    @Override
    public Iterator<LongFloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(long key2) {
        int hashIndex = this.hashMod(key2);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return false;
        }
        return this.searchInChain(key2, hashIndex, nextOffset) >= 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.next, (byte)0);
        this.size = 0;
    }

    @Override
    public void release() {
        this.keys = null;
        this.values = null;
        this.next = null;
        this.size = 0;
        this.ensureCapacity(4);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        int size = this.size;
        LongFloatMap map = (LongFloatMap)o;
        if (size != map.size()) {
            return false;
        }
        long[] keys = this.keys;
        float[] values = this.values;
        byte[] next = this.next;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (next[index] != 0) {
                if (Float.floatToIntBits(values[index]) != Float.floatToIntBits(map.get(keys[index]))) {
                    return false;
                }
                ++entryCount;
            }
            ++index;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int size = this.size;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (this.next[index] != 0) {
                hashCode += BitMixer.mixPhi(this.keys[index]) ^ BitMixer.mixPhi(this.values[index]);
                ++entryCount;
            }
            ++index;
        }
        return hashCode;
    }

    protected int hashKey(long key2) {
        return BitMixer.mixPhi(key2);
    }

    private int hashMod(long key2) {
        return this.hashKey(key2) & this.next.length - 1;
    }

    @Override
    public int indexOf(long key2) {
        int hashIndex = this.hashMod(key2);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return ~hashIndex;
        }
        return this.searchInChain(key2, hashIndex, nextOffset);
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < this.next.length);
        return index >= 0;
    }

    @Override
    public float indexGet(int index) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        return this.values[index];
    }

    @Override
    public float indexReplace(int index, float newValue) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        float previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, long key2, float value) {
        assert (index < 0) : "The index must not point at an existing key.";
        if (this.next[index ^= 0xFFFFFFFF] == 0) {
            this.keys[index] = key2;
            this.values[index] = value;
            this.next[index] = 127;
            ++this.size;
        } else {
            this.put(key2, value, WormUtil.PutPolicy.NEW_GUARANTEED, true);
        }
    }

    @Override
    public float indexRemove(int index) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        return this.remove(index, Integer.MAX_VALUE);
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append('[');
        int index = 0;
        int entryCount = 0;
        while (entryCount < this.size) {
            if (this.next[index] != 0) {
                if (entryCount > 0) {
                    sBuilder.append(", ");
                }
                sBuilder.append(this.keys[index]);
                sBuilder.append("=>");
                sBuilder.append(this.values[index]);
                ++entryCount;
            }
            ++index;
        }
        sBuilder.append(']');
        return sBuilder.toString();
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.allocateBuffers((int)((float)expectedElements / 0.75f));
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.next.length - 1, characters);
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowSizeOfArray(this.keys) + RamUsageEstimator.shallowSizeOfArray(this.values) + RamUsageEstimator.shallowSizeOfArray(this.next);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.values, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.next, this.size());
    }

    protected void allocateBuffers(int capacity) {
        capacity = Math.max(capacity, this.size);
        if ((capacity = Math.max(BitUtil.nextHighestPowerOfTwo(capacity), 4)) > 0x40000000) {
            throw new BufferAllocationException("Maximum array size exceeded (capacity: %d)", capacity);
        }
        if (this.keys != null && this.keys.length == capacity) {
            return;
        }
        long[] oldKeys = this.keys;
        float[] oldValues = this.values;
        byte[] oldNext = this.next;
        this.keys = new long[capacity];
        this.values = new float[capacity];
        this.next = new byte[capacity];
        if (oldKeys != null) {
            this.putOldEntries(oldKeys, oldValues, oldNext, this.size);
        }
    }

    private void putOldEntries(long[] oldKeys, float[] oldValues, byte[] oldNext, int entryNum) {
        int entryCount = 0;
        int endIndex = oldNext.length;
        for (int index = 0; entryCount < entryNum && index < endIndex; ++index) {
            if (oldNext[index] == 0) continue;
            long oldKey = oldKeys[index];
            int hashIndex = this.hashMod(oldKey);
            this.putNewEntry(hashIndex, this.next[hashIndex], oldKey, oldValues[index]);
            ++entryCount;
        }
    }

    private float put(long key2, float value, WormUtil.PutPolicy policy, boolean sizeIncrease) {
        int hashIndex = this.hashMod(key2);
        byte nextOffset = this.next[hashIndex];
        boolean added = false;
        if (nextOffset > 0 && policy != WormUtil.PutPolicy.NEW_GUARANTEED) {
            int entryIndex = this.searchInChain(key2, hashIndex, nextOffset);
            if (entryIndex >= 0) {
                float previousValue = this.values[entryIndex];
                if (policy != WormUtil.PutPolicy.NEW_ONLY_IF_ABSENT) {
                    this.values[entryIndex] = value;
                }
                return previousValue;
            }
            if (this.enlargeIfNeeded()) {
                hashIndex = this.hashMod(key2);
                nextOffset = this.next[hashIndex];
            } else {
                if (!this.appendTailOfChain(~entryIndex, key2, value)) {
                    this.enlargeAndPutNewEntry(key2, value);
                }
                added = true;
            }
        } else if (this.enlargeIfNeeded()) {
            hashIndex = this.hashMod(key2);
            nextOffset = this.next[hashIndex];
        }
        if (!added) {
            this.putNewEntry(hashIndex, nextOffset, key2, value);
        }
        if (sizeIncrease) {
            ++this.size;
        }
        return this.noValue();
    }

    private boolean enlargeIfNeeded() {
        if (this.size >= this.next.length) {
            this.allocateBuffers(this.next.length << 1);
            return true;
        }
        return false;
    }

    private void enlargeAndPutNewEntry(long key2, float value) {
        this.allocateBuffers(this.next.length << 1);
        this.put(key2, value, WormUtil.PutPolicy.NEW_GUARANTEED, false);
    }

    private float remove(int entryToRemoveIndex, int previousEntryIndex) {
        int lastIndex;
        assert (WormUtil.checkIndex(entryToRemoveIndex, this.next.length));
        assert (previousEntryIndex == Integer.MAX_VALUE || WormUtil.checkIndex(previousEntryIndex, this.next.length));
        byte[] next = this.next;
        float previousValue = this.values[entryToRemoveIndex];
        byte nextOffset = next[entryToRemoveIndex];
        int beforeLastIndex = WormUtil.findLastOfChain(entryToRemoveIndex, nextOffset, true, next);
        if (beforeLastIndex == -1) {
            lastIndex = entryToRemoveIndex;
            if (nextOffset < 0) {
                beforeLastIndex = previousEntryIndex == Integer.MAX_VALUE ? WormUtil.findPreviousInChain(entryToRemoveIndex, next) : previousEntryIndex;
                next[beforeLastIndex] = (byte)(next[beforeLastIndex] > 0 ? 127 : -127);
            }
        } else {
            byte beforeLastNextOffset = next[beforeLastIndex];
            lastIndex = WormUtil.addOffset(beforeLastIndex, Math.abs(beforeLastNextOffset), next.length);
            assert (entryToRemoveIndex != lastIndex);
            this.keys[entryToRemoveIndex] = this.keys[lastIndex];
            this.values[entryToRemoveIndex] = this.values[lastIndex];
            next[beforeLastIndex] = (byte)(beforeLastNextOffset > 0 ? 127 : -127);
        }
        this.keys[lastIndex] = 0L;
        this.values[lastIndex] = this.noValue();
        next[lastIndex] = 0;
        --this.size;
        return previousValue;
    }

    private boolean appendTailOfChain(int lastEntryIndex, long key2, float value) {
        return this.appendTailOfChain(lastEntryIndex, key2, value, WormUtil.ExcludedIndexes.NONE, 0);
    }

    private boolean appendTailOfChain(int lastEntryIndex, long key2, float value, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        int capacity = this.next.length;
        int searchFromIndex = WormUtil.addOffset(lastEntryIndex, 1, capacity);
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, WormUtil.maxOffset(capacity), -1, this.next);
        if (freeIndex == -1 && (freeIndex = this.searchAndMoveBucket(searchFromIndex, WormUtil.maxOffset(capacity), excludedIndexes, recursiveCallLevel)) == -1) {
            return false;
        }
        this.keys[freeIndex] = key2;
        this.values[freeIndex] = value;
        this.next[freeIndex] = -127;
        int nextOffset = WormUtil.getOffsetBetweenIndexes(lastEntryIndex, freeIndex, this.next.length);
        this.next[lastEntryIndex] = (byte)(this.next[lastEntryIndex] > 0 ? nextOffset : -nextOffset);
        return true;
    }

    private int searchAndMoveBucket(int fromIndex, int range, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        assert (WormUtil.checkIndex(fromIndex, this.next.length));
        assert (range >= 0 && range <= WormUtil.maxOffset(this.next.length)) : "range=" + range + ", maxOffset=" + WormUtil.maxOffset(this.next.length);
        int remainingAttempts = WormUtil.RECURSIVE_MOVE_ATTEMPTS[recursiveCallLevel];
        if (remainingAttempts <= 0 || range <= 0) {
            return -1;
        }
        byte[] next = this.next;
        int capacity = next.length;
        int nextRecursiveCallLevel = recursiveCallLevel + 1;
        for (int index = fromIndex + range - 1; index >= fromIndex; --index) {
            byte nextOffset;
            int rolledIndex = index & capacity - 1;
            if (excludedIndexes.isIndexExcluded(rolledIndex) || (nextOffset = next[rolledIndex]) >= 0) continue;
            if (this.moveTailOfChain(rolledIndex, nextOffset, excludedIndexes, nextRecursiveCallLevel)) {
                return rolledIndex;
            }
            if (--remainingAttempts > 0) continue;
            return -1;
        }
        return -1;
    }

    private void putNewEntry(int hashIndex, int nextOffset, long key2, float value) {
        assert (hashIndex == this.hashMod(key2)) : "hashIndex=" + hashIndex + ", hashReduce(key)=" + this.hashMod(key2);
        assert (WormUtil.checkIndex(hashIndex, this.next.length));
        assert (Math.abs(nextOffset) <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[hashIndex]) : "nextOffset=" + nextOffset + ", next[hashIndex]=" + this.next[hashIndex];
        if (nextOffset > 0) {
            if (!this.appendTailOfChain(WormUtil.findLastOfChain(hashIndex, nextOffset, false, this.next), key2, value)) {
                this.enlargeAndPutNewEntry(key2, value);
            }
        } else {
            if (nextOffset < 0 && !this.moveTailOfChain(hashIndex, nextOffset, WormUtil.ExcludedIndexes.NONE, 0)) {
                this.enlargeAndPutNewEntry(key2, value);
                return;
            }
            this.keys[hashIndex] = key2;
            this.values[hashIndex] = value;
            this.next[hashIndex] = 127;
        }
    }

    private boolean moveTailOfChain(int tailIndex, int nextOffset, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        boolean nextIndexWithinRange;
        int searchRange;
        int searchFromIndex;
        assert (WormUtil.checkIndex(tailIndex, this.next.length));
        assert (nextOffset < 0 && nextOffset >= -127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[tailIndex]) : "nextOffset=" + nextOffset + ", next[tailIndex]=" + this.next[tailIndex];
        byte[] next = this.next;
        int capacity = next.length;
        int maxOffset = WormUtil.maxOffset(capacity);
        int previousIndex = WormUtil.findPreviousInChain(tailIndex, next);
        int absPreviousOffset = Math.abs(next[previousIndex]);
        int nextIndex = nextOffset == -127 ? -1 : WormUtil.addOffset(tailIndex, -nextOffset, capacity);
        int offsetFromPreviousToNext = absPreviousOffset - nextOffset;
        if (offsetFromPreviousToNext <= maxOffset) {
            searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
            searchRange = offsetFromPreviousToNext - 1;
            nextIndexWithinRange = true;
        } else {
            if (nextIndex == -1) {
                searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
                searchRange = maxOffset;
            } else {
                searchFromIndex = WormUtil.addOffset(nextIndex, -maxOffset, capacity);
                int searchToIndex = WormUtil.addOffset(previousIndex, maxOffset, capacity);
                searchRange = WormUtil.getOffsetBetweenIndexes(searchFromIndex, searchToIndex, capacity) + 1;
            }
            nextIndexWithinRange = false;
        }
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, searchRange, tailIndex, next);
        if (freeIndex == -1) {
            if (nextIndexWithinRange && this.appendTailOfChain(WormUtil.findLastOfChain(nextIndex, next[nextIndex], false, next), this.keys[tailIndex], this.values[tailIndex], excludedIndexes, recursiveCallLevel)) {
                int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, nextIndex, capacity);
                next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
                return true;
            }
            WormUtil.ExcludedIndexes recursiveExcludedIndexes = excludedIndexes.union(WormUtil.ExcludedIndexes.fromChain(previousIndex, next));
            freeIndex = this.searchAndMoveBucket(searchFromIndex, searchRange, recursiveExcludedIndexes, recursiveCallLevel);
            if (freeIndex == -1) {
                return false;
            }
        }
        this.keys[freeIndex] = this.keys[tailIndex];
        this.values[freeIndex] = this.values[tailIndex];
        next[freeIndex] = (byte)(nextOffset == -127 ? nextOffset : -WormUtil.getOffsetBetweenIndexes(freeIndex, nextIndex, capacity));
        int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, freeIndex, capacity);
        next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
        assert (next[freeIndex] < 0) : "freeIndex=" + freeIndex + ", next[freeIndex]=" + next[freeIndex];
        return true;
    }

    private int searchInChain(long key2, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (this.keys[index] == key2) {
            return index;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            if (this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)] == key2) {
                return index;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    private int searchInChainReturnPrevious(long key2, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (this.keys[index] == key2) {
            return Integer.MAX_VALUE;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            int previousIndex = index;
            if (this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)] == key2) {
                return previousIndex;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        @Override
        public boolean contains(long e) {
            return LongFloatWormMap.this.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            LongFloatWormMap.this.forEach((key2, value) -> procedure.apply(key2));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            LongFloatWormMap.this.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return LongFloatWormMap.this.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return LongFloatWormMap.this.size();
        }

        @Override
        public void clear() {
            LongFloatWormMap.this.clear();
        }

        @Override
        public void release() {
            LongFloatWormMap.this.release();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return LongFloatWormMap.this.removeAll(predicate);
        }

        @Override
        public int removeAll(long e) {
            return LongFloatWormMap.this.remove(e) == LongFloatWormMap.this.noValue() ? 0 : 1;
        }
    }

    private class ValuesContainer
    extends AbstractFloatCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return LongFloatWormMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return LongFloatWormMap.this.isEmpty();
        }

        @Override
        public boolean contains(float value) {
            for (LongFloatCursor c : LongFloatWormMap.this) {
                if (Float.floatToIntBits(value) != Float.floatToIntBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            for (LongFloatCursor c : LongFloatWormMap.this) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            for (LongFloatCursor c : LongFloatWormMap.this) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(float e) {
            return LongFloatWormMap.this.removeAll((long key2, float value) -> Float.floatToIntBits(e) == Float.floatToIntBits(value));
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            return LongFloatWormMap.this.removeAll((long key2, float value) -> predicate.apply(value));
        }

        @Override
        public void clear() {
            LongFloatWormMap.this.clear();
        }

        @Override
        public void release() {
            LongFloatWormMap.this.release();
        }
    }

    private class EntryIterator
    extends AbstractIterator<LongFloatCursor> {
        private final LongFloatCursor cursor = new LongFloatCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = LongFloatWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongFloatWormMap.this.next.length - 1;
        }

        @Override
        protected LongFloatCursor fetch() {
            int mask = LongFloatWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (LongFloatWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.key = LongFloatWormMap.this.keys[this.slot];
                this.cursor.value = LongFloatWormMap.this.values[this.slot];
                return this.cursor;
            }
            return (LongFloatCursor)this.done();
        }
    }

    private class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = LongFloatWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongFloatWormMap.this.next.length - 1;
        }

        @Override
        protected FloatCursor fetch() {
            int mask = LongFloatWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (LongFloatWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = LongFloatWormMap.this.values[this.slot];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }

    private class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = LongFloatWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongFloatWormMap.this.next.length - 1;
        }

        @Override
        protected LongCursor fetch() {
            int mask = LongFloatWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (LongFloatWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = LongFloatWormMap.this.keys[this.slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

