/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.suggesters;

import com.intellij.lang.Language;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.NoSuggestion;
import training.featuresSuggester.SuggesterSupport;
import training.featuresSuggester.SuggestingUtilsKt;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.actions.BeforeCompletionChooseItemAction;
import training.featuresSuggester.actions.BeforeEditorTextInsertedAction;
import training.featuresSuggester.actions.BeforeEditorTextRemovedAction;
import training.featuresSuggester.actions.EditorEscapeAction;
import training.featuresSuggester.suggesters.AbstractFeatureSuggester;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0002%&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001c\u0010 \u001a\u00020\u0019*\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0011H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Ltraining/featuresSuggester/suggesters/CompletionPopupSuggester;", "Ltraining/featuresSuggester/suggesters/AbstractFeatureSuggester;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "suggestingActionDisplayName", "getSuggestingActionDisplayName", "message", "getMessage", "suggestingActionId", "getSuggestingActionId", "suggestingTipId", "getSuggestingTipId", "minSuggestingIntervalDays", "", "getMinSuggestingIntervalDays", "()I", "languages", "", "getLanguages", "()Ljava/util/List;", "forceCheckForStatistics", "", "getForceCheckForStatistics", "()Z", "getSuggestion", "Ltraining/featuresSuggester/Suggestion;", "action", "Ltraining/featuresSuggester/actions/Action;", "isInsideCommentOrLiteral", "Ltraining/featuresSuggester/SuggesterSupport;", "psiFile", "Lcom/intellij/psi/PsiFile;", "offset", "State", "Companion", "intellij.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nCompletionPopupSuggester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionPopupSuggester.kt\ntraining/featuresSuggester/suggesters/CompletionPopupSuggester\n+ 2 SuggestingUtils.kt\ntraining/featuresSuggester/SuggestingUtilsKt\n*L\n1#1,114:1\n72#2:115\n*S KotlinDebug\n*F\n+ 1 CompletionPopupSuggester.kt\ntraining/featuresSuggester/suggesters/CompletionPopupSuggester\n*L\n107#1:115\n*E\n"})
public final class CompletionPopupSuggester
extends AbstractFeatureSuggester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String suggestingActionDisplayName = FeatureSuggesterBundle.INSTANCE.message("completion.popup.name", new Object[0]);
    @NotNull
    private final String message = FeatureSuggesterBundle.INSTANCE.message("completion.popup.message", new Object[0]);
    @NotNull
    private final String suggestingActionId;
    @NotNull
    private final String suggestingTipId = this.getSuggestingActionId();
    private final int minSuggestingIntervalDays;
    @NotNull
    private final List<String> languages;
    private final boolean forceCheckForStatistics;
    public static final long MAX_TIME_MILLIS_BETWEEN_ACTIONS = 5000L;

    public CompletionPopupSuggester() {
        this.id = "Completion";
        this.suggestingActionId = "CodeCompletion";
        this.minSuggestingIntervalDays = 14;
        Object[] objectArray = new String[]{"JAVA", "kotlin", "Python", "JavaScript", "ECMAScript 6"};
        this.languages = CollectionsKt.listOf((Object[])objectArray);
        this.forceCheckForStatistics = true;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getSuggestingActionDisplayName() {
        return this.suggestingActionDisplayName;
    }

    @Override
    @NotNull
    protected String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    protected String getSuggestingActionId() {
        return this.suggestingActionId;
    }

    @Override
    @NotNull
    protected String getSuggestingTipId() {
        return this.suggestingTipId;
    }

    @Override
    public int getMinSuggestingIntervalDays() {
        return this.minSuggestingIntervalDays;
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        return this.languages;
    }

    @Override
    public boolean getForceCheckForStatistics() {
        return this.forceCheckForStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Suggestion getSuggestion(@NotNull Action action) {
        block18: {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Language language = action.getLanguage();
            if (language == null) {
                return NoSuggestion.INSTANCE;
            }
            Language language2 = language;
            SuggesterSupport suggesterSupport = SuggesterSupport.Companion.getForLanguage(language2);
            if (suggesterSupport == null) {
                return NoSuggestion.INSTANCE;
            }
            SuggesterSupport langSupport = suggesterSupport;
            Action action2 = action;
            if (action2 instanceof BeforeEditorTextRemovedAction) {
                if (Intrinsics.areEqual((Object)((BeforeEditorTextRemovedAction)action).getTextFragment().getText(), (Object)".")) {
                    State.INSTANCE.reset();
                    PsiFile psiFile = ((BeforeEditorTextRemovedAction)action).getPsiFile();
                    if (psiFile == null) {
                        return NoSuggestion.INSTANCE;
                    }
                    PsiFile psiFile2 = psiFile;
                    if (!this.isInsideCommentOrLiteral(langSupport, psiFile2, ((BeforeEditorTextRemovedAction)action).getCaretOffset())) {
                        State.INSTANCE.applyDotRemoving(((BeforeEditorTextRemovedAction)action).getCaretOffset(), ((BeforeEditorTextRemovedAction)action).getTimeMillis());
                    }
                }
            } else if (action2 instanceof BeforeEditorTextInsertedAction) {
                if (Intrinsics.areEqual((Object)((BeforeEditorTextInsertedAction)action).getText(), (Object)".")) {
                    if (State.INSTANCE.isDotRemoved() && ((BeforeEditorTextInsertedAction)action).getCaretOffset() == State.INSTANCE.getDotOffset() && !State.INSTANCE.isOutOfDate(((BeforeEditorTextInsertedAction)action).getTimeMillis())) {
                        State.INSTANCE.applyCompletionStarting(((BeforeEditorTextInsertedAction)action).getTimeMillis());
                    } else {
                        State.INSTANCE.reset();
                    }
                }
            } else {
                if (action2 instanceof BeforeCompletionChooseItemAction) {
                    try {
                        if (State.INSTANCE.isCompletionStarted() && State.INSTANCE.isAroundDot(((BeforeCompletionChooseItemAction)action).getCaretOffset()) && !State.INSTANCE.isOutOfDate(((BeforeCompletionChooseItemAction)action).getTimeMillis())) {
                            Suggestion suggestion = this.createSuggestion();
                            return suggestion;
                        }
                        break block18;
                    }
                    finally {
                        State.INSTANCE.reset();
                    }
                }
                if (action2 instanceof EditorEscapeAction) {
                    State.INSTANCE.reset();
                }
            }
        }
        return NoSuggestion.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInsideCommentOrLiteral(SuggesterSupport $this$isInsideCommentOrLiteral, PsiFile psiFile, int offset) {
        PsiElement psiElement = psiFile.findElementAt(offset);
        if (psiElement == null) {
            return false;
        }
        PsiElement curElement = psiElement;
        if (SuggestingUtilsKt.getParentByPredicate(curElement, (Function1<? super PsiElement, Boolean>)((Function1)new Function1<PsiElement, Boolean>((Object)$this$isInsideCommentOrLiteral){

            public final Boolean invoke(PsiElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SuggesterSupport)this.receiver).isLiteralExpression(p0);
            }
        })) != null) return true;
        PsiElement $this$getParentOfType$iv = curElement;
        boolean $i$f$getParentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiComment.class) == null) return false;
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltraining/featuresSuggester/suggesters/CompletionPopupSuggester$Companion;", "", "<init>", "()V", "MAX_TIME_MILLIS_BETWEEN_ACTIONS", "", "intellij.featuresTrainer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\fJ\u0006\u0010\u0019\u001a\u00020\u0012R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001a"}, d2={"Ltraining/featuresSuggester/suggesters/CompletionPopupSuggester$State;", "", "<init>", "()V", "value", "", "dotOffset", "getDotOffset", "()I", "", "isCompletionStarted", "()Z", "", "lastChangeTimeMillis", "getLastChangeTimeMillis", "()J", "isDotRemoved", "applyDotRemoving", "", "offset", "timeMillis", "applyCompletionStarting", "isAroundDot", "isOutOfDate", "newChangeTimeMillis", "reset", "intellij.featuresTrainer"})
    private static final class State {
        @NotNull
        public static final State INSTANCE = new State();
        private static int dotOffset = -1;
        private static boolean isCompletionStarted;
        private static long lastChangeTimeMillis;

        private State() {
        }

        public final int getDotOffset() {
            return dotOffset;
        }

        public final boolean isCompletionStarted() {
            return isCompletionStarted;
        }

        public final long getLastChangeTimeMillis() {
            return lastChangeTimeMillis;
        }

        public final boolean isDotRemoved() {
            return dotOffset != -1;
        }

        public final void applyDotRemoving(int offset, long timeMillis) {
            dotOffset = offset;
            lastChangeTimeMillis = timeMillis;
        }

        public final void applyCompletionStarting(long timeMillis) {
            isCompletionStarted = true;
            lastChangeTimeMillis = timeMillis;
        }

        public final boolean isAroundDot(int offset) {
            int n = dotOffset;
            return offset <= dotOffset + 7 ? n <= offset : false;
        }

        public final boolean isOutOfDate(long newChangeTimeMillis) {
            return newChangeTimeMillis - lastChangeTimeMillis > 5000L;
        }

        public final void reset() {
            dotOffset = -1;
            isCompletionStarted = false;
            lastChangeTimeMillis = 0L;
        }
    }
}

