/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.assertj.core.util.Sets;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.query.ComponentParentQuery;
import org.assertj.swing.util.Maps;

class WindowEventQueueMapping {
    final Map<EventQueue, Map<Window, Boolean>> queueMap = Maps.newWeakHashMap();

    WindowEventQueueMapping() {
    }

    void addQueueFor(@Nonnull Toolkit toolkit) {
        WeakHashMap map = Maps.newWeakHashMap();
        this.queueMap.put(toolkit.getSystemEventQueue(), map);
    }

    void addQueueFor(@Nonnull Component component2) {
        EventQueue queue = component2.getToolkit().getSystemEventQueue();
        Map<Window, Boolean> windowMapping = this.queueMap.get(queue);
        if (windowMapping == null) {
            windowMapping = this.createWindowMapping(queue);
        }
        if (!(component2 instanceof Window) || ComponentParentQuery.parentOf(component2) != null) {
            return;
        }
        windowMapping.put((Window)component2, Boolean.TRUE);
    }

    @Nonnull
    private Map<Window, Boolean> createWindowMapping(EventQueue queue) {
        WeakHashMap<Window, Boolean> windowMapping = Maps.newWeakHashMap();
        this.queueMap.put(queue, windowMapping);
        return windowMapping;
    }

    @RunsInCurrentThread
    void removeMappingFor(@Nonnull Component component2) {
        EventQueue queue = component2.getToolkit().getSystemEventQueue();
        this.removeComponent(component2, queue);
        for (EventQueue q : this.queueMap.keySet()) {
            this.removeComponent(component2, q);
        }
    }

    private void removeComponent(@Nonnull Component component2, @Nonnull EventQueue queue) {
        Map<Window, Boolean> windowMapping = this.queueMap.get(queue);
        if (windowMapping != null) {
            windowMapping.remove(component2);
        }
    }

    @Nonnull
    Collection<Window> windows() {
        HashSet rootWindows = Sets.newHashSet();
        for (EventQueue queue : this.queueMap.keySet()) {
            rootWindows.addAll(this.queueMap.get(queue).keySet());
        }
        return rootWindows;
    }

    @Nonnull
    Collection<EventQueue> eventQueues() {
        return this.queueMap.keySet();
    }
}

